/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.enablement;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.enablement.AdjustmentContext;
import org.eclipse.cdt.managedbuilder.internal.enablement.AndExpression;

public class OptionEnablementExpression
extends AndExpression {
    public static final String NAME = "enablement";
    public static final String TYPE = "type";
    public static final String TYPE_UI_VISIBILITY = "UI_VISIBILITY";
    public static final String TYPE_UI_ENABLEMENT = "UI_ENABLEMENT";
    public static final String TYPE_CMD_USAGE = "CMD_USAGE";
    public static final String TYPE_CONTAINER_ATTRIBUTE = "CONTAINER_ATTRIBUTE";
    public static final String TYPE_ALL = "ALL";
    public static final String FLAG_DELIMITER = "|";
    public static final String ATTRIBUTE = "attribute";
    public static final String VALUE = "value";
    public static final String EXTENSION_ADJUSTMENT = "extensionAdjustment";
    public static final String YES = "yes";
    public static final String TRUE = "true";
    private static final String[] fSupportedOptionAttributes = new String[]{"command", "commandFalse", "value", "defaultValue"};
    private static final String[] fSupportedToolChainAttributes = new String[]{"targetTool"};
    private static final String[] fSupportedConfigurationAttributes = new String[]{"artifactExtension", "artifactName"};
    public static final int FLAG_UI_VISIBILITY = 1;
    public static final int FLAG_UI_ENABLEMENT = 2;
    public static final int FLAG_CMD_USAGE = 4;
    public static final int FLAG_CONTAINER_ATTRIBUTE = 8;
    public static final int FLAG_ALL = -1;
    private int fEnablementFlags;
    private String fAttribute;
    private String fValue;
    private boolean fIsExtensionAdjustment;

    public OptionEnablementExpression(IManagedConfigElement element) {
        super(element);
        this.fEnablementFlags = this.calculateFlags(element.getAttribute(TYPE));
        this.fAttribute = element.getAttribute(ATTRIBUTE);
        this.fValue = element.getAttribute(VALUE);
        String tmp = element.getAttribute(EXTENSION_ADJUSTMENT);
        this.adjustAttributeSupport();
        this.fIsExtensionAdjustment = tmp != null ? OptionEnablementExpression.getBooleanValue(tmp) : !this.checkFlags(8);
    }

    private void adjustAttributeSupport() {
        boolean cleanAttrFlag = true;
        if (this.fAttribute != null && this.fValue != null) {
            int i = 0;
            while (i < fSupportedOptionAttributes.length) {
                if (this.fAttribute.equals(fSupportedOptionAttributes[i])) {
                    cleanAttrFlag = false;
                    break;
                }
                ++i;
            }
            if (cleanAttrFlag) {
                i = 0;
                while (i < fSupportedToolChainAttributes.length) {
                    if (this.fAttribute.equals(fSupportedToolChainAttributes[i])) {
                        cleanAttrFlag = false;
                        break;
                    }
                    ++i;
                }
            }
            if (cleanAttrFlag) {
                i = 0;
                while (i < fSupportedConfigurationAttributes.length) {
                    if (this.fAttribute.equals(fSupportedConfigurationAttributes[i])) {
                        cleanAttrFlag = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (cleanAttrFlag) {
            this.fEnablementFlags &= 0xFFFFFFF7;
            this.fAttribute = null;
            this.fValue = null;
        }
    }

    public String[] convertToList(String value, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        int delLength = delimiter.length();
        int valLength = value.length();
        if (delLength == 0) {
            list.add(value);
        } else {
            int start = 0;
            while (start < valLength) {
                int stop = value.indexOf(delimiter, start);
                if (stop == -1) {
                    stop = valLength;
                }
                String subst = value.substring(start, stop);
                list.add(subst);
                start = stop + delLength;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    protected int calculateFlags(String flagsString) {
        int flags = 0;
        if (flagsString != null) {
            String[] strings = this.convertToList(flagsString, FLAG_DELIMITER);
            int i = 0;
            while (i < strings.length) {
                String str = strings[i].trim();
                if (TYPE_UI_VISIBILITY.equals(str)) {
                    flags |= 1;
                } else if (TYPE_UI_ENABLEMENT.equals(str)) {
                    flags |= 2;
                } else if (TYPE_CMD_USAGE.equals(str)) {
                    flags |= 4;
                } else if (TYPE_CONTAINER_ATTRIBUTE.equals(str)) {
                    flags |= 8;
                } else if (TYPE_ALL.equals(str)) {
                    flags |= 0xFFFFFFFF;
                }
                ++i;
            }
        }
        if (flags == 0) {
            flags = -1;
        }
        return flags;
    }

    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOption option, int flags) {
        return this.evaluate(rcInfo, holder, option, flags, (8 & flags) == 0);
    }

    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOption option, int flags, boolean bDefault) {
        return this.checkFlags(flags) ? this.evaluate(rcInfo, holder, option) : bDefault;
    }

    public boolean checkFlags(int flags) {
        return (this.fEnablementFlags & flags) == flags;
    }

    public int getFlags() {
        return this.fEnablementFlags;
    }

    private static IOption getOptionToSet(IHoldsOptions holder, IOption option, String value, boolean extensionAdjustment) {
        IOption optionToSet = null;
        if (value != null) {
            try {
                optionToSet = holder.getOptionToSet(option, extensionAdjustment);
            }
            catch (BuildException buildException) {}
        } else if (!extensionAdjustment && option.getOptionHolder() == holder) {
            optionToSet = option;
        }
        return optionToSet;
    }

    public static boolean adjustOption(IResourceInfo rcInfo, IHoldsOptions holder, IOption option, String attribute, String value, boolean extensionAdjustment) {
        if (value == null && rcInfo.isExtensionElement()) {
            return false;
        }
        IOption setOption = OptionEnablementExpression.getOptionToSet(holder, option, value, extensionAdjustment);
        if (setOption == null) {
            return false;
        }
        boolean adjusted = true;
        try {
            if ("command".equals(attribute)) {
                setOption.setCommand(value);
            } else if ("commandFalse".equals(attribute)) {
                setOption.setCommandFalse(value);
            } else if (VALUE.equals(attribute)) {
                switch (setOption.getValueType()) {
                    case 0: {
                        IOption superOption;
                        Boolean bValue;
                        Boolean bl = bValue = value != null ? Boolean.valueOf(value) : null;
                        if (extensionAdjustment) {
                            setOption.setValue(bValue);
                            break;
                        }
                        if (bValue == null && (superOption = setOption.getSuperClass()) != null) {
                            bValue = superOption.getBooleanValue();
                        }
                        if (bValue != null) {
                            ManagedBuildManager.setOption(rcInfo, holder, setOption, (boolean)bValue);
                            break;
                        }
                        setOption.setValue((Object)null);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 12: {
                        if (extensionAdjustment) {
                            setOption.setValue(value);
                            break;
                        }
                        ManagedBuildManager.setOption(rcInfo, holder, setOption, value);
                        break;
                    }
                    case -11: 
                    case -10: 
                    case -9: 
                    case -8: 
                    case -5: 
                    case -4: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        adjusted = false;
                    }
                }
            } else if ("defaultValue".equals(attribute)) {
                switch (setOption.getValueType()) {
                    case 0: {
                        Boolean bValue = value != null ? Boolean.valueOf(value) : null;
                        setOption.setDefaultValue(bValue);
                        break;
                    }
                    case 1: 
                    case 2: {
                        setOption.setDefaultValue(value);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        adjusted = false;
                    }
                }
            } else {
                adjusted = false;
            }
        }
        catch (BuildException e) {
            adjusted = false;
        }
        return adjusted;
    }

    public boolean adjustOption(IResourceInfo rcInfo, IHoldsOptions holder, IOption option, AdjustmentContext context, boolean extensionAdjustment) {
        if (!this.canPerformAdjustment(extensionAdjustment)) {
            return false;
        }
        boolean needed = this.adjustmentNeeded(rcInfo, holder, option);
        if (context != null) {
            context.addAdjustedState(this.fAttribute, needed);
        }
        if (needed) {
            return OptionEnablementExpression.adjustOption(rcInfo, holder, option, this.fAttribute, this.fValue, extensionAdjustment);
        }
        return false;
    }

    private boolean adjustmentNeeded(IResourceInfo rcInfo, IHoldsOptions holder, IOption option) {
        return this.evaluate(rcInfo, holder, option, 8);
    }

    private boolean adjustmentNeeded(IFolderInfo info, IToolChain tChain) {
        return this.adjustmentNeeded(info, tChain, null);
    }

    private boolean adjustmentNeeded(IResourceInfo info, ITool tool) {
        return this.adjustmentNeeded(info, tool, null);
    }

    private boolean adjustmentNeeded(IConfiguration cfg) {
        return this.adjustmentNeeded(cfg.getRootFolderInfo(), null, null);
    }

    public static boolean adjustToolChain(IFolderInfo info, IToolChain tChain, String attrbute, String value, boolean extensionAdjustment) {
        if (value == null && tChain.isExtensionElement()) {
            return false;
        }
        boolean adjusted = true;
        if ("targetTool".equals(attrbute)) {
            tChain.setTargetToolIds(value);
        } else {
            adjusted = false;
        }
        return adjusted;
    }

    public boolean adjustToolChain(IFolderInfo info, IToolChain tChain, AdjustmentContext context, boolean extensionAdjustment) {
        if (!this.canPerformAdjustment(extensionAdjustment)) {
            return false;
        }
        boolean needed = this.adjustmentNeeded(info, tChain);
        if (context != null) {
            context.addAdjustedState(this.fAttribute, needed);
        }
        if (needed) {
            return OptionEnablementExpression.adjustToolChain(info, tChain, this.fAttribute, this.fValue, extensionAdjustment);
        }
        return false;
    }

    public static boolean adjustTool(IResourceInfo info, ITool tool, String attribute, String value, boolean extensionAdjustment) {
        if (value == null && tool.isExtensionElement()) {
            return false;
        }
        return false;
    }

    public boolean adjustTool(IResourceInfo info, ITool tool, AdjustmentContext context, boolean extensionAdjustment) {
        if (!this.canPerformAdjustment(extensionAdjustment)) {
            return false;
        }
        boolean needed = this.adjustmentNeeded(info, tool);
        if (context != null) {
            context.addAdjustedState(this.fAttribute, needed);
        }
        if (needed) {
            return OptionEnablementExpression.adjustTool(info, tool, this.fAttribute, this.fValue, extensionAdjustment);
        }
        return false;
    }

    public static boolean adjustConfiguration(IConfiguration cfg, String attribute, String value, boolean extensionAdjustment) {
        if (value == null && cfg.isExtensionElement()) {
            return false;
        }
        boolean adjusted = true;
        if ("artifactExtension".equals(attribute)) {
            cfg.setArtifactExtension(value);
        } else if ("artifactName".equals(attribute)) {
            cfg.setArtifactName(value);
        } else {
            adjusted = false;
        }
        return adjusted;
    }

    public boolean adjustConfiguration(IConfiguration cfg, AdjustmentContext context, boolean extensionAdjustment) {
        if (!this.canPerformAdjustment(extensionAdjustment)) {
            return false;
        }
        boolean needed = this.adjustmentNeeded(cfg);
        if (context != null) {
            context.addAdjustedState(this.fAttribute, needed);
        }
        if (needed) {
            return OptionEnablementExpression.adjustConfiguration(cfg, this.fAttribute, this.fValue, extensionAdjustment);
        }
        return false;
    }

    public boolean canPerformAdjustment(boolean extensionAdjustment) {
        return this.fIsExtensionAdjustment == extensionAdjustment && this.checkFlags(8);
    }

    public static boolean getBooleanValue(String value) {
        if (TRUE.equalsIgnoreCase(value)) {
            return true;
        }
        return YES.equalsIgnoreCase(value);
    }
}

