/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.help;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.help.CFunctionSummary;
import org.eclipse.cdt.internal.ui.help.CHelpTopic;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.help.IHelpResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CHelpEntry {
    private static final String ATTR_KEYWD = "keyword";
    private static final String NODE_TOPIC = "topic";
    private static final String NODE_FSUMM = "functionSummary";
    private String keyword = null;
    private boolean isValid = true;
    private CHelpTopic[] hts = null;
    private CFunctionSummary[] fss = null;

    public CHelpEntry(Element e) {
        this.keyword = e.getAttribute(ATTR_KEYWD).trim();
        ArrayList<CFunctionSummary> obs1 = new ArrayList<CFunctionSummary>();
        ArrayList<CHelpTopic> obs2 = new ArrayList<CHelpTopic>();
        NodeList list = e.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                if (NODE_FSUMM.equals(node.getNodeName())) {
                    obs1.add(new CFunctionSummary((Element)node, this.keyword));
                } else if (NODE_TOPIC.equals(node.getNodeName())) {
                    obs2.add(new CHelpTopic((Element)node, this.keyword));
                }
            }
            ++i;
        }
        this.fss = obs1.toArray(new CFunctionSummary[obs1.size()]);
        this.hts = obs2.toArray(new CHelpTopic[obs2.size()]);
        if (this.fss.length == 0 && this.hts.length == 0) {
            this.isValid = false;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public IFunctionSummary[] getFunctionSummary() {
        return this.fss;
    }

    public IHelpResource[] getHelpResource() {
        return this.hts;
    }

    public String toString() {
        return "<entry keyword=\"" + this.keyword + "\">";
    }
}

