/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ValidatingLabeledTextField
extends Composite {
    private static final String EMPTY_STRING = "";
    private final Map<Text, Boolean> validationStatus = new HashMap<Text, Boolean>();
    private final ArrayList<Listener> inputTextListeners = new ArrayList();
    private final Color errorColor = new Color((Device)this.getShell().getDisplay(), new RGB(255, 208, 196));

    public ValidatingLabeledTextField(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
    }

    public ValidatingLabeledTextField(Composite parent) {
        this(parent, 0);
    }

    public void addElement(String description, String initialText, boolean readOnly, final Validator validator) {
        Label label = new Label((Composite)this, 0);
        label.setText(description);
        label.setLayoutData((Object)new GridData(32));
        final Text textField = new Text((Composite)this, 2052);
        textField.setText(initialText);
        textField.setLayoutData((Object)new GridData(768));
        if (readOnly) {
            this.validationStatus.put(textField, Boolean.TRUE);
            textField.setEnabled(false);
            return;
        }
        this.validationStatus.put(textField, Boolean.FALSE);
        final Label errorImageLabel = new Label((Composite)this, 0);
        errorImageLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        errorImageLabel.setLayoutData((Object)new GridData());
        errorImageLabel.setVisible(false);
        final Label errorLabel = new Label((Composite)this, 0);
        errorLabel.setLayoutData((Object)new GridData());
        final Color defaultColor = textField.getBackground();
        Listener listener = new Listener(){

            public void checkField() {
                boolean isOk;
                String newName = textField.getText();
                boolean isEmpty = newName.length() == 0;
                boolean isNameAlreadyInUse = this.nameAlreadyInUse(textField, newName);
                boolean isValid = validator.isValidInput(newName);
                boolean isKeyword = NameHelper.isKeyword(newName);
                boolean isEmptyAllowed = validator.emptyAllowed();
                boolean isValidName = isEmpty && isEmptyAllowed || NameHelper.isValidLocalVariableName(newName);
                boolean bl = isOk = isValid && !isNameAlreadyInUse && !isKeyword && isValidName;
                if (isOk) {
                    this.setErrorStatus(ValidatingLabeledTextField.EMPTY_STRING);
                } else if (isEmpty && !isEmptyAllowed) {
                    this.setErrorStatus(validator.errorMessageForEmptyField());
                } else if (!isValid || !isValidName) {
                    this.setErrorStatus(validator.errorMessageForInvalidInput());
                } else if (isKeyword) {
                    this.setErrorStatus(validator.errorIsKeywordMessage());
                } else if (isNameAlreadyInUse) {
                    this.setErrorStatus(validator.errorMessageForDuplicateValues());
                }
                ValidatingLabeledTextField.this.validationStatus.put(textField, isOk);
                if (ValidatingLabeledTextField.this.validationStatus.values().contains(Boolean.FALSE) || isEmpty && !isEmptyAllowed || isNameAlreadyInUse || isKeyword || !isValidName) {
                    validator.hasErrors();
                } else {
                    validator.hasNoErrors();
                }
                ValidatingLabeledTextField.this.layout();
                ValidatingLabeledTextField.this.inputTextListeners.remove(this);
                for (Listener listener : (ArrayList)ValidatingLabeledTextField.this.inputTextListeners.clone()) {
                    listener.handleEvent(null);
                }
                ValidatingLabeledTextField.this.inputTextListeners.add(this);
            }

            private boolean nameAlreadyInUse(Text textField2, String newName) {
                for (Text text : ValidatingLabeledTextField.this.validationStatus.keySet()) {
                    if (text == textField2 || !text.getText().equals(newName)) continue;
                    return true;
                }
                return false;
            }

            private void setErrorStatus(String errorMessage) {
                if (ValidatingLabeledTextField.EMPTY_STRING.equals(errorMessage)) {
                    textField.setBackground(defaultColor);
                    errorLabel.setText(ValidatingLabeledTextField.EMPTY_STRING);
                    errorImageLabel.setVisible(false);
                } else {
                    textField.setBackground(ValidatingLabeledTextField.this.errorColor);
                    errorLabel.setText(errorMessage);
                    errorImageLabel.setVisible(true);
                }
            }

            public void handleEvent(Event event) {
                this.checkField();
            }
        };
        this.inputTextListeners.add(listener);
        listener.handleEvent(null);
        textField.addListener(24, listener);
    }

    public static abstract class Validator {
        public void hasErrors() {
        }

        public void hasNoErrors() {
        }

        public boolean emptyAllowed() {
            return true;
        }

        public boolean isValidInput(String text) {
            return true;
        }

        public String errorMessageForEmptyField() {
            return Messages.ValidatingLabeledTextField_CantBeEmpty;
        }

        public String errorMessageForInvalidInput() {
            return Messages.ValidatingLabeledTextField_InvalidCharacters;
        }

        public String errorMessageForDuplicateValues() {
            return Messages.ValidatingLabeledTextField_DuplicatedNames;
        }

        public String errorIsKeywordMessage() {
            return Messages.ValidatingLabeledTextField_IsKeyword;
        }
    }
}

