/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.dialogs;

import org.eclipse.cdt.internal.ui.refactoring.dialogs.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class VisibilitySelectionPanel
extends Composite {
    private Button publicAccessRadioButton;
    private Button protectedAccessRadioButton;
    private Button privateAccessRadioButton;
    private Group accessModifierGroup;

    public VisibilitySelectionPanel(Composite parent, VisibilityEnum defaultVisibility, int style) {
        super(parent, style);
        FillLayout compositeLayout = new FillLayout(256);
        this.setLayout((Layout)compositeLayout);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalAlignment = 4;
        this.setLayoutData(gridData);
        this.createAccessModifierComposite(this);
        this.setSelected(defaultVisibility);
    }

    private void createAccessModifierComposite(Composite control) {
        this.accessModifierGroup = new Group((Composite)this, 32);
        RowLayout groupLayout = new RowLayout(256);
        groupLayout.fill = true;
        this.accessModifierGroup.setLayout((Layout)groupLayout);
        this.accessModifierGroup.setText(Messages.VisibilitySelectionPanel_AccessModifier);
        this.publicAccessRadioButton = new Button((Composite)this.accessModifierGroup, 16400);
        this.publicAccessRadioButton.setText(VisibilityEnum.v_public.toString());
        this.protectedAccessRadioButton = new Button((Composite)this.accessModifierGroup, 16400);
        this.protectedAccessRadioButton.setText(VisibilityEnum.v_protected.toString());
        this.privateAccessRadioButton = new Button((Composite)this.accessModifierGroup, 16400);
        this.privateAccessRadioButton.setText(VisibilityEnum.v_private.toString());
    }

    private void setSelected(VisibilityEnum defaultVisibility) {
        switch (defaultVisibility) {
            case v_public: {
                this.publicAccessRadioButton.setSelection(true);
                break;
            }
            case v_protected: {
                this.protectedAccessRadioButton.setSelection(true);
                break;
            }
            case v_private: {
                this.privateAccessRadioButton.setSelection(true);
            }
        }
    }

    public Group getGroup() {
        return this.accessModifierGroup;
    }

    public void setEnabled(boolean enabled) {
        this.accessModifierGroup.setEnabled(enabled);
        this.publicAccessRadioButton.setEnabled(enabled);
        this.protectedAccessRadioButton.setEnabled(enabled);
        this.privateAccessRadioButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

