/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.refactoring.rename.HeaderFileReferenceAdjuster;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameParticipantHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;

public class HeaderFileMoveParticipant
extends MoveParticipant
implements ISharableParticipant {
    private Map<IResource, MoveArguments> movedResources;
    private Change change;

    protected boolean initialize(Object element) {
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return this.movedResources != null;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        if (element instanceof IResource && arguments instanceof MoveArguments) {
            if (this.movedResources == null) {
                this.movedResources = new HashMap<IResource, MoveArguments>();
            }
            this.movedResources.put((IResource)element, (MoveArguments)arguments);
        }
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        try {
            if (this.movedResources == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)Status.OK_STATUS);
                return refactoringStatus;
            }
            try {
                final HashMap<IFile, IFile> movedFiles = new HashMap<IFile, IFile>();
                for (Map.Entry<IResource, MoveArguments> entry : this.movedResources.entrySet()) {
                    IContainer destination;
                    IPath destinationLocation;
                    Object destinationResource;
                    IResource movedResource = entry.getKey();
                    MoveArguments args = entry.getValue();
                    if (!args.getUpdateReferences() || movedResource.isLinked() || !((destinationResource = args.getDestination()) instanceof IContainer) || (destinationLocation = (destination = (IContainer)destinationResource).getLocation()).equals((Object)movedResource.getLocation().removeLastSegments(1))) continue;
                    if (movedResource instanceof IFolder) {
                        IFolder folder = (IFolder)movedResource;
                        final int prefixLength = folder.getFullPath().segmentCount() - 1;
                        folder.accept(new IResourceProxyVisitor(){

                            public boolean visit(IResourceProxy proxy) throws CoreException {
                                if (proxy.isLinked()) {
                                    return false;
                                }
                                if (proxy.getType() == 1) {
                                    IFile file = (IFile)proxy.requestResource();
                                    movedFiles.put(file, destination.getFile(file.getFullPath().removeFirstSegments(prefixLength)));
                                    return false;
                                }
                                return true;
                            }
                        }, 0);
                        continue;
                    }
                    if (!(movedResource instanceof IFile)) continue;
                    IFile file = (IFile)movedResource;
                    movedFiles.put(file, destination.getFile((IPath)new Path(movedResource.getName())));
                }
                HeaderFileReferenceAdjuster includeAdjuster = new HeaderFileReferenceAdjuster(movedFiles, Collections.emptyMap(), this.getProcessor());
                this.change = includeAdjuster.createChange(context, pm);
            }
            catch (CoreException e) {
                RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)e.getStatus());
                return refactoringStatus;
            }
        }
        finally {
            pm.done();
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.change = RenameParticipantHelper.postprocessParticipantChange(this.change, (RefactoringParticipant)this);
        pm.done();
        return this.change;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.done();
        return null;
    }

    public String getName() {
        return RenameMessages.HeaderFileMoveParticipant_name;
    }
}

