/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;

public final class ContributedProcessorDescriptor {
    private final IConfigurationElement fConfigurationElement;
    private Object fProcessorInstance;
    private Boolean fStatus;
    private boolean fLastResult;
    private final Set<String> fHandledMarkerTypes;
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String HANDLED_MARKER_TYPES = "handledMarkerTypes";
    private static final String MARKER_TYPE = "markerType";

    public ContributedProcessorDescriptor(IConfigurationElement element, boolean testMarkerTypes) {
        this.fConfigurationElement = element;
        this.fProcessorInstance = null;
        this.fStatus = null;
        if (this.fConfigurationElement.getChildren("enablement").length == 0) {
            this.fStatus = Boolean.TRUE;
        }
        this.fHandledMarkerTypes = testMarkerTypes ? this.getHandledMarkerTypes(element) : null;
    }

    private Set<String> getHandledMarkerTypes(IConfigurationElement element) {
        IConfigurationElement[] children;
        HashSet<String> map = new HashSet<String>(7);
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren(HANDLED_MARKER_TYPES);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] types;
            IConfigurationElement element2 = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = types = element2.getChildren(MARKER_TYPE);
            int n3 = types.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement type = iConfigurationElementArray2[n4];
                String attribute = type.getAttribute(ID);
                if (attribute != null) {
                    map.add(attribute);
                }
                ++n4;
            }
            ++n2;
        }
        if (map.isEmpty()) {
            map.add("org.eclipse.cdt.core.task");
        }
        return map;
    }

    public IStatus checkSyntax() {
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length > 1) {
            String id = this.fConfigurationElement.getAttribute(ID);
            return new StatusInfo(4, "Only one < enablement > element allowed. Disabling " + id);
        }
        return new StatusInfo(0, "Syntactically correct quick assist/fix processor");
    }

    private boolean matches(ITranslationUnit cunit) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length == 1) {
            try {
                ExpressionConverter parser = ExpressionConverter.getDefault();
                Expression expression = parser.perform(children[0]);
                EvaluationContext evalContext = new EvaluationContext(null, (Object)cunit);
                evalContext.addVariable("compilationUnit", (Object)cunit);
                ICProject cProject = cunit.getCProject();
                String[] natures = cProject.getProject().getDescription().getNatureIds();
                evalContext.addVariable("projectNatures", Arrays.asList(natures));
                this.fLastResult = expression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
                return this.fLastResult;
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    public Object getProcessor(ITranslationUnit cunit) throws CoreException {
        if (this.matches(cunit)) {
            if (this.fProcessorInstance == null) {
                this.fProcessorInstance = this.fConfigurationElement.createExecutableExtension(CLASS);
            }
            return this.fProcessorInstance;
        }
        return null;
    }

    public boolean canHandleMarkerType(String markerType) {
        return this.fHandledMarkerTypes == null || this.fHandledMarkerTypes.contains(markerType);
    }
}

