/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.refactoring.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.ActionUtil;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactory;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameLinkedMode;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.refactoring.actions.Messages;
import org.eclipse.cdt.ui.refactoring.actions.RefactoringAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.window.IShellProvider;

public class CRenameAction
extends RefactoringAction {
    public CRenameAction() {
        super(Messages.CRenameAction_label);
    }

    @Override
    public void run(IShellProvider shellProvider, ICElement elem) {
        if (!ActionUtil.isEditable(this.fEditor, shellProvider.getShell(), elem)) {
            return;
        }
        CRefactory.getInstance().rename(shellProvider.getShell(), elem);
    }

    @Override
    public void run(IShellProvider shellProvider, IWorkingCopy workingCopy, ITextSelection selection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        boolean lightweight = store.getBoolean("Refactor.lightweight");
        if (lightweight) {
            new RenameLinkedMode(this.fEditor).start();
        } else {
            CRefactory.getInstance().rename(shellProvider.getShell(), workingCopy, selection);
        }
    }

    @Override
    public void updateSelection(ICElement elem) {
        super.updateSelection(elem);
        if (elem == null || elem instanceof IInclude || elem instanceof ITranslationUnit) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

