/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;

public final class IndexReaderFunctions {
    private IndexReaderFunctions() {
    }

    public static DoubleValuesSource docFreq(Term term) {
        return new IndexReaderDoubleValuesSource(r -> r.docFreq(term), "docFreq(" + term.toString() + ")");
    }

    public static DoubleValuesSource maxDoc() {
        return new IndexReaderDoubleValuesSource(IndexReader::maxDoc, "maxDoc()");
    }

    public static DoubleValuesSource numDocs() {
        return new IndexReaderDoubleValuesSource(IndexReader::numDocs, "numDocs()");
    }

    public static DoubleValuesSource numDeletedDocs() {
        return new IndexReaderDoubleValuesSource(IndexReader::numDeletedDocs, "numDeletedDocs()");
    }

    public static LongValuesSource sumTotalTermFreq(String field) {
        return new SumTotalTermFreqValuesSource(field);
    }

    public static DoubleValuesSource termFreq(Term term) {
        return new TermFreqDoubleValuesSource(term);
    }

    public static DoubleValuesSource totalTermFreq(Term term) {
        return new IndexReaderDoubleValuesSource(r -> r.totalTermFreq(term), "totalTermFreq(" + term.toString() + ")");
    }

    public static DoubleValuesSource sumDocFreq(String field) {
        return new IndexReaderDoubleValuesSource(r -> r.getSumDocFreq(field), "sumDocFreq(" + field + ")");
    }

    public static DoubleValuesSource docCount(String field) {
        return new IndexReaderDoubleValuesSource(r -> r.getDocCount(field), "docCount(" + field + ")");
    }

    private static class IndexReaderDoubleValuesSource
    extends DoubleValuesSource {
        private final ReaderFunction func;
        private final String description;

        private IndexReaderDoubleValuesSource(ReaderFunction func, String description) {
            this.func = func;
            this.description = description;
        }

        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            throw new UnsupportedOperationException("IndexReaderFunction must be rewritten before use");
        }

        public boolean needsScores() {
            return false;
        }

        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return new NoCacheConstantDoubleValuesSource(this.func.apply(searcher.getIndexReader()), this);
        }

        public String toString() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            IndexReaderDoubleValuesSource that = (IndexReaderDoubleValuesSource)((Object)o);
            return Objects.equals(this.description, that.description) && Objects.equals(this.func, that.func);
        }

        public int hashCode() {
            return Objects.hash(this.description, this.func);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    @FunctionalInterface
    private static interface ReaderFunction {
        public double apply(IndexReader var1) throws IOException;
    }

    private static class SumTotalTermFreqValuesSource
    extends LongValuesSource {
        private final String field;

        private SumTotalTermFreqValuesSource(String field) {
            this.field = field;
        }

        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            throw new UnsupportedOperationException("IndexReaderFunction must be rewritten before use");
        }

        public boolean needsScores() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            SumTotalTermFreqValuesSource that = (SumTotalTermFreqValuesSource)((Object)o);
            return Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hash(this.field);
        }

        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return new NoCacheConstantLongValuesSource(searcher.getIndexReader().getSumTotalTermFreq(this.field), this);
        }

        public String toString() {
            return "sumTotalTermFreq(" + this.field + ")";
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private static class TermFreqDoubleValuesSource
    extends DoubleValuesSource {
        private final Term term;

        private TermFreqDoubleValuesSource(Term term) {
            this.term = term;
        }

        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            Terms terms = Terms.getTerms((LeafReader)ctx.reader(), (String)this.term.field());
            TermsEnum te = terms.iterator();
            if (!te.seekExact(this.term.bytes())) {
                return DoubleValues.EMPTY;
            }
            final PostingsEnum pe = te.postings(null);
            assert (pe != null);
            return new DoubleValues(this){

                public double doubleValue() throws IOException {
                    return pe.freq();
                }

                public boolean advanceExact(int doc) throws IOException {
                    if (pe.docID() > doc) {
                        return false;
                    }
                    return pe.docID() == doc || pe.advance(doc) == doc;
                }
            };
        }

        public boolean needsScores() {
            return false;
        }

        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }

        public String toString() {
            return "termFreq(" + this.term.toString() + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TermFreqDoubleValuesSource that = (TermFreqDoubleValuesSource)((Object)o);
            return Objects.equals(this.term, that.term);
        }

        public int hashCode() {
            return Objects.hash(this.term);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }

    private static class NoCacheConstantDoubleValuesSource
    extends DoubleValuesSource {
        final double value;
        final DoubleValuesSource parent;

        private NoCacheConstantDoubleValuesSource(double value, DoubleValuesSource parent) {
            this.value = value;
            this.parent = parent;
        }

        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            return new DoubleValues(){

                public double doubleValue() throws IOException {
                    return value;
                }

                public boolean advanceExact(int doc) throws IOException {
                    return true;
                }
            };
        }

        public boolean needsScores() {
            return false;
        }

        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NoCacheConstantDoubleValuesSource)) {
                return false;
            }
            NoCacheConstantDoubleValuesSource that = (NoCacheConstantDoubleValuesSource)((Object)o);
            return Double.compare(that.value, this.value) == 0 && Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.parent);
        }

        public String toString() {
            return this.parent.toString();
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }

    private static class NoCacheConstantLongValuesSource
    extends LongValuesSource {
        final long value;
        final LongValuesSource parent;

        private NoCacheConstantLongValuesSource(long value, LongValuesSource parent) {
            this.value = value;
            this.parent = parent;
        }

        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            return new LongValues(){

                public long longValue() throws IOException {
                    return value;
                }

                public boolean advanceExact(int doc) throws IOException {
                    return true;
                }
            };
        }

        public boolean needsScores() {
            return false;
        }

        public LongValuesSource rewrite(IndexSearcher reader) throws IOException {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NoCacheConstantLongValuesSource)) {
                return false;
            }
            NoCacheConstantLongValuesSource that = (NoCacheConstantLongValuesSource)((Object)o);
            return this.value == that.value && Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.parent);
        }

        public String toString() {
            return this.parent.toString();
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }
}

