/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDisplayHint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVar;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarChange;

public class MIVarUpdateInfo
extends MIInfo {
    MIVarChange[] changeList;

    public MIVarUpdateInfo(MIOutput record) {
        super(record);
        MIOutput out;
        MIResultRecord rr;
        ArrayList<MIVarChange> aList = new ArrayList<MIVarChange>();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                if (var.equals("changelist")) {
                    MIValue value = results[i].getMIValue();
                    if (value instanceof MITuple) {
                        this.parseChangeList((MITuple)value, aList);
                    } else if (value instanceof MIList) {
                        this.parseChangeList((MIList)value, aList);
                    }
                }
                ++i;
            }
        }
        this.changeList = aList.toArray(new MIVarChange[aList.size()]);
    }

    public MIVarChange[] getMIVarChanges() {
        return this.changeList;
    }

    protected void parseChangeList(MIList miList, List<MIVarChange> aList) {
        MIValue[] values = miList.getMIValues();
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof MITuple) {
                this.parseChangeList((MITuple)values[i], aList);
            } else if (values[i] instanceof MIList) {
                this.parseChangeList((MIList)values[i], aList);
            }
            ++i;
        }
    }

    protected void parseChangeList(MITuple tuple, List<MIVarChange> aList) {
        MIResult[] results = tuple.getMIResults();
        MIVarChange change = null;
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (value instanceof MITuple) {
                this.parseChangeList((MITuple)value, aList);
            } else {
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (var.equals("name")) {
                    change = new MIVarChange(str);
                    aList.add(change);
                } else if (var.equals("value")) {
                    if (change != null) {
                        change.setValue(str);
                    }
                } else if (var.equals("in_scope")) {
                    if (change != null) {
                        change.setInScope(Boolean.parseBoolean(str));
                    }
                } else if (var.equals("type_changed")) {
                    if (change != null) {
                        change.setChanged(Boolean.parseBoolean(str));
                    }
                } else if (var.equals("new_type")) {
                    if (change != null) {
                        change.setNewType(str);
                    }
                } else if (var.equals("new_num_children")) {
                    if (change != null) {
                        try {
                            change.setNewNumChildren(Integer.parseInt(str.trim()));
                        }
                        catch (NumberFormatException e) {
                            change.setNewNumChildren(0);
                        }
                    }
                } else if (var.equals("dynamic")) {
                    if (change != null) {
                        change.setDynamic(str.trim().equals("1"));
                    }
                } else if (var.equals("has_more")) {
                    if (change != null) {
                        change.setHasMore(str.trim().equals("1"));
                    }
                } else if (var.equals("new_children")) {
                    if (change != null) {
                        ArrayList<MIVar> newChildren = new ArrayList<MIVar>();
                        this.parseNewChildren(value, newChildren);
                        change.setNewChildren(newChildren.toArray(new MIVar[newChildren.size()]));
                    }
                } else if (var.equals("displayhint") && change != null) {
                    change.setDisplayHint(new MIDisplayHint(str));
                }
            }
            ++i;
        }
    }

    private void parseNewChildren(MIValue value, List<MIVar> aList) {
        if (value instanceof MIList) {
            MIValue[] children;
            MIValue[] mIValueArray = children = ((MIList)value).getMIValues();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                MIValue child = mIValueArray[n2];
                if (child instanceof MITuple) {
                    aList.add(new MIVar((MITuple)child));
                }
                ++n2;
            }
        }
    }
}

