/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.EngineConfig;
import org.mandas.docker.client.messages.swarm.EnginePlugin;

final class ImmutableEngineConfig
implements EngineConfig {
    private final String engineVersion;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final List<EnginePlugin> plugins;

    private ImmutableEngineConfig(String engineVersion, @Nullable Map<String, String> labels, @Nullable List<EnginePlugin> plugins) {
        this.engineVersion = engineVersion;
        this.labels = labels;
        this.plugins = plugins;
    }

    @Override
    @JsonProperty(value="EngineVersion")
    public String engineVersion() {
        return this.engineVersion;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="Plugins")
    @Nullable
    public List<EnginePlugin> plugins() {
        return this.plugins;
    }

    public final ImmutableEngineConfig withEngineVersion(String value) {
        String newValue = Objects.requireNonNull(value, "engineVersion");
        if (this.engineVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableEngineConfig(newValue, this.labels, this.plugins);
    }

    public final ImmutableEngineConfig withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableEngineConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableEngineConfig(this.engineVersion, newValue, this.plugins);
    }

    public final ImmutableEngineConfig withPlugins(EnginePlugin ... elements) {
        if (elements == null) {
            if (this.plugins == null) {
                return this;
            }
            return new ImmutableEngineConfig(this.engineVersion, this.labels, null);
        }
        List<EnginePlugin> newValue = ImmutableEngineConfig.createUnmodifiableList(false, ImmutableEngineConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEngineConfig(this.engineVersion, this.labels, newValue);
    }

    public final ImmutableEngineConfig withPlugins(@Nullable Iterable<? extends EnginePlugin> elements) {
        if (this.plugins == elements) {
            return this;
        }
        List<EnginePlugin> newValue = elements == null ? null : ImmutableEngineConfig.createUnmodifiableList(false, ImmutableEngineConfig.createSafeList(elements, true, false));
        return new ImmutableEngineConfig(this.engineVersion, this.labels, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEngineConfig && this.equalsByValue((ImmutableEngineConfig)another);
    }

    private boolean equalsByValue(ImmutableEngineConfig another) {
        return this.engineVersion.equals(another.engineVersion) && Objects.equals(this.labels, another.labels) && Objects.equals(this.plugins, another.plugins);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.engineVersion.hashCode();
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.plugins);
        return h;
    }

    public String toString() {
        return "EngineConfig{engineVersion=" + this.engineVersion + ", labels=" + String.valueOf(this.labels) + ", plugins=" + String.valueOf(this.plugins) + "}";
    }

    public static ImmutableEngineConfig copyOf(EngineConfig instance) {
        if (instance instanceof ImmutableEngineConfig) {
            return (ImmutableEngineConfig)instance;
        }
        return ImmutableEngineConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_ENGINE_VERSION = 1L;
        private long initBits = 1L;
        private String engineVersion;
        private Map<String, String> labels = null;
        private List<EnginePlugin> plugins = null;

        private Builder() {
        }

        public final Builder from(EngineConfig instance) {
            List<EnginePlugin> pluginsValue;
            Objects.requireNonNull(instance, "instance");
            this.engineVersion(instance.engineVersion());
            Map<String, String> labelsValue = instance.labels();
            if (labelsValue != null) {
                this.putAllLabels(labelsValue);
            }
            if ((pluginsValue = instance.plugins()) != null) {
                this.addAllPlugins(pluginsValue);
            }
            return this;
        }

        @JsonProperty(value="EngineVersion")
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = Objects.requireNonNull(engineVersion, "engineVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        public final Builder plugin(EnginePlugin element) {
            if (this.plugins == null) {
                this.plugins = new ArrayList<EnginePlugin>();
            }
            this.plugins.add(Objects.requireNonNull(element, "plugins element"));
            return this;
        }

        public final Builder plugins(EnginePlugin ... elements) {
            if (this.plugins == null) {
                this.plugins = new ArrayList<EnginePlugin>();
            }
            for (EnginePlugin element : elements) {
                this.plugins.add(Objects.requireNonNull(element, "plugins element"));
            }
            return this;
        }

        @JsonProperty(value="Plugins")
        public final Builder plugins(@Nullable Iterable<? extends EnginePlugin> elements) {
            if (elements == null) {
                this.plugins = null;
                return this;
            }
            this.plugins = new ArrayList<EnginePlugin>();
            return this.addAllPlugins(elements);
        }

        public final Builder addAllPlugins(Iterable<? extends EnginePlugin> elements) {
            Objects.requireNonNull(elements, "plugins element");
            if (this.plugins == null) {
                this.plugins = new ArrayList<EnginePlugin>();
            }
            for (EnginePlugin enginePlugin : elements) {
                this.plugins.add(Objects.requireNonNull(enginePlugin, "plugins element"));
            }
            return this;
        }

        public ImmutableEngineConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEngineConfig(this.engineVersion, this.labels == null ? null : ImmutableEngineConfig.createUnmodifiableMap(false, false, this.labels), this.plugins == null ? null : ImmutableEngineConfig.createUnmodifiableList(true, this.plugins));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("engineVersion");
            }
            return "Cannot build EngineConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

