/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableInstance;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalVariable;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMGlobalScope;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class SymbolShadowingChecker
extends AbstractIndexAstChecker {
    public static final String ERR_ID = "org.eclipse.cdt.codan.internal.checkers.SymbolShadowingProblem";
    public static final String PARAM_FUNC_PARAM = "paramFuncParameters";
    private IASTTranslationUnit ast;
    private IIndex index;
    private boolean checkFuncParams;

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_FUNC_PARAM, CheckersMessages.SymbolShadowingChecker_CheckFunctionParameters, Boolean.TRUE);
    }

    public void processAst(IASTTranslationUnit ast) {
        this.ast = ast;
        this.index = ast.getIndex();
        this.checkFuncParams = (Boolean)this.getPreference(this.getProblemById(ERR_ID, (IResource)this.getFile()), PARAM_FUNC_PARAM);
        ast.accept((ASTVisitor)new VariableDeclarationVisitor());
    }

    class VariableDeclarationVisitor
    extends ASTVisitor {
        VariableDeclarationVisitor() {
            this.shouldVisitDeclarators = true;
        }

        private boolean validBinding(IBinding binding) {
            return binding instanceof IField || binding instanceof ICPPInternalVariable || binding instanceof ICPPVariableInstance || SymbolShadowingChecker.this.checkFuncParams && binding instanceof IParameter;
        }

        private void report(String id, IASTNode astNode, Set<IProblemLocation> cache, Object ... args) {
            IProblemLocation loc = SymbolShadowingChecker.this.getProblemLocation(astNode);
            if (loc != null && !cache.contains(loc)) {
                SymbolShadowingChecker.this.reportProblem(id, loc, args);
                cache.add(loc);
            }
        }

        private int getLocation(IASTNode astNode, IASTFileLocation astLocation) {
            IASTImageLocation imageLocation;
            if (SymbolShadowingChecker.enclosedInMacroExpansion((IASTNode)astNode) && astNode instanceof IASTName && (imageLocation = ((IASTName)astNode).getImageLocation()) != null) {
                return imageLocation.getNodeOffset();
            }
            return astLocation.getNodeOffset();
        }

        private boolean isParentDeclaredBefore(IASTDeclarator declarator, IASTName[] declNames) {
            int start = this.getLocation((IASTNode)declarator, declarator.getFileLocation());
            IASTName[] iASTNameArray = declNames;
            int n = declNames.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName n3 = iASTNameArray[n2];
                if (this.getLocation((IASTNode)n3, n3.getFileLocation()) < start) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public int visit(IASTDeclarator declarator) {
            IScope scope;
            HashSet<IProblemLocation> cache;
            block10: {
                if (!SymbolShadowingChecker.this.checkFuncParams && declarator.getParent() instanceof IASTParameterDeclaration) {
                    return 3;
                }
                IBinding binding = declarator.getName().resolveBinding();
                if (binding == null || binding instanceof IProblemBinding) {
                    return 3;
                }
                cache = new HashSet<IProblemLocation>();
                scope = binding.getScope();
                if (scope.getKind() == EScopeKind.eLocal) break block10;
                return 3;
            }
            try {
                scope = scope.getParent();
                block3: while (scope != null && !(scope instanceof IProblemBinding) && !(scope instanceof PDOMGlobalScope)) {
                    IBinding[] scopeBindings = scope.find(declarator.getName().toString(), declarator.getTranslationUnit());
                    IScope current = scope;
                    scope = scope.getParent();
                    IBinding[] iBindingArray = scopeBindings;
                    int n = scopeBindings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBinding scopeBinding = iBindingArray[n2];
                        if (scopeBinding != null && this.validBinding(scopeBinding)) {
                            IASTName[] declNames = SymbolShadowingChecker.this.ast.getDeclarationsInAST(scopeBinding);
                            if (declNames != null && declNames.length != 0) {
                                if (scope != null && current.getKind() == scope.getKind() && current.getKind() == EScopeKind.eLocal && this.isParentDeclaredBefore(declarator, declNames)) {
                                    this.report(SymbolShadowingChecker.ERR_ID, (IASTNode)declarator, cache, declarator.getName());
                                    continue block3;
                                }
                                if (scope != null && current.getKind() == scope.getKind()) continue block3;
                                this.report(SymbolShadowingChecker.ERR_ID, (IASTNode)declarator, cache, declarator.getName());
                                continue block3;
                            }
                            IIndexName[] indexNames = SymbolShadowingChecker.this.index.findDeclarations(scopeBinding);
                            if (indexNames == null || indexNames.length == 0) continue block3;
                            this.report(SymbolShadowingChecker.ERR_ID, (IASTNode)declarator, cache, declarator.getName());
                            continue block3;
                        }
                        ++n2;
                    }
                }
            }
            catch (DOMException | CoreException e) {
                CodanCheckersActivator.log(e);
            }
            return 3;
        }
    }
}

