/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.AbstractElementOperation;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.IOperationService;
import org.eclipse.mylyn.builds.internal.core.operations.Messages;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshRequest;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.osgi.util.NLS;

public class RefreshOperation
extends AbstractElementOperation<IBuildServer> {
    private final BuildModel model;
    private final Map<IBuildServer, RefreshData> dataByServer;

    public RefreshOperation(IOperationService service, BuildModel model) {
        this(service, model, null);
    }

    public RefreshOperation(IOperationService service, BuildModel model, List<IBuildElement> elements) {
        super(service);
        Assert.isNotNull((Object)model);
        this.model = model;
        if (elements != null) {
            this.dataByServer = new LinkedHashMap<IBuildServer, RefreshData>();
            for (IBuildElement element : elements) {
                RefreshData data = this.dataByServer.get(element.getServer());
                if (data == null) {
                    data = new RefreshData();
                    data.server = element.getServer();
                    data.elements = new ArrayList<IBuildElement>();
                    this.dataByServer.put(element.getServer(), data);
                }
                if (element instanceof IBuildServer) continue;
                data.elements.add(element);
            }
        } else {
            this.dataByServer = null;
        }
    }

    @Override
    protected BuildJob doCreateJob(IBuildServer server) {
        if (this.dataByServer != null) {
            RefreshData data = this.dataByServer.get(server);
            return new RefreshJob(data);
        }
        RefreshData data = new RefreshData();
        data.server = server;
        data.elements = Collections.emptyList();
        return new RefreshJob(data);
    }

    @Override
    protected List<IBuildServer> doInitInput() {
        if (this.dataByServer != null) {
            for (Map.Entry<IBuildServer, RefreshData> data : this.dataByServer.entrySet()) {
                this.register(Collections.singletonList(data.getKey()));
                this.register(data.getValue().elements);
            }
            return new ArrayList<IBuildServer>(this.dataByServer.keySet());
        }
        return super.doInitInput();
    }

    @Override
    protected List<IBuildServer> doSyncInitInput() {
        ArrayList<IBuildServer> servers = new ArrayList<IBuildServer>(this.model.getServers().size());
        for (IBuildServer server : this.model.getServers()) {
            if (server.getLocation().isOffline()) continue;
            servers.add(server);
        }
        return servers;
    }

    @Override
    protected void handleResult(BuildJob job) {
        super.handleResult(job);
        IStatus status = job.getStatus();
        if (status != Status.CANCEL_STATUS) {
            this.getService().getRealm().exec(() -> job.getElement().setElementStatus(status));
        }
        if (this.dataByServer != null) {
            RefreshData data = ((RefreshJob)job).data;
            this.getService().getRealm().exec(() -> this.unregister(refreshData.elements));
        }
    }

    private static final class RefreshData {
        private IBuildServer server;
        private List<IBuildElement> elements;

        private RefreshData() {
        }
    }

    private final class RefreshJob
    extends BuildJob {
        private final RefreshData data;

        private RefreshJob(RefreshData data) {
            super(NLS.bind((String)Messages.RefreshOperation_refreshingBuild, (Object)data.server.getLabel()));
            this.data = data;
        }

        @Override
        protected IStatus doExecute(IOperationMonitor progress) {
            try {
                ArrayList<IBuildPlan> plansToRefresh = null;
                for (IBuildElement element : this.data.elements) {
                    if (!(element instanceof IBuildPlan)) continue;
                    if (plansToRefresh == null) {
                        plansToRefresh = new ArrayList<IBuildPlan>();
                    }
                    plansToRefresh.add((IBuildPlan)element);
                }
                RefreshRequest request = new RefreshRequest(RefreshOperation.this.model, plansToRefresh);
                ((BuildServer)this.data.server).getRefreshSession().refresh(request, progress.newChild(1));
            }
            catch (CoreException e) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", NLS.bind((String)Messages.RefreshOperation_refreshBuildFailed, (Object)this.data.server.getLabel()), (Throwable)e));
            }
            catch (OperationCanceledException e) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        @Override
        public boolean belongsTo(Object family) {
            if (family instanceof RefreshJob) {
                RefreshJob refreshJob = (RefreshJob)((Object)family);
                return this.getElement().equals(refreshJob.getElement());
            }
            return super.belongsTo(family);
        }

        @Override
        public IBuildServer getElement() {
            return this.data.server;
        }
    }
}

