/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public class TaskActivationHistory {
    private final List<AbstractTask> history = new ArrayList<AbstractTask>();
    private int previousIndex = -1;

    public synchronized void addTask(AbstractTask task) {
        boolean isPreviousTask = false;
        if (this.history.isEmpty() || this.history.get(this.history.size() - 1) != task) {
            if (this.previousIndex >= 0 && this.previousIndex < this.history.size() && this.history.get(this.previousIndex) == task) {
                isPreviousTask = true;
            }
            this.history.remove(task);
            this.history.add(task);
        }
        this.previousIndex = isPreviousTask ? --this.previousIndex : this.history.size() - 2;
    }

    public synchronized void addTaskInternal(AbstractTask task) {
        this.history.add(task);
    }

    public synchronized void clear() {
        this.history.clear();
        this.previousIndex = -1;
    }

    public synchronized boolean containsTask(ITask task) {
        return this.history.contains(task);
    }

    public synchronized AbstractTask getPreviousTask() {
        if (this.history.isEmpty()) {
            return null;
        }
        AbstractTask currentTask = this.history.get(this.history.size() - 1);
        if (currentTask.isActive() && this.previousIndex >= 0 && this.previousIndex < this.history.size()) {
            return this.history.get(this.previousIndex);
        }
        return currentTask;
    }

    public synchronized List<AbstractTask> getPreviousTasks() {
        return Collections.unmodifiableList(new ArrayList<AbstractTask>(this.history));
    }

    public synchronized List<AbstractTask> getPreviousTasks(Set<AbstractTaskContainer> containers) {
        if (containers.isEmpty()) {
            return this.getPreviousTasks();
        }
        HashSet<ITask> allWorkingSetTasks = new HashSet<ITask>();
        for (ITaskContainer iTaskContainer : containers) {
            allWorkingSetTasks.addAll(iTaskContainer.getChildren());
        }
        ArrayList<AbstractTask> arrayList = new ArrayList<AbstractTask>(this.getPreviousTasks());
        Iterator it = arrayList.iterator();
        while (it.hasNext()) {
            AbstractTask task = (AbstractTask)it.next();
            if (allWorkingSetTasks.contains(task)) continue;
            it.remove();
        }
        return Collections.unmodifiableList(arrayList);
    }

    public synchronized int getSize() {
        return this.history.size();
    }

    public synchronized boolean hasPrevious() {
        return this.getPreviousTask() != null;
    }

    public synchronized int indexOf(ITask task) {
        return this.history.indexOf(task);
    }

    public synchronized boolean removeTask(ITask task) {
        return this.history.remove(task);
    }
}

