/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.textcanvas;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.terminal.internal.control.impl.TerminalPlugin;
import org.eclipse.terminal.internal.textcanvas.ITextCanvasModel;
import org.eclipse.terminal.internal.textcanvas.ITextCanvasModelListener;
import org.eclipse.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.terminal.model.TextRange;

public abstract class AbstractTextCanvasModel
implements ITextCanvasModel {
    private static final boolean DEBUG_HOVER = TerminalPlugin.isOptionEnabled("org.eclipse.terminal.control/debug/log/hover");
    protected List<ITextCanvasModelListener> fListeners = new ArrayList<ITextCanvasModelListener>();
    private int fCursorLine;
    private int fCursorColumn;
    private boolean fShowCursor;
    private long fCursorTime;
    private boolean fCursorIsEnabled;
    private final ITerminalTextDataSnapshot fSnapshot;
    private int fLines;
    private int fSelectionStartLine = -1;
    private int fSeletionEndLine;
    private int fSelectionStartCoumn;
    private int fSelectionEndColumn;
    private ITerminalTextDataSnapshot fSelectionSnapshot;
    private String fCurrentSelection = "";
    private final Point fSelectionAnchor = new Point(0, 0);
    boolean fInUpdate;
    private int fCols;
    private TextRange fHoverRange = TextRange.EMPTY;

    public AbstractTextCanvasModel(ITerminalTextDataSnapshot snapshot) {
        this.fSnapshot = snapshot;
        this.fLines = this.fSnapshot.getHeight();
    }

    @Override
    public void addCellCanvasModelListener(ITextCanvasModelListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public void removeCellCanvasModelListener(ITextCanvasModelListener listener) {
        this.fListeners.remove(listener);
    }

    protected void fireCellRangeChanged(int x, int y, int width, int height) {
        for (ITextCanvasModelListener listener : this.fListeners) {
            listener.rangeChanged(x, y, width, height);
        }
    }

    protected void fireDimensionsChanged(int width, int height) {
        for (ITextCanvasModelListener listener : this.fListeners) {
            listener.dimensionsChanged(width, height);
        }
    }

    protected void fireTerminalDataChanged() {
        for (ITextCanvasModelListener listener : this.fListeners) {
            listener.terminalDataChanged();
        }
    }

    @Override
    public ITerminalTextDataReadOnly getTerminalText() {
        return this.fSnapshot;
    }

    protected ITerminalTextDataSnapshot getSnapshot() {
        return this.fSnapshot;
    }

    protected void updateSnapshot() {
        if (!this.fInUpdate && this.fSnapshot.isOutOfDate()) {
            this.fInUpdate = true;
            try {
                int y;
                this.fSnapshot.updateSnapshot(false);
                if (this.fSnapshot.hasTerminalChanged()) {
                    this.fireTerminalDataChanged();
                }
                if (this.fLines != this.fSnapshot.getHeight() || this.fCols != this.fSnapshot.getWidth()) {
                    this.fireDimensionsChanged(this.fSnapshot.getWidth(), this.fSnapshot.getHeight());
                    this.fLines = this.fSnapshot.getHeight();
                    this.fCols = this.fSnapshot.getWidth();
                }
                if ((y = this.fSnapshot.getFirstChangedLine()) < Integer.MAX_VALUE) {
                    int height = this.fSnapshot.getLastChangedLine() - y + 1;
                    this.fireCellRangeChanged(0, y, this.fSnapshot.getWidth(), height);
                }
            }
            finally {
                this.fInUpdate = false;
            }
        }
    }

    public void update() {
        this.updateSnapshot();
        this.updateSelection();
        this.updateCursor();
    }

    @Override
    public int getCursorColumn() {
        return this.fCursorColumn;
    }

    @Override
    public int getCursorLine() {
        return this.fCursorLine;
    }

    @Override
    public boolean isCursorOn() {
        return this.fShowCursor && this.fCursorIsEnabled;
    }

    protected void updateCursor() {
        if (!this.fCursorIsEnabled) {
            return;
        }
        int cursorLine = this.getSnapshot().getCursorLine();
        int cursorColumn = this.getSnapshot().getCursorColumn();
        if (cursorLine >= this.getSnapshot().getHeight()) {
            cursorLine = this.getSnapshot().getHeight() - 1;
            cursorColumn = this.getSnapshot().getWidth() - 1;
        }
        if (this.fCursorLine != cursorLine || this.fCursorColumn != cursorColumn) {
            this.fShowCursor = false;
            int col = this.fCursorColumn;
            int width = 2;
            if (col > 0) {
                --col;
                ++width;
            }
            this.fireCellRangeChanged(col, this.fCursorLine, width, 1);
            this.fShowCursor = true;
            this.fCursorTime = System.currentTimeMillis();
            this.fCursorLine = cursorLine;
            this.fCursorColumn = cursorColumn;
            this.fireCellRangeChanged(this.fCursorColumn, this.fCursorLine, 1, 1);
        } else {
            long t = System.currentTimeMillis();
            if (t - this.fCursorTime > 500L) {
                this.fShowCursor = !this.fShowCursor;
                this.fCursorTime = t;
                int col = this.fCursorColumn;
                int width = 2;
                if (col > 0) {
                    --col;
                    ++width;
                }
                this.fireCellRangeChanged(col, this.fCursorLine, width, 1);
            }
        }
    }

    @Override
    public void setVisibleRectangle(int startLine, int startCol, int height, int width) {
        this.fSnapshot.setInterestWindow(Math.max(0, startLine), Math.max(1, height));
        this.update();
    }

    protected void showCursor(boolean show) {
        this.fShowCursor = true;
    }

    @Override
    public void setCursorEnabled(boolean visible) {
        this.fCursorTime = System.currentTimeMillis();
        this.fShowCursor = visible;
        this.fCursorIsEnabled = visible;
        this.fireCellRangeChanged(this.fCursorColumn, this.fCursorLine, 1, 1);
    }

    @Override
    public boolean isCursorEnabled() {
        return this.fCursorIsEnabled;
    }

    @Override
    public Point getSelectionEnd() {
        if (this.fSelectionStartLine < 0) {
            return null;
        }
        return new Point(this.fSelectionEndColumn, this.fSeletionEndLine);
    }

    @Override
    public Point getSelectionStart() {
        if (this.fSelectionStartLine < 0) {
            return null;
        }
        return new Point(this.fSelectionStartCoumn, this.fSelectionStartLine);
    }

    @Override
    public Point getSelectionAnchor() {
        if (this.fSelectionStartLine < 0) {
            return null;
        }
        return new Point(this.fSelectionAnchor.x, this.fSelectionAnchor.y);
    }

    @Override
    public void setSelectionAnchor(Point anchor) {
        this.fSelectionAnchor.x = anchor.x;
        this.fSelectionAnchor.y = anchor.y;
    }

    @Override
    public void setSelection(int startLine, int endLine, int startColumn, int endColumn) {
        this.doSetSelection(startLine, endLine, startColumn, endColumn);
        this.fCurrentSelection = this.extractSelectedText();
    }

    private void doSetSelection(int startLine, int endLine, int startColumn, int endColumn) {
        int changedEnd;
        int changedStart;
        assert (startLine < 0 || startLine <= endLine);
        if (startLine >= 0) {
            if (this.fSelectionSnapshot == null) {
                this.fSelectionSnapshot = this.fSnapshot.getTerminalTextData().makeSnapshot();
                this.fSelectionSnapshot.updateSnapshot(true);
            }
        } else if (this.fSelectionSnapshot != null) {
            this.fSelectionSnapshot.detach();
            this.fSelectionSnapshot = null;
        }
        int oldStart = this.fSelectionStartLine;
        int oldEnd = this.fSeletionEndLine;
        this.fSelectionStartLine = startLine;
        this.fSeletionEndLine = endLine;
        this.fSelectionStartCoumn = startColumn;
        this.fSelectionEndColumn = endColumn;
        if (this.fSelectionSnapshot != null) {
            this.fSelectionSnapshot.setInterestWindow(0, this.fSelectionSnapshot.getHeight());
        }
        if (oldStart < 0) {
            changedStart = this.fSelectionStartLine;
            changedEnd = this.fSeletionEndLine;
        } else if (this.fSelectionStartLine < 0) {
            changedStart = oldStart;
            changedEnd = oldEnd;
        } else {
            changedStart = Math.min(oldStart, this.fSelectionStartLine);
            changedEnd = Math.max(oldEnd, this.fSeletionEndLine);
        }
        if (changedStart >= 0) {
            this.fireCellRangeChanged(0, changedStart, this.fSnapshot.getWidth(), changedEnd - changedStart + 1);
        }
    }

    @Override
    public boolean hasLineSelection(int line) {
        if (this.fSelectionStartLine < 0) {
            return false;
        }
        return line >= this.fSelectionStartLine && line <= this.fSeletionEndLine;
    }

    @Override
    public String getSelectedText() {
        return this.fCurrentSelection;
    }

    @Override
    public boolean hasHoverSelection(int line) {
        if (this.fHoverRange.isEmpty()) {
            return false;
        }
        return this.fHoverRange.contains(line);
    }

    @Override
    public Point getHoverSelectionStart() {
        if (!this.fHoverRange.isEmpty()) {
            return this.fHoverRange.getStart();
        }
        return null;
    }

    @Override
    public Point getHoverSelectionEnd() {
        if (!this.fHoverRange.isEmpty()) {
            Point end = this.fHoverRange.getEnd();
            --end.x;
            --end.y;
            return end;
        }
        return null;
    }

    @Override
    public void expandHoverSelectionAt(int line, int col) {
        if (this.fHoverRange.contains(col, line)) {
            return;
        }
        this.fHoverRange = TextRange.EMPTY;
        if (line < 0 || line > this.fSnapshot.getHeight() || col < 0) {
            return;
        }
        int row1 = line;
        int row2 = line;
        while (row1 > 0 && this.fSnapshot.isWrappedLine(row1 - 1)) {
            --row1;
        }
        while (row2 < this.fSnapshot.getHeight() && this.fSnapshot.isWrappedLine(row2)) {
            ++row2;
        }
        ++row2;
        Object lineText = "";
        int l = row1;
        while (l < row2) {
            char[] chars = this.fSnapshot.getChars(l);
            if (chars == null) {
                return;
            }
            lineText = (String)lineText + String.valueOf(chars);
            ++l;
        }
        int width = this.fSnapshot.getWidth();
        int col1 = col + (line - row1) * width;
        if (((String)lineText).length() <= col1 || this.isBoundaryChar(((String)lineText).charAt(col1))) {
            return;
        }
        int wordStart = 0;
        int wordEnd = ((String)lineText).length();
        int c = col1;
        while (c >= 1) {
            if (this.isBoundaryChar(((String)lineText).charAt(c - 1))) {
                wordStart = c;
                break;
            }
            --c;
        }
        c = col1;
        while (c < ((String)lineText).length()) {
            if (this.isBoundaryChar(((String)lineText).charAt(c))) {
                wordEnd = c;
                break;
            }
            ++c;
        }
        if (wordStart < wordEnd) {
            this.fHoverRange = new TextRange(row1 + wordStart / width, row1 + (wordEnd - 1) / width + 1, wordStart % width, (wordEnd - 1) % width + 1, ((String)lineText).substring(wordStart, wordEnd));
            if (DEBUG_HOVER) {
                System.out.format("hover: %s   <- [%s,%s][%s,%s]\n", this.fHoverRange, col, line, wordStart, wordEnd);
            }
        }
    }

    @Override
    public String getHoverSelectionText() {
        return this.fHoverRange.text;
    }

    private boolean isBoundaryChar(char c) {
        return Character.isWhitespace(c) || c < ' ' || c == '\"' || c == '\'';
    }

    private static String scrubLine(String text) {
        int i = text.length() - 1;
        while (i >= 0 && text.charAt(i) == '\u0000') {
            --i;
        }
        text = text.substring(0, i + 1);
        return text.replace('\u0000', ' ');
    }

    private String extractSelectedText() {
        if (this.fSelectionStartLine < 0 || this.fSelectionStartCoumn < 0 || this.fSelectionSnapshot == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int line = this.fSelectionStartLine;
        while (line <= this.fSeletionEndLine) {
            String text;
            char[] chars = this.fSelectionSnapshot.getChars(line);
            if (chars != null) {
                text = new String(chars);
                if (line == this.fSeletionEndLine && this.fSelectionEndColumn >= 0) {
                    text = text.substring(0, Math.min(this.fSelectionEndColumn + 1, text.length()));
                }
                if (line == this.fSelectionStartLine) {
                    text = text.substring(Math.min(this.fSelectionStartCoumn, text.length()));
                }
                text = AbstractTextCanvasModel.scrubLine(text);
            } else {
                text = "";
            }
            buffer.append(text);
            if (line < this.fSeletionEndLine && !this.fSelectionSnapshot.isWrappedLine(line)) {
                buffer.append('\n');
            }
            ++line;
        }
        return buffer.toString();
    }

    private void updateSelection() {
        if (this.fSelectionSnapshot != null && this.fSelectionSnapshot.isOutOfDate()) {
            this.fSelectionSnapshot.updateSnapshot(true);
            if (this.fSelectionSnapshot != null && this.fSelectionStartLine >= 0 && this.fSelectionSnapshot.getScrollWindowSize() > 0) {
                int start = this.fSelectionStartLine + this.fSelectionSnapshot.getScrollWindowShift();
                int end = this.fSeletionEndLine + this.fSelectionSnapshot.getScrollWindowShift();
                if (start < 0) {
                    start = end >= 0 ? 0 : -1;
                }
                this.doSetSelection(start, end, this.fSelectionStartCoumn, this.fSelectionEndColumn);
            }
            if (this.fCurrentSelection.length() > 0 && this.fSelectionSnapshot != null && this.fSelectionSnapshot.getFirstChangedLine() <= this.fSeletionEndLine && this.fSelectionSnapshot.getLastChangedLine() >= this.fSelectionStartLine && !this.fCurrentSelection.equals(this.extractSelectedText())) {
                this.setSelection(-1, -1, -1, -1);
            }
            if (this.fSelectionSnapshot != null) {
                this.fSelectionSnapshot.setInterestWindow(0, this.fSelectionSnapshot.getHeight());
            }
        }
    }

    @Override
    public String getAllText() {
        ITerminalTextDataSnapshot snapshot = this.fSnapshot.getTerminalTextData().makeSnapshot();
        snapshot.updateSnapshot(true);
        snapshot.detach();
        StringBuffer sb = new StringBuffer();
        int line = 0;
        while (line < snapshot.getHeight()) {
            char[] chars = snapshot.getChars(line);
            String text = chars != null ? AbstractTextCanvasModel.scrubLine(new String(chars)) : "";
            sb.append(text);
            if (line < snapshot.getHeight() - 1 && !snapshot.isWrappedLine(line)) {
                sb.append('\n');
            }
            ++line;
        }
        return sb.toString();
    }
}

