/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.swt.graphics.Image;

public class PersonContentProposal
implements IContentProposal,
Comparable<PersonContentProposal> {
    private final String address;
    private final boolean isCurrentUser;
    private final String replacementText;
    private final int cursorPosition;

    public PersonContentProposal(String address, boolean isCurrentUser, String replacementText, int cursorPosition) {
        Assert.isNotNull((Object)address);
        Assert.isNotNull((Object)replacementText);
        this.address = address;
        this.isCurrentUser = isCurrentUser;
        this.replacementText = replacementText;
        this.cursorPosition = cursorPosition;
    }

    public PersonContentProposal(String address, boolean isCurrentUser) {
        this(address, isCurrentUser, address, address.length());
    }

    public String getLabel() {
        return this.address;
    }

    public String getDescription() {
        return null;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public String getContent() {
        return this.replacementText;
    }

    public Image getImage() {
        if (this.isCurrentUser) {
            return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME);
        }
        return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON);
    }

    @Override
    public int compareTo(PersonContentProposal otherContentProposal) {
        if (this.isCurrentUser) {
            return -1;
        }
        if (otherContentProposal.isCurrentUser) {
            return 1;
        }
        return this.address.compareToIgnoreCase(otherContentProposal.address);
    }

    public boolean isCurrentUser() {
        return this.isCurrentUser;
    }
}

