/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDataSnapshotOperation;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TaskListBackupManager
implements IPropertyChangeListener {
    private static final String OLD_MYLYN_2_BACKUP_FILE_PREFIX = "mylyndata-";
    private static final String BACKUP_FILE_PREFIX = "mylyn-v3-data-";
    private static final Pattern MYLYN_BACKUP_REGEXP = Pattern.compile("^(mylyn-v3-data-)?(mylyndata-)?");
    private static final Pattern DATE_FORMAT_OLD = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private static final Pattern DATE_FORMAT = Pattern.compile("\\d{4}-\\d{2}-\\d{2}-\\d{6}");
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long STANDARD_DELAY = 1800000L;
    private String backupFolderPath;
    private Job runBackup;
    private static boolean errorDisplayed = false;

    public TaskListBackupManager(String backupFolderPath) {
        this.backupFolderPath = backupFolderPath;
        this.start(1800000L);
    }

    public void start(long delay) {
        if (this.runBackup != null) {
            this.stop();
        }
        this.runBackup = new Job("Task Data Snapshot"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (TasksUiPlugin.getTaskList().getAllTasks().size() > 0) {
                        TaskListBackupManager.this.backupNow(false, monitor);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    if (PlatformUI.isWorkbenchRunning()) {
                        this.schedule(1800000L);
                    }
                }
            }
        };
        this.runBackup.setPriority(40);
        this.runBackup.setSystem(true);
        this.runBackup.schedule(delay);
    }

    public void stop() {
        if (this.runBackup != null) {
            if (!this.runBackup.cancel()) {
                try {
                    this.runBackup.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.runBackup = null;
        }
    }

    public static String getBackupFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.ENGLISH);
        String date = format.format(new Date());
        String backupFileName = BACKUP_FILE_PREFIX + date + ".zip";
        return backupFileName;
    }

    public void backupNow(boolean synchronous) {
        this.backupNow(synchronous, null);
    }

    public synchronized void backupNow(boolean synchronous, IProgressMonitor monitor) {
        block9: {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            File backupFolder = new File(this.backupFolderPath);
            if (!backupFolder.exists()) {
                backupFolder.mkdir();
            }
            TaskDataSnapshotOperation backupJob = new TaskDataSnapshotOperation(this.backupFolderPath, TaskListBackupManager.getBackupFileName());
            try {
                if (!synchronous) {
                    backupJob.run(monitor);
                    this.removeOldBackups();
                } else {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    service.run(false, true, (IRunnableWithProgress)backupJob);
                }
            }
            catch (InterruptedException service) {
            }
            catch (Throwable e) {
                if (!errorDisplayed) {
                    Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.TaskListBackupManager_Error_occured_during_scheduled_tasklist_backup, e);
                    errorDisplayed = true;
                    if (Display.getCurrent() != null) {
                        TasksUiInternal.logAndDisplayStatus(Messages.TaskListBackupManager_Scheduled_task_data_backup, (IStatus)status);
                    } else {
                        TasksUiInternal.asyncLogAndDisplayStatus(Messages.TaskListBackupManager_Scheduled_task_data_backup, (IStatus)status);
                    }
                }
                if (backupJob.getDestinationFile() == null) break block9;
                backupJob.getDestinationFile().delete();
            }
        }
    }

    public SortedMap<Long, File> getBackupFiles() {
        TreeMap<Long, File> filesMap = new TreeMap<Long, File>();
        String destination = this.backupFolderPath;
        File backupFolder = new File(destination);
        if (!backupFolder.exists()) {
            return filesMap;
        }
        File[] files = backupFolder.listFiles();
        if (files == null) {
            return filesMap;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                File file = fileArray[n2];
                Matcher matcher = MYLYN_BACKUP_REGEXP.matcher(file.getName());
                if (matcher.find()) {
                    Date date = null;
                    try {
                        SimpleDateFormat format = null;
                        String dateText = null;
                        Matcher dateFormatMatcher = DATE_FORMAT.matcher(file.getName());
                        if (dateFormatMatcher.find()) {
                            format = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.ENGLISH);
                            dateText = dateFormatMatcher.group();
                        } else {
                            dateFormatMatcher = DATE_FORMAT_OLD.matcher(file.getName());
                            if (dateFormatMatcher.find()) {
                                format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                                dateText = dateFormatMatcher.group();
                            }
                        }
                        if (format == null || dateText == null || dateText.length() <= 0) break block10;
                        date = format.parse(dateText);
                    }
                    catch (IndexOutOfBoundsException | ParseException e) {
                        break block10;
                    }
                    if (date != null && date.getTime() > 0L) {
                        filesMap.put(date.getTime(), file);
                    }
                }
            }
            ++n2;
        }
        return filesMap;
    }

    public synchronized void removeOldBackups() {
        SortedMap<Long, File> filesMap = this.getBackupFiles();
        if (filesMap.size() > 0) {
            File toDelete;
            SortedMap<Long, File> subMap;
            Calendar rangeStart = TaskActivityUtil.getCalendar();
            rangeStart.setTimeInMillis(filesMap.lastKey());
            TaskActivityUtil.snapStartOfHour((Calendar)rangeStart);
            int startHour = rangeStart.get(11);
            Calendar rangeEnd = TaskActivityUtil.getCalendar();
            rangeEnd.setTimeInMillis(rangeStart.getTimeInMillis());
            rangeEnd.add(11, 1);
            int x = 0;
            while (x <= startHour && x < 9) {
                subMap = filesMap.subMap(rangeStart.getTimeInMillis(), rangeEnd.getTimeInMillis());
                if (subMap.size() > 1) {
                    while (subMap.size() > 1) {
                        toDelete = (File)subMap.remove(subMap.firstKey());
                        toDelete.delete();
                    }
                }
                rangeStart.add(11, -1);
                rangeEnd.add(11, -1);
                ++x;
            }
            TaskActivityUtil.snapStartOfDay((Calendar)rangeEnd);
            rangeStart.add(6, -1);
            x = 1;
            while (x <= 12) {
                subMap = filesMap.subMap(rangeStart.getTimeInMillis(), rangeEnd.getTimeInMillis());
                if (subMap.size() > 1) {
                    while (subMap.size() > 1) {
                        toDelete = (File)subMap.remove(subMap.firstKey());
                        toDelete.delete();
                    }
                }
                rangeStart.add(6, -1);
                rangeEnd.add(6, -1);
                ++x;
            }
            SortedMap<Long, File> subMap2 = filesMap.subMap(0L, rangeStart.getTimeInMillis());
            if (subMap2.size() > 0) {
                while (subMap2.size() > 0) {
                    File toDelete2 = (File)subMap2.remove(subMap2.firstKey());
                    toDelete2.delete();
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.mylyn.data.dir")) {
            this.backupFolderPath = TasksUiPlugin.getDefault().getBackupFolderPath();
        }
    }
}

