/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.jsoncdb.core.participant;

import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.jsoncdb.core.participant.IToolCommandlineParser;
import org.eclipse.cdt.jsoncdb.core.participant.IToolDetectionParticipant;

public class DefaultToolDetectionParticipant
implements IToolDetectionParticipant {
    protected static final String REGEX_GROUP_CMD = "cmd";
    protected static final String REGEX_CMD_PATH_SLASH = String.format(Locale.ROOT, "\\A(?<%s>(\\S*?%s)?", "cmd", "/");
    protected static final String REGEX_CMD_PATH_SLASH_END = ")\\s";
    protected static final String REGEX_CMD_PATH_SLASH_QUOTE = String.format(Locale.ROOT, "\\A([\"'])(?<%s>((?:(?!\\1).)*?%s)", "cmd", "/");
    protected static final String REGEX_CMD_PATH_SLASH_QUOTE_END = ")\\1\\s";
    protected static final String REGEX_CMD_PATH_BSLASH = String.format(Locale.ROOT, "\\A(?<%s>(\\S*?%s)?", "cmd", "\\\\");
    protected static final String REGEX_CMD_PATH_BSLASH_END = ")\\s";
    protected static final String REGEX_CMD_PATH_BSLASH_QUOTE = String.format(Locale.ROOT, "\\A([\"'])(?<%s>((?:(?!\\1).)*?%s)?", "cmd", "\\\\");
    protected static final String REGEX_CMD_PATH_BSLASH_QUOTE_END = ")\\1\\s";
    private final Pattern[] toolNamePatterns;
    private final Pattern[] toolNamePatternsBackslash;
    @Deprecated(forRemoval=true)
    protected final Matcher[] toolNameMatchersExt;
    @Deprecated(forRemoval=true)
    protected final Matcher[] toolNameMatchersExtBackslash;
    private final Pattern[] toolNamePatternsExt;
    private final Pattern[] toolNamePatternsExtBackslash;
    private final IToolCommandlineParser parser;
    protected final String basenameRegex;
    protected final String extensionRegex;
    protected final boolean alsoHandleNtfsPaths;

    public DefaultToolDetectionParticipant(String basenameRegex, IToolCommandlineParser parser) {
        this(basenameRegex, false, parser);
    }

    public DefaultToolDetectionParticipant(String basenameRegex, boolean alsoHandleNtfsPaths, IToolCommandlineParser parser) {
        this(basenameRegex, alsoHandleNtfsPaths, null, parser);
    }

    public DefaultToolDetectionParticipant(String basenameRegex, String extensionRegex, IToolCommandlineParser parser) {
        this(basenameRegex, false, extensionRegex, parser);
    }

    public DefaultToolDetectionParticipant(String basenameRegex, boolean alsoHandleNtfsPaths, String extensionRegex, IToolCommandlineParser parser) {
        this.basenameRegex = basenameRegex;
        this.parser = parser;
        this.alsoHandleNtfsPaths = alsoHandleNtfsPaths;
        this.extensionRegex = extensionRegex;
        this.toolNamePatterns = new Pattern[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s", REGEX_CMD_PATH_SLASH_QUOTE, basenameRegex, ")\\1\\s")), Pattern.compile(String.format(Locale.ROOT, "%s%s%s", REGEX_CMD_PATH_SLASH, basenameRegex, ")\\s"))};
        this.toolNamePatternsBackslash = alsoHandleNtfsPaths ? new Pattern[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s", REGEX_CMD_PATH_BSLASH_QUOTE, basenameRegex, ")\\1\\s")), Pattern.compile(String.format(Locale.ROOT, "%s%s%s", REGEX_CMD_PATH_BSLASH, basenameRegex, ")\\s"))} : new Pattern[0];
        if (extensionRegex != null) {
            this.toolNamePatternsExt = new Pattern[]{Pattern.compile(String.format(Locale.ROOT, "%s%s\\.%s%s", REGEX_CMD_PATH_SLASH_QUOTE, basenameRegex, extensionRegex, ")\\1\\s")), Pattern.compile(String.format(Locale.ROOT, "%s%s\\.%s%s", REGEX_CMD_PATH_SLASH, basenameRegex, extensionRegex, ")\\s"))};
            this.toolNamePatternsExtBackslash = alsoHandleNtfsPaths ? new Pattern[]{Pattern.compile(String.format(Locale.ROOT, "%s%s\\.%s%s", REGEX_CMD_PATH_BSLASH_QUOTE, basenameRegex, extensionRegex, ")\\1\\s")), Pattern.compile(String.format(Locale.ROOT, "%s%s\\.%s%s", REGEX_CMD_PATH_BSLASH, basenameRegex, extensionRegex, ")\\s"))} : new Pattern[0];
        } else {
            this.toolNamePatternsExt = new Pattern[0];
            this.toolNamePatternsExtBackslash = new Pattern[0];
        }
        this.toolNameMatchersExt = new Matcher[this.toolNamePatternsExt.length];
        int i = 0;
        while (i < this.toolNameMatchersExt.length) {
            this.toolNameMatchersExt[i] = this.toolNamePatternsExt[i].matcher("");
            ++i;
        }
        this.toolNameMatchersExtBackslash = new Matcher[this.toolNamePatternsExtBackslash.length];
        i = 0;
        while (i < this.toolNameMatchersExtBackslash.length) {
            this.toolNameMatchersExtBackslash[i] = this.toolNamePatternsExtBackslash[i].matcher("");
            ++i;
        }
    }

    @Override
    public IToolCommandlineParser getParser() {
        return this.parser;
    }

    @Override
    public boolean canHandleNtfsPaths() {
        return this.alsoHandleNtfsPaths;
    }

    @Override
    public Optional<IToolDetectionParticipant.MatchResult> basenameMatches(String commandLine, boolean matchBackslash) {
        if (matchBackslash && !this.canHandleNtfsPaths()) {
            return Optional.empty();
        }
        Pattern[] patternArray = matchBackslash ? this.toolNamePatternsBackslash : this.toolNamePatterns;
        int n = patternArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Optional<IToolDetectionParticipant.MatchResult> result = this.patternMatches(pattern, commandLine);
            if (result.isPresent()) {
                return result;
            }
            ++n2;
        }
        return Optional.empty();
    }

    @Override
    public Optional<IToolDetectionParticipant.MatchResult> basenameWithVersionMatches(String commandLine, boolean matchBackslash, String versionRegex) {
        if (matchBackslash && !this.canHandleNtfsPaths()) {
            return Optional.empty();
        }
        Pattern[] toolNamePatterns = matchBackslash ? new Pattern[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s%s", REGEX_CMD_PATH_BSLASH_QUOTE, this.basenameRegex, versionRegex, ")\\1\\s")), Pattern.compile(String.format(Locale.ROOT, "%s%s%s%s", REGEX_CMD_PATH_BSLASH, this.basenameRegex, versionRegex, ")\\s"))} : new Pattern[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s%s", REGEX_CMD_PATH_SLASH_QUOTE, this.basenameRegex, versionRegex, ")\\1\\s")), Pattern.compile(String.format(Locale.ROOT, "%s%s%s%s", REGEX_CMD_PATH_SLASH, this.basenameRegex, versionRegex, ")\\s"))};
        Pattern[] patternArray = toolNamePatterns;
        int n = toolNamePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Optional<IToolDetectionParticipant.MatchResult> result = this.patternMatches(pattern, commandLine);
            if (result.isPresent()) {
                return result;
            }
            ++n2;
        }
        return Optional.empty();
    }

    @Override
    public Optional<IToolDetectionParticipant.MatchResult> basenameWithExtensionMatches(String commandLine, boolean matchBackslash) {
        if (matchBackslash && !this.canHandleNtfsPaths()) {
            return Optional.empty();
        }
        Pattern[] patternArray = matchBackslash ? this.toolNamePatternsExtBackslash : this.toolNamePatternsExt;
        int n = patternArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Optional<IToolDetectionParticipant.MatchResult> result = this.patternMatches(pattern, commandLine);
            if (result.isPresent()) {
                return result;
            }
            ++n2;
        }
        return Optional.empty();
    }

    @Override
    public Optional<IToolDetectionParticipant.MatchResult> basenameWithVersionAndExtensionMatches(String commandLine, boolean matchBackslash, String versionRegex) {
        if (this.extensionRegex == null || matchBackslash && !this.canHandleNtfsPaths()) {
            return Optional.empty();
        }
        Pattern[] toolNamePatterns = matchBackslash ? new Pattern[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s\\.%s%s", REGEX_CMD_PATH_BSLASH_QUOTE, this.basenameRegex, versionRegex, this.extensionRegex, ")\\1\\s")), Pattern.compile(String.format(Locale.ROOT, "%s%s%s\\.%s%s", REGEX_CMD_PATH_BSLASH, this.basenameRegex, versionRegex, this.extensionRegex, ")\\s"))} : new Pattern[]{Pattern.compile(String.format(Locale.ROOT, "%s%s%s\\.%s%s", REGEX_CMD_PATH_SLASH_QUOTE, this.basenameRegex, versionRegex, this.extensionRegex, ")\\1\\s")), Pattern.compile(String.format(Locale.ROOT, "%s%s%s\\.%s%s", REGEX_CMD_PATH_SLASH, this.basenameRegex, versionRegex, this.extensionRegex, ")\\s"))};
        Pattern[] patternArray = toolNamePatterns;
        int n = toolNamePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Optional<IToolDetectionParticipant.MatchResult> result = this.patternMatches(pattern, commandLine);
            if (result.isPresent()) {
                return result;
            }
            ++n2;
        }
        return Optional.empty();
    }

    private Optional<IToolDetectionParticipant.MatchResult> patternMatches(Pattern pattern, String commandLine) {
        Matcher matcher = pattern.matcher(commandLine);
        if (matcher.lookingAt()) {
            return Optional.of(new IToolDetectionParticipant.MatchResult(matcher.group(REGEX_GROUP_CMD), commandLine.substring(matcher.end())));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [basenameRegex=" + this.basenameRegex + ", extensionRegex=" + this.extensionRegex + "]";
    }
}

