/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.grammar.BasicScopeAttributes;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.internal.utils.RegexSource;

final class BasicScopeAttributesProvider {
    private final BasicScopeAttributes _defaultAttributes;
    private final ScopeMatcher<Integer> _embeddedLanguagesMatcher;
    private final ConcurrentMap<String, BasicScopeAttributes> cache = new ConcurrentHashMap<String, BasicScopeAttributes>();
    private static final BasicScopeAttributes _NULL_SCOPE_METADATA = new BasicScopeAttributes(0, 0);
    private static final Pattern STANDARD_TOKEN_TYPE_REGEXP = Pattern.compile("\\b(comment|string|regex|meta\\.embedded)\\b");

    BasicScopeAttributesProvider(int initialLanguage, @Nullable Map<String, Integer> embeddedLanguages) {
        this._defaultAttributes = new BasicScopeAttributes(initialLanguage, 8);
        this._embeddedLanguagesMatcher = new ScopeMatcher(NullSafetyHelper.defaultIfNull(embeddedLanguages, Collections.emptyMap()));
    }

    BasicScopeAttributes getDefaultAttributes() {
        return this._defaultAttributes;
    }

    BasicScopeAttributes getBasicScopeAttributes(@Nullable String scopeName) {
        if (scopeName == null) {
            return _NULL_SCOPE_METADATA;
        }
        return this.cache.computeIfAbsent(scopeName, scopeName2 -> {
            int languageId = this._scopeToLanguage(scopeName);
            int standardTokenType = BasicScopeAttributesProvider._toStandardTokenType(scopeName);
            return new BasicScopeAttributes(languageId, standardTokenType);
        });
    }

    private int _scopeToLanguage(String scopeName) {
        return NullSafetyHelper.defaultIfNull(this._embeddedLanguagesMatcher.match(scopeName), 0);
    }

    private static int _toStandardTokenType(String scopeName) {
        String group;
        Matcher m = STANDARD_TOKEN_TYPE_REGEXP.matcher(scopeName);
        if (!m.find()) {
            return 8;
        }
        return switch (group = m.group(1)) {
            case "comment" -> 1;
            case "string" -> 2;
            case "regex" -> 3;
            case "meta.embedded" -> 0;
            default -> throw new TMException("Unexpected match for standard token type: " + group);
        };
    }

    private static final class ScopeMatcher<TValue> {
        private final Map<String, TValue> values;
        private final @Nullable Pattern scopesRegExp;

        ScopeMatcher(Map<String, TValue> values) {
            if (values.isEmpty()) {
                this.values = Collections.emptyMap();
                this.scopesRegExp = null;
            } else {
                this.values = new HashMap<String, TValue>(values);
                CharSequence[] escapedScopes = (String[])values.keySet().stream().map(RegexSource::escapeRegExpCharacters).sorted(Collections.reverseOrder()).toArray(String[]::new);
                this.scopesRegExp = Pattern.compile("^((" + String.join((CharSequence)")|(", escapedScopes) + "))($|\\.)");
            }
        }

        @Nullable TValue match(String scopeName) {
            Pattern scopesRegExp = this.scopesRegExp;
            if (scopesRegExp == null) {
                return null;
            }
            Matcher m = scopesRegExp.matcher(scopeName);
            if (!m.find()) {
                return null;
            }
            return this.values.get(m.group(1));
        }
    }
}

