/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.knn;

import java.util.Objects;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.HnswQueueSaturationCollector;

public abstract class KnnSearchStrategy {
    public static final int DEFAULT_FILTERED_SEARCH_THRESHOLD = 0;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract void nextVectorsBlock();

    public static class Patience
    extends Hnsw {
        private final HnswQueueSaturationCollector collector;

        public Patience(HnswQueueSaturationCollector collector, int filteredSearchThreshold) {
            super(filteredSearchThreshold);
            this.collector = collector;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.collector, ((Patience)obj).collector);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.filteredSearchThreshold, this.collector);
        }

        @Override
        public void nextVectorsBlock() {
            this.collector.nextCandidate();
        }
    }

    public static class Seeded
    extends KnnSearchStrategy {
        private final DocIdSetIterator entryPoints;
        private final int numberOfEntryPoints;
        private final KnnSearchStrategy originalStrategy;

        public Seeded(DocIdSetIterator entryPoints, int numberOfEntryPoints, KnnSearchStrategy originalStrategy) {
            if (numberOfEntryPoints < 0) {
                throw new IllegalArgumentException("numberOfEntryPoints must be >= 0");
            }
            this.numberOfEntryPoints = numberOfEntryPoints;
            if (numberOfEntryPoints > 0 && entryPoints == null) {
                throw new IllegalArgumentException("entryPoints must not be null");
            }
            this.entryPoints = entryPoints == null ? DocIdSetIterator.empty() : entryPoints;
            this.originalStrategy = originalStrategy;
        }

        public DocIdSetIterator entryPoints() {
            return this.entryPoints;
        }

        public int numberOfEntryPoints() {
            return this.numberOfEntryPoints;
        }

        public KnnSearchStrategy originalStrategy() {
            return this.originalStrategy;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Seeded seeded = (Seeded)o;
            return this.numberOfEntryPoints == seeded.numberOfEntryPoints && Objects.equals(this.entryPoints, seeded.entryPoints) && Objects.equals(this.originalStrategy, seeded.originalStrategy);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.entryPoints, this.numberOfEntryPoints, this.originalStrategy);
        }

        @Override
        public void nextVectorsBlock() {
            this.originalStrategy.nextVectorsBlock();
        }
    }

    public static class Hnsw
    extends KnnSearchStrategy {
        public static final Hnsw DEFAULT = new Hnsw(0);
        private final int filteredSearchThreshold;

        public Hnsw(int filteredSearchThreshold) {
            if (filteredSearchThreshold < 0 || filteredSearchThreshold > 100) {
                throw new IllegalArgumentException("filteredSearchThreshold must be >= 0 and <= 100");
            }
            this.filteredSearchThreshold = filteredSearchThreshold;
        }

        public int filteredSearchThreshold() {
            return this.filteredSearchThreshold;
        }

        public final boolean useFilteredSearch(float ratioPassingFilter) {
            assert (ratioPassingFilter >= 0.0f && ratioPassingFilter <= 1.0f);
            return ratioPassingFilter * 100.0f < (float)this.filteredSearchThreshold;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hnsw hnsw = (Hnsw)o;
            return this.filteredSearchThreshold == hnsw.filteredSearchThreshold;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.filteredSearchThreshold);
        }

        @Override
        public void nextVectorsBlock() {
        }
    }
}

