"use strict";
// *****************************************************************************
// Copyright (C) 2019 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugExceptionWidget = exports.DebugExceptionMonacoEditorZoneWidget = void 0;
const React = require("@theia/core/shared/react");
const ReactDOM = require("@theia/core/shared/react-dom");
const inversify_1 = require("@theia/core/shared/inversify");
const disposable_1 = require("@theia/core/lib/common/disposable");
const monaco_editor_zone_widget_1 = require("@theia/monaco/lib/browser/monaco-editor-zone-widget");
const debug_editor_1 = require("./debug-editor");
class DebugExceptionMonacoEditorZoneWidget extends monaco_editor_zone_widget_1.MonacoEditorZoneWidget {
    computeContainerHeight(zoneHeight) {
        // reset height to match it to the content
        this.containerNode.style.height = 'initial';
        const height = this.containerNode.offsetHeight;
        const result = super.computeContainerHeight(zoneHeight);
        result.height = height;
        return result;
    }
}
exports.DebugExceptionMonacoEditorZoneWidget = DebugExceptionMonacoEditorZoneWidget;
let DebugExceptionWidget = class DebugExceptionWidget {
    constructor() {
        this.toDispose = new disposable_1.DisposableCollection();
    }
    async init() {
        this.toDispose.push(this.zone = new DebugExceptionMonacoEditorZoneWidget(this.editor.getControl()));
        this.zone.containerNode.classList.add('theia-debug-exception-widget');
        this.toDispose.push(disposable_1.Disposable.create(() => ReactDOM.unmountComponentAtNode(this.zone.containerNode)));
        this.toDispose.push(this.editor.getControl().onDidLayoutChange(() => this.layout()));
    }
    dispose() {
        this.toDispose.dispose();
    }
    show({ info, lineNumber, column }) {
        this.render(info, () => {
            const fontInfo = this.editor.getControl().getOption(monaco.editor.EditorOption.fontInfo);
            this.zone.containerNode.style.fontSize = `${fontInfo.fontSize}px`;
            this.zone.containerNode.style.lineHeight = `${fontInfo.lineHeight}px`;
            if (lineNumber !== undefined && column !== undefined) {
                const afterLineNumber = lineNumber;
                const afterColumn = column;
                this.zone.show({ showFrame: true, afterLineNumber, afterColumn, heightInLines: 0, frameWidth: 1 });
            }
            this.layout();
        });
    }
    hide() {
        this.zone.hide();
    }
    render(info, cb) {
        const stackTrace = info.details && info.details.stackTrace;
        ReactDOM.render(React.createElement(React.Fragment, null,
            React.createElement("div", { className: 'title' }, info.id ? `Exception has occurred: ${info.id}` : 'Exception has occurred.'),
            info.description && React.createElement("div", { className: 'description' }, info.description),
            stackTrace && React.createElement("div", { className: 'stack-trace' }, stackTrace)), this.zone.containerNode, cb);
    }
    layout() {
        // reset height to match it to the content
        this.zone.containerNode.style.height = 'initial';
        const lineHeight = this.editor.getControl().getOption(monaco.editor.EditorOption.lineHeight);
        const heightInLines = Math.ceil(this.zone.containerNode.offsetHeight / lineHeight);
        this.zone.layout(heightInLines);
    }
};
__decorate([
    (0, inversify_1.inject)(debug_editor_1.DebugEditor),
    __metadata("design:type", Object)
], DebugExceptionWidget.prototype, "editor", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], DebugExceptionWidget.prototype, "init", null);
DebugExceptionWidget = __decorate([
    (0, inversify_1.injectable)()
], DebugExceptionWidget);
exports.DebugExceptionWidget = DebugExceptionWidget;
//# sourceMappingURL=debug-exception-widget.js.map