/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.maven.listener;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class M2EMavenBuildDataBridge
implements EventSpy {
    private static final String SOCKET_FILE_PROPERTY_NAME = "m2e.build.project.data.socket.port";
    private static final String DATA_SET_SEPARATOR = ";;";
    private static final Logger LOGGER = LoggerFactory.getLogger(M2EMavenBuildDataBridge.class);
    private SocketChannel writeChannel;

    public void init(EventSpy.Context context) throws IOException {
        String socketPort = System.getProperty(SOCKET_FILE_PROPERTY_NAME);
        if (socketPort != null) {
            try {
                int port = Integer.parseInt(socketPort);
                InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
                this.writeChannel = SocketChannel.open(address);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to establish connection to Eclipse-M2E", (Throwable)e);
            }
        }
    }

    public void close() throws IOException {
        this.writeChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Object event) throws Exception {
        if (this.writeChannel != null && event instanceof ExecutionEvent && ((ExecutionEvent)event).getType() == ExecutionEvent.Type.ProjectStarted) {
            String message = M2EMavenBuildDataBridge.serializeProjectData(((ExecutionEvent)event).getProject());
            ByteBuffer buffer = ByteBuffer.wrap(message.getBytes());
            SocketChannel socketChannel = this.writeChannel;
            synchronized (socketChannel) {
                while (buffer.hasRemaining()) {
                    this.writeChannel.write(buffer);
                }
            }
        }
    }

    private static String serializeProjectData(MavenProject project) {
        StringJoiner data = new StringJoiner(",");
        M2EMavenBuildDataBridge.add(data, "groupId", project.getGroupId());
        M2EMavenBuildDataBridge.add(data, "artifactId", project.getArtifactId());
        M2EMavenBuildDataBridge.add(data, "version", project.getVersion());
        M2EMavenBuildDataBridge.add(data, "file", project.getFile());
        M2EMavenBuildDataBridge.add(data, "basedir", project.getBasedir());
        M2EMavenBuildDataBridge.add(data, "build.directory", project.getBuild().getDirectory());
        return data.toString() + DATA_SET_SEPARATOR;
    }

    private static void add(StringJoiner data, String key, Object value) {
        data.add(key + "=" + value);
    }

    private static MavenProjectBuildData parseMavenBuildProject(String dataSet) {
        HashMap<String, String> data = new HashMap<String, String>(8);
        for (String entry : dataSet.split(",")) {
            String[] keyValue = entry.split("=");
            if (keyValue.length != 2) {
                throw new IllegalStateException("Invalid data-set format" + dataSet);
            }
            data.put(keyValue[0], keyValue[1]);
        }
        return new MavenProjectBuildData(data);
    }

    public static MavenBuildConnection prepareConnection(String label, Consumer<MavenProjectBuildData> datasetListener) throws IOException {
        ServerSocketChannel server = ServerSocketChannel.open();
        server.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
        MavenBuildConnection connection = new MavenBuildConnection(server);
        Thread reader = new Thread(() -> {
            try (ServerSocketChannel s = server;
                 SocketChannel readChannel = server.accept();){
                ByteBuffer buffer = ByteBuffer.allocate(512);
                StringBuilder message = new StringBuilder();
                while (readChannel.read(buffer) >= 0) {
                    int terminatorIndex;
                    message.append(new String(buffer.array(), 0, buffer.position()));
                    while ((terminatorIndex = message.indexOf(DATA_SET_SEPARATOR)) >= 0) {
                        String dataSet = message.substring(0, terminatorIndex);
                        message.delete(0, terminatorIndex + DATA_SET_SEPARATOR.length());
                        MavenProjectBuildData buildData = M2EMavenBuildDataBridge.parseMavenBuildProject(dataSet);
                        datasetListener.accept(buildData);
                    }
                    ((Buffer)buffer).clear();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                connection.readCompleted.set(true);
            }
        }, "M2E Maven build <" + label + "> connection reader");
        reader.setDaemon(true);
        reader.start();
        return connection;
    }

    public static final class MavenProjectBuildData {
        public final String groupId;
        public final String artifactId;
        public final String version;
        public final Path projectBasedir;
        public final Path projectFile;
        public final Path projectBuildDirectory;

        MavenProjectBuildData(Map<String, String> data) {
            if (data.size() != 6) {
                throw new IllegalArgumentException();
            }
            this.groupId = Objects.requireNonNull(data.get("groupId"));
            this.artifactId = Objects.requireNonNull(data.get("artifactId"));
            this.version = Objects.requireNonNull(data.get("version"));
            this.projectBasedir = Paths.get(data.get("basedir"), new String[0]);
            this.projectFile = Paths.get(data.get("file"), new String[0]);
            this.projectBuildDirectory = Paths.get(data.get("build.directory"), new String[0]);
        }
    }

    public static final class MavenBuildConnection {
        private final ServerSocketChannel server;
        private final AtomicBoolean readCompleted = new AtomicBoolean(false);

        MavenBuildConnection(ServerSocketChannel server) {
            this.server = server;
        }

        public String getMavenVMArguments() throws IOException {
            String port = Integer.toString(((InetSocketAddress)this.server.getLocalAddress()).getPort());
            return "-Dm2e.build.project.data.socket.port=" + port;
        }

        public boolean isReadCompleted() {
            return this.readCompleted.get();
        }

        public void close() throws IOException {
            this.server.close();
        }
    }
}

