/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.project.AbstractProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.osgi.util.NLS;

public class LocalProjectScanner
extends AbstractProjectScanner<MavenProjectInfo> {
    private final List<String> folders;
    private final boolean basedirRemameRequired;
    private final Set<File> scannedFolders = new HashSet<File>();
    private final MavenModelManager modelManager;

    public LocalProjectScanner(List<String> folders, boolean basedirRemameRequired, MavenModelManager modelManager) {
        this.folders = folders;
        this.basedirRemameRequired = basedirRemameRequired;
        this.modelManager = modelManager;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LocalProjectScanner_task_scanning, (int)this.folders.size());
        try {
            for (String folderName : this.folders) {
                try {
                    File folder = new File(folderName).getCanonicalFile();
                    this.scanFolder(folder, "", (IProgressMonitor)subMonitor.split(1));
                }
                catch (IOException ex) {
                    this.addError(ex);
                }
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private void scanFolder(File baseDir, String rootRelPath, IProgressMonitor m) throws InterruptedException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (String)baseDir.toString(), (int)1);
        if (!baseDir.isDirectory() || ".metadata".equals(baseDir.getName())) {
            monitor.done();
            return;
        }
        try {
            if (this.scannedFolders.contains(baseDir.getCanonicalFile())) {
                monitor.done();
                return;
            }
        }
        catch (IOException ex1) {
            this.addError(ex1);
            return;
        }
        MavenProjectInfo projectInfo = this.readMavenProjectInfo(baseDir, rootRelPath, null);
        if (projectInfo != null) {
            this.addProject(projectInfo);
            monitor.done();
            return;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            this.addError(new Exception(NLS.bind((String)Messages.LocalProjectScanner_accessDeniedFromFolder, (Object)baseDir.getAbsolutePath())));
            return;
        }
        monitor.setWorkRemaining(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                file = file.getCanonicalFile();
                this.scanFolder(file, String.valueOf(rootRelPath) + "/" + file.getName(), (IProgressMonitor)monitor.split(1));
            }
            catch (IOException ex) {
                this.addError(ex);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private MavenProjectInfo readMavenProjectInfo(File baseDir, String modulePath, MavenProjectInfo parentInfo) {
        Model model;
        block14: {
            block13: {
                baseDir = baseDir.getCanonicalFile();
                if (this.scannedFolders.add(baseDir)) break block13;
                return null;
            }
            model = this.modelManager.readMavenModel(new File(baseDir, "pom.xml"));
            if (model != null) break block14;
            return null;
        }
        try {
            String pomName = String.valueOf(modulePath) + "/" + model.getPomFile().getName();
            if (model.getArtifactId() == null) {
                throw new CoreException(Status.error((String)NLS.bind((String)Messages.LocalProjectScanner_missingArtifactId, (Object)pomName)));
            }
            MavenProjectInfo projectInfo = this.newMavenProjectInfo(pomName, model.getPomFile(), model, parentInfo);
            if (parentInfo == null) {
                projectInfo.setBasedirRename(this.getBasedirRename(projectInfo));
            }
            LinkedHashMap modules = new LinkedHashMap();
            for (String string : model.getModules()) {
                void var8_10;
                if (string.endsWith("/pom.xml")) {
                    String string2 = string.substring(0, string.length() - "/pom.xml".length());
                }
                modules.put(var8_10, new HashSet());
            }
            for (Profile profile : model.getProfiles()) {
                for (String module : profile.getModules()) {
                    HashSet<String> profiles;
                    if (module.endsWith("/pom.xml")) {
                        module = module.substring(0, module.length() - "/pom.xml".length());
                    }
                    if ((profiles = (HashSet<String>)modules.get(module)) == null) {
                        profiles = new HashSet<String>();
                        modules.put(module, profiles);
                    }
                    profiles.add(profile.getId());
                }
            }
            for (Map.Entry entry : modules.entrySet()) {
                String module;
                module = (String)entry.getKey();
                Set profiles = (Set)entry.getValue();
                File moduleBaseDir = new File(baseDir, module);
                MavenProjectInfo moduleInfo = this.readMavenProjectInfo(moduleBaseDir, module, projectInfo);
                if (moduleInfo == null) continue;
                moduleInfo.addProfiles(profiles);
                projectInfo.add(moduleInfo);
            }
            return projectInfo;
        }
        catch (IOException | CoreException ex) {
            this.addError(ex);
            return null;
        }
    }

    protected MavenProjectInfo newMavenProjectInfo(String label, File pomFile, Model model, MavenProjectInfo parent) {
        return new MavenProjectInfo(label, pomFile, model, parent);
    }

    @Override
    public String getDescription() {
        return this.folders.toString();
    }

    private int getBasedirRename(MavenProjectInfo mavenProjectInfo) {
        if (this.basedirRemameRequired) {
            return 2;
        }
        return 0;
    }
}

