/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalChar;

public final class UCharLimit
extends LimitType {
    public static final UCharLimit MAXIMUM = new UCharLimit(Integer.MAX_VALUE);
    public static final UCharLimit MINIMUM = new UCharLimit(0);
    private final int value;

    public UCharLimit(UniversalChar uc) {
        this.value = uc.toCodePoint();
    }

    public UCharLimit(int value) {
        this.value = value;
    }

    @Override
    public LimitType decrement() {
        return new UCharLimit(this.value - 1);
    }

    @Override
    public LimitType.Type getType() {
        return LimitType.Type.UCHAR;
    }

    @Override
    public LimitType increment() {
        return new UCharLimit(this.value + 1);
    }

    @Override
    public boolean isAdjacent(LimitType other) {
        UCharLimit ucl = (UCharLimit)other;
        return this.value + 1 == ucl.value;
    }

    @Override
    public void toString(StringBuilder sb) {
        UniversalChar uc = new UniversalChar(this.value);
        sb.append(uc.toString());
    }

    @Override
    public int compareTo(LimitType o) {
        UCharLimit ucl = (UCharLimit)o;
        if (this.value < ucl.value) {
            return -1;
        }
        if (this.value == ucl.value) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UCharLimit)) {
            return false;
        }
        UCharLimit other = (UCharLimit)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }
}

