/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.core.TITANJavaBuilder;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class ExternalTitanAction
extends AbstractHandler
implements IWorkbenchWindowActionDelegate {
    public static final String EXECUTION_FAILED = "execution failed";
    public static final String INTERRUPTION = "execution failed because of interruption";
    protected static final String NO_VALID_FILES = "No valid files were selected.";
    protected static final String FAILURE_SUFFIX = " ...failed";
    public static final String SHELL = "sh";
    public static final String SYNTAX_CHECK_FLAG = "p";
    public static final String SEMANTIC_CHECK_FLAG = "s";
    public static final String VERSION_CHECK_FLAG = "v";
    public static final String GENERATE_TESTPORT_FLAG = "t";
    private static final String DOT = ".";
    private static final String COMPILER_SUBPATH = File.separatorChar + "bin" + File.separatorChar + "compiler";
    protected ISelection selection;
    protected Map<String, IFile> files = new HashMap<String, IFile>();
    protected File workingDir;
    protected IProject project;
    protected IProject singleSelectedProject = null;
    protected HashSet<String> javaProjects = new HashSet();

    public final void init(IWorkbenchWindow window) {
        if (!this.files.isEmpty()) {
            this.files.clear();
        }
    }

    public final void dispose() {
        this.files.clear();
        this.workingDir = null;
        this.project = null;
    }

    protected final Path getCompilerPath() {
        IPreferencesService prefs = Platform.getPreferencesService();
        String pathOfTITAN = prefs.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.TTCN3_INSTALL_DIR", "", null);
        return new Path(pathOfTITAN + COMPILER_SUBPATH);
    }

    public final void reportOnTheFlyOutdating() {
        if (this.project == null) {
            return;
        }
        try {
            if (!this.files.isEmpty()) {
                for (IFile file : this.files.values()) {
                    if (file.findMarkers("org.eclipse.titan.designer.ontheflySyntacticMarker", true, 2).length != 0) {
                        GlobalParser.getProjectSourceParser(this.project).reportOutdating(file);
                    }
                    if (file.findMarkers("org.eclipse.titan.designer.ontheflySemanticMarker", true, 2).length != 0) {
                        GlobalParser.getProjectSourceParser(this.project).reportOutdating(file);
                    }
                    if (file.findMarkers("org.eclipse.titan.designer.ontheflyMixedMarker", true, 2).length == 0) continue;
                    GlobalParser.getProjectSourceParser(this.project).reportOutdating(file);
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    protected final String getTITANActionFlags() {
        StringBuilder builder = new StringBuilder();
        IPreferencesService prefs = Platform.getPreferencesService();
        if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.TITANActions.default_as_omit", false, null)) {
            builder.append('d');
        }
        return builder.toString();
    }

    public final void buildFileList(IResource resource) {
        if (resource == null) {
            return;
        }
        this.project = resource.getProject();
        if (!this.project.isAccessible() || !resource.isAccessible()) {
            return;
        }
        this.workingDir = new File(this.project.getLocation().toOSString());
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean processExludedOnes = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.TITANActions.processExcludedResources", true, null);
        try {
            if (!processExludedOnes) {
                IContainer parent = resource.getParent();
                while (parent instanceof IFolder) {
                    if (ResourceExclusionHelper.isDirectlyExcluded((IFolder)parent)) {
                        return;
                    }
                    parent = parent.getParent();
                }
            }
            resource.accept((IResourceVisitor)new InternalResourceVisitor(processExludedOnes));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    protected final void processSelection() {
        this.singleSelectedProject = null;
        IWorkbenchPage iwPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.selection = iwPage.getSelection();
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)this.selection;
            this.files = new HashMap<String, IFile>();
            List selectionList = structSelection.toList();
            if (selectionList.size() == 1 && selectionList.get(0) instanceof IProject) {
                this.singleSelectedProject = (IProject)selectionList.get(0);
            }
            for (Object selected : selectionList) {
                if (selected instanceof IFile) {
                    this.buildFileList((IResource)((IFile)selected));
                    continue;
                }
                if (selected instanceof IFolder) {
                    this.buildFileList((IResource)((IFolder)selected));
                    continue;
                }
                if (!(selected instanceof IProject)) continue;
                this.buildFileList((IResource)((IProject)selected));
            }
        }
    }

    protected String getExtensionPattern() {
        return ".*";
    }

    protected IProject getSelectionProject() {
        IWorkbenchPage iwPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.selection = iwPage.getSelection();
        if (this.selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)this.selection;
            TreePath[] treePaths = treeSelection.getPaths();
            TreePath treePath = treePaths[0];
            Object projSegmentObj = treePath.getFirstSegment();
            return (IProject)((IAdaptable)projSegmentObj).getAdapter(IProject.class);
        }
        return null;
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    private final class InternalResourceVisitor
    implements IResourceVisitor {
        private final boolean processExludedOnes;
        private ResourceExclusionHelper helper = null;

        public InternalResourceVisitor(boolean processExludedOnes) {
            this.processExludedOnes = processExludedOnes;
            if (!processExludedOnes) {
                this.helper = new ResourceExclusionHelper();
            }
        }

        public boolean visit(IResource resource) {
            if (!resource.isAccessible() || resource.getLocation() != null && resource.getLocation().lastSegment().startsWith(ExternalTitanAction.DOT)) {
                return false;
            }
            if (TITANJavaBuilder.isBuilderEnabled(resource.getProject())) {
                ExternalTitanAction.this.javaProjects.add(resource.getProject().getName());
                return false;
            }
            switch (resource.getType()) {
                case 1: {
                    if (!this.processExludedOnes && (ResourceExclusionHelper.isDirectlyExcluded((IFile)resource) || this.helper.isExcludedByRegexp(resource.getName()))) {
                        return false;
                    }
                    IFile file = (IFile)resource;
                    String extension = file.getFileExtension();
                    if (extension == null) {
                        extension = "";
                    }
                    if (!extension.matches(ExternalTitanAction.this.getExtensionPattern())) {
                        return false;
                    }
                    ExternalTitanAction.this.files.put(file.getLocation().toOSString(), file);
                    return true;
                }
                case 2: {
                    String dirname;
                    if (resource.isVirtual() && (dirname = resource.getFullPath().lastSegment()).startsWith(ExternalTitanAction.DOT)) {
                        return false;
                    }
                    return this.processExludedOnes || !ResourceExclusionHelper.isDirectlyExcluded((IFolder)resource) && !this.helper.isExcludedByRegexp(resource.getName());
                }
            }
            return true;
        }
    }
}

