/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.tuple.Triple;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.designer.editors.CodeMiningMaps;
import org.eclipse.titan.designer.editors.DocumentTracker;
import org.eclipse.titan.designer.editors.ttcn3editor.ContentCodeMining;
import org.eclipse.titan.designer.editors.ttcn3editor.HeaderCodeMining;
import org.eclipse.titan.designer.editors.ttcn3editor.LineEndCodeMining;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodeMiningProvider
extends AbstractCodeMiningProvider {
    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList minings = new ArrayList();
            IPreferencesService prefs = Platform.getPreferencesService();
            boolean isMiningsEnabled = prefs.getBoolean("org.eclipse.titan.designer", ".enableCodeMinings", false, null);
            if (!isMiningsEnabled) {
                return minings;
            }
            IDocument document = viewer.getDocument();
            ITextEditor textEditor = (ITextEditor)super.getAdapter(ITextEditor.class);
            if (textEditor instanceof TTCN3Editor) {
                IFile file = DocumentTracker.getFile(document);
                if (file != null) {
                    IntObjectHashMap<Triple<String, Image, Object>> headerMinings = CodeMiningMaps.getCodeMinings(CodeMiningMaps.CodeMiningType.Header, file);
                    headerMinings.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
                        try {
                            minings.add(new HeaderCodeMining(key, document, (ICodeMiningProvider)this, value.getThree(), (String)value.getOne(), (Image)value.getTwo()));
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    });
                    IntObjectHashMap<Triple<String, Image, Object>> contentMinings = CodeMiningMaps.getCodeMinings(CodeMiningMaps.CodeMiningType.Content, file);
                    contentMinings.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
                        Position pos = new Position(key, ((String)value.getOne()).length());
                        if (value.getThree() instanceof Boolean) {
                            minings.add(new LineEndCodeMining(pos, (ICodeMiningProvider)this, (String)value.getOne(), (Image)value.getTwo()));
                        } else {
                            minings.add(new ContentCodeMining(pos, (ICodeMiningProvider)this, (String)value.getOne(), (Image)value.getTwo()));
                        }
                    });
                }
                return minings;
            }
            return null;
        });
    }
}

