/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.core.SymbolicLinkHandler;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.wizards.NewTTCN3ModuleCreationWizardPage;
import org.eclipse.titan.designer.wizards.NewTTCN3ModuleOptionsWizardPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public final class NewTTCN3ModuleWizard
extends BasicNewResourceWizard {
    public static final String NEWTTCN3MODULEWIZARD = "org.eclipse.titan.designer.wizards.NewTTCN3ModuleWizard";
    private static final String WIZARD_TITLE = "New TTCN3 Module";
    private static final String TRUE = "true";
    private NewTTCN3ModuleCreationWizardPage mainPage;
    private NewTTCN3ModuleOptionsWizardPage optionsPage;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WIZARD_TITLE);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewTTCN3ModuleCreationWizardPage(this.getSelection(), this);
        this.addPage((IWizardPage)this.mainPage);
        this.optionsPage = new NewTTCN3ModuleOptionsWizardPage();
        this.addPage((IWizardPage)this.optionsPage);
    }

    NewTTCN3ModuleOptionsWizardPage getOptionsPage() {
        return this.optionsPage;
    }

    public boolean performFinish() {
        IFile newModule;
        if (this.mainPage.getContainerFullPath().append(this.mainPage.getFileName()).getFileExtension() == null) {
            this.mainPage.setFileName(this.mainPage.getFileName() + '.' + GlobalParser.SUPPORTED_TTCN3_EXTENSIONS[1]);
        }
        if ((newModule = this.mainPage.createNewFile()) != null) {
            try {
                if (this.optionsPage.isExcludeFromBuildSelected()) {
                    newModule.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.File", "excludeFromBuild"), TRUE);
                }
                ProjectFileHandler pfHandler = new ProjectFileHandler(newModule.getProject());
                pfHandler.saveProjectSettings();
                newModule.touch((IProgressMonitor)new NullProgressMonitor());
                WorkspaceJob refreshJob = new WorkspaceJob("Refreshing built resources"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        boolean proceedingOK = SymbolicLinkHandler.createSymlinks((IResource)newModule);
                        if (proceedingOK) {
                            proceedingOK = TITANBuilder.regenerateMakefile(newModule.getProject());
                        }
                        if (proceedingOK) {
                            proceedingOK = TITANBuilder.removeExecutable(newModule.getProject());
                        }
                        if (proceedingOK) {
                            TITANBuilder.invokeBuild(newModule.getProject());
                        }
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.setPriority(30);
                refreshJob.setUser(false);
                refreshJob.setSystem(true);
                refreshJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
                refreshJob.schedule();
                this.selectAndRevealNewModule(newModule);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        return true;
    }

    private void selectAndRevealNewModule(IFile newModule) {
        IWorkbench workbench = this.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            IEditorDescriptor desc = TTCN3Editor.findTTCN3Editor(workbench);
            IWorkbenchPage page = window.getActivePage();
            try {
                page.openEditor((IEditorInput)new FileEditorInput(newModule), desc.getId());
            }
            catch (PartInitException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        this.selectAndReveal((IResource)newModule);
    }
}

