/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseProjectCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class LanguageMixing
extends BaseProjectCodeSmellSpotter {
    private static final String ERR_MSG = "Project `{0}'' contains TTCN-3 modules of several language versions: module `{1}'' is of `{2}'', while module `{3}'' is of `{4}'' ";

    public LanguageMixing() {
        super(CodeSmellType.LANGUAGE_MIXING);
    }

    @Override
    protected void process(IProject project, BaseCodeSmellSpotter.Problems problems) {
        TITANDebugConsole.println((String[])new String[]{"Language mixing called"});
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        Set knownModuleNames = projectSourceParser.getKnownModuleNames();
        ArrayList<TTCN3Module> modules = new ArrayList<TTCN3Module>();
        for (String moduleName : new TreeSet(knownModuleNames)) {
            Module module = projectSourceParser.getModuleByName(moduleName);
            if (!(module instanceof TTCN3Module)) continue;
            modules.add((TTCN3Module)module);
        }
        Collections.sort(modules, new Comparator<TTCN3Module>(){

            @Override
            public int compare(TTCN3Module o1, TTCN3Module o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        String lastLanguage = null;
        TTCN3Module lastModule = null;
        for (TTCN3Module module : modules) {
            String tempLanguage;
            List languageSpecifications = module.getLanguageSpecifictions();
            if (languageSpecifications == null || languageSpecifications.isEmpty() || (tempLanguage = (String)languageSpecifications.get(0)) == null) continue;
            if (lastLanguage == null) {
                lastLanguage = tempLanguage;
                lastModule = module;
                continue;
            }
            if (tempLanguage.equals(lastLanguage)) continue;
            problems.report(module.getIdentifier().getLocation(), MessageFormat.format(ERR_MSG, project.getName(), module.getName(), tempLanguage, lastModule.getName(), lastLanguage));
        }
    }
}

