/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Pattern;
import org.eclipse.titan.runtime.core.TTCN_Snapshot;
import org.eclipse.titan.runtime.core.TitanBitString;
import org.eclipse.titan.runtime.core.TitanBitString_Element;
import org.eclipse.titan.runtime.core.TitanBitString_template;
import org.eclipse.titan.runtime.core.TitanBoolean;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanCharString_Element;
import org.eclipse.titan.runtime.core.TitanCharString_template;
import org.eclipse.titan.runtime.core.TitanFloat;
import org.eclipse.titan.runtime.core.TitanHexString;
import org.eclipse.titan.runtime.core.TitanHexString_Element;
import org.eclipse.titan.runtime.core.TitanHexString_template;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TitanOctetString_Element;
import org.eclipse.titan.runtime.core.TitanOctetString_template;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TitanUniversalCharString_Element;
import org.eclipse.titan.runtime.core.TitanUniversalCharString_template;
import org.eclipse.titan.runtime.core.Ttcn3Float;
import org.eclipse.titan.runtime.core.TtcnError;

public final class AdditionalFunctions {
    private static final int[] nibble_reverse_table = new int[]{0, 8, 4, 12, 2, 10, 6, 14, 1, 9, 5, 13, 3, 11, 7, 15, 128, 136, 132, 140, 130, 138, 134, 142, 129, 137, 133, 141, 131, 139, 135, 143, 64, 72, 68, 76, 66, 74, 70, 78, 65, 73, 69, 77, 67, 75, 71, 79, 192, 200, 196, 204, 194, 202, 198, 206, 193, 201, 197, 205, 195, 203, 199, 207, 32, 40, 36, 44, 34, 42, 38, 46, 33, 41, 37, 45, 35, 43, 39, 47, 160, 168, 164, 172, 162, 170, 166, 174, 161, 169, 165, 173, 163, 171, 167, 175, 96, 104, 100, 108, 98, 106, 102, 110, 97, 105, 101, 109, 99, 107, 103, 111, 224, 232, 228, 236, 226, 234, 230, 238, 225, 233, 229, 237, 227, 235, 231, 239, 16, 24, 20, 28, 18, 26, 22, 30, 17, 25, 21, 29, 19, 27, 23, 31, 144, 152, 148, 156, 146, 154, 150, 158, 145, 153, 149, 157, 147, 155, 151, 159, 80, 88, 84, 92, 82, 90, 86, 94, 81, 89, 85, 93, 83, 91, 87, 95, 208, 216, 212, 220, 210, 218, 214, 222, 209, 217, 213, 221, 211, 219, 215, 223, 48, 56, 52, 60, 50, 58, 54, 62, 49, 57, 53, 61, 51, 59, 55, 63, 176, 184, 180, 188, 178, 186, 182, 190, 177, 185, 181, 189, 179, 187, 183, 191, 112, 120, 116, 124, 114, 122, 118, 126, 113, 121, 117, 125, 115, 123, 119, 127, 240, 248, 244, 252, 242, 250, 246, 254, 241, 249, 245, 253, 243, 251, 247, 255};
    private static final int[] bit_reverse_table = new int[]{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};
    private static final char[] UTF8_BOM = new char[]{'\u00ef', '\u00bb', '\u00bf'};
    private static final char[] UTF16BE_BOM = new char[]{'\u00fe', '\u00ff'};
    private static final char[] UTF16LE_BOM = new char[]{'\u00ff', '\u00fe'};
    private static final char[] UTF32BE_BOM = new char[]{'\u0000', '\u0000', '\u00fe', '\u00ff'};
    private static final char[] UTF32LE_BOM = new char[]{'\u00ff', '\u00fe', '\u0000', '\u0000'};
    private static final String code_table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static int[] decode_table = new int[]{80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 62, 80, 80, 80, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 80, 80, 80, 70, 80, 80, 80, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 80, 80, 80, 80, 80, 80, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 80, 80, 80, 80, 80};
    private static final char base64padding = '=';
    private static boolean rndSeedSet = false;
    private static final Random random = new Random();

    private AdditionalFunctions() {
    }

    public static byte char_to_hexdigit(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        return -1;
    }

    public static char hexdigit_to_char(int hexdigit) {
        if (hexdigit < 16) {
            return "0123456789ABCDEF?*".charAt(hexdigit);
        }
        return '\u0000';
    }

    private static TitanCharString.CharCoding is_ascii(TitanOctetString ostr) {
        int nonASCII = 128;
        TitanCharString.CharCoding ret = TitanCharString.CharCoding.ASCII;
        byte[] strptr = ostr.get_value();
        for (int i = 0; i < strptr.length; ++i) {
            if ((strptr[i] & 0xFF & 0x80) == 0) continue;
            ret = TitanCharString.CharCoding.UNKNOWN;
            break;
        }
        return ret;
    }

    private static TitanCharString.CharCoding is_utf8(TitanOctetString ostr) {
        int MSB = 128;
        int MSBmin1 = 64;
        byte[] strptr = ostr.get_value();
        for (int i = 0; ostr.lengthof().get_int() > i; ++i) {
            if ((strptr[i] & 0xFF & 0x80) == 0) continue;
            int maskUTF8 = 64;
            if ((strptr[i] & 0xFF & maskUTF8) == 0) {
                return TitanCharString.CharCoding.UNKNOWN;
            }
            int noofUTF8 = 0;
            while ((strptr[i] & 0xFF & maskUTF8) != 0) {
                ++noofUTF8;
                maskUTF8 >>= 1;
            }
            while (0 < noofUTF8) {
                if (++i >= ostr.lengthof().get_int() || (strptr[i] & 0xFF & 0x80) == 0 || (strptr[i] & 0xFF & 0x40) != 0) {
                    return TitanCharString.CharCoding.UNKNOWN;
                }
                --noofUTF8;
            }
        }
        return TitanCharString.CharCoding.UTF_8;
    }

    public static TitanCharString int2char(int value) {
        if (value < 0 || value > 127) {
            throw new TtcnError(MessageFormat.format("The argument of function int2char() is {0}, which is outside the allowed range 0 .. 127.", value));
        }
        return new TitanCharString(String.valueOf(Character.toChars(value)[0]));
    }

    public static TitanCharString int2char(TitanInteger value) {
        value.must_bound("The argument of function int2char() is an unbound integer value.");
        int ivt = value.get_int();
        if (ivt < 0 || ivt > 127) {
            throw new TtcnError(MessageFormat.format("The argument of function int2char() is {0}, which is outside the allowed range 0 .. 127.", value));
        }
        return new TitanCharString(String.valueOf(Character.toChars(ivt)[0]));
    }

    public static TitanUniversalCharString int2unichar(int value) {
        if (value < 0 || value > Integer.MAX_VALUE) {
            throw new TtcnError(MessageFormat.format("The argument of function int2unichar() is {0}, which outside the allowed range 0 .. 2147483647.", value));
        }
        return new TitanUniversalCharString(Character.toChars(value >> 24)[0], Character.toChars(value >> 16 & 0xFF)[0], Character.toChars(value >> 8 & 0xFF)[0], Character.toChars(value & 0xFF)[0]);
    }

    public static TitanUniversalCharString int2unichar(TitanInteger value) {
        value.must_bound("The argument of function int2unichar() is an unbound integer value.");
        int ivt = value.get_int();
        if (ivt < 0 || ivt > Integer.MAX_VALUE) {
            throw new TtcnError(MessageFormat.format("The argument of function int2unichar() is {0}, which outside the allowed range 0 .. 2147483647.", value));
        }
        return AdditionalFunctions.int2unichar(ivt);
    }

    public static TitanBitString int2bit(int value, int length) {
        return AdditionalFunctions.int2bit(new TitanInteger(value), length);
    }

    public static TitanBitString int2bit(int value, TitanInteger length) {
        length.must_bound("The second argument (length) of function int2bit() is an unbound integer value.");
        return AdditionalFunctions.int2bit(value, length.get_int());
    }

    public static TitanBitString int2bit(TitanInteger value, int length) {
        int i;
        value.must_bound("The first argument (value) of function int2bit() is an unbound integer value.");
        if (value.is_less_than(0)) {
            throw new TtcnError(MessageFormat.format("The first argument (value) of function int2bit() is a negative integer value: {0}.", value));
        }
        if (length < 0) {
            throw new TtcnError(MessageFormat.format("The second argument (length) of function int2bit() is a negative integer value: {0}.", length));
        }
        if (value.is_native()) {
            int i2;
            int tempValue = value.get_int();
            int[] bits_ptr = new int[(length + 7) / 8];
            for (i2 = 0; i2 < (length + 7) / 8; ++i2) {
                bits_ptr[i2] = 0;
            }
            for (i2 = length - 1; tempValue != 0 && i2 >= 0; tempValue >>= 1, --i2) {
                int temp;
                if ((tempValue & 1) <= 0) continue;
                bits_ptr[i2 / 8] = temp = bits_ptr[i2 / 8] | 1 << i2 % 8;
            }
            if (tempValue != 0) {
                i2 = 0;
                while (tempValue != 0) {
                    tempValue >>= 1;
                    ++i2;
                }
                throw new TtcnError(MessageFormat.format("The first argument of function int2bit(), which is {0}, does not fit in {1} bit{2}, needs at least {3}.", value, length, length > 1 ? "s" : "", length + i2));
            }
            return new TitanBitString(bits_ptr, length);
        }
        BigInteger tempValue = value.get_BigInteger();
        int[] bits_ptr = new int[(length + 7) / 8];
        for (i = 0; i < (length + 7) / 8; ++i) {
            bits_ptr[i] = 0;
        }
        for (i = length - 1; tempValue.compareTo(BigInteger.ZERO) == 1 && i >= 0; --i) {
            if (tempValue.and(BigInteger.ONE).compareTo(BigInteger.ZERO) == 1) {
                int temp;
                bits_ptr[i / 8] = temp = bits_ptr[i / 8] | 1 << i % 8;
            }
            tempValue = tempValue.shiftRight(1);
        }
        if (tempValue.compareTo(BigInteger.ZERO) != 0) {
            i = 0;
            while (tempValue.compareTo(BigInteger.ZERO) == 1) {
                tempValue = tempValue.shiftRight(1);
                ++i;
            }
            throw new TtcnError(MessageFormat.format("The first argument of function int2bit(), which is {0}, does not fit in {1} bit{2}, needs at least {3}.", value, length, length > 1 ? "s" : "", length + i));
        }
        return new TitanBitString(bits_ptr, length);
    }

    public static TitanBitString int2bit(TitanInteger value, TitanInteger length) {
        value.must_bound("The first argument (value) of function int2bit() is an unbound integer value.");
        length.must_bound("The second argument (length) of function int2bit() is an unbound integer value.");
        return AdditionalFunctions.int2bit(value, length.get_int());
    }

    public static TitanHexString int2hex(int value, int length) {
        return AdditionalFunctions.int2hex(new TitanInteger(value), length);
    }

    public static TitanHexString int2hex(int value, TitanInteger length) {
        length.must_bound("The second argument (length) of function int2hex() is an unbound integer value.");
        return AdditionalFunctions.int2hex(value, length.get_int());
    }

    public static TitanHexString int2hex(TitanInteger value, int length) {
        int i;
        value.must_bound("The first argument (value) of function int2hex() is an unbound integer value.");
        if (value.is_less_than(0)) {
            throw new TtcnError(MessageFormat.format("The first argument (value) of function int2hex() is a negative integer value: {0}.", value));
        }
        if (length < 0) {
            throw new TtcnError(MessageFormat.format("The second argument (length) of function int2hex() is a negative integer value: {0}.", length));
        }
        if (value.is_native()) {
            int i2;
            int tmp_value = value.get_int();
            byte[] nibbles_ptr = new byte[length];
            for (i2 = length - 1; i2 >= 0; --i2) {
                nibbles_ptr[i2] = (byte)(tmp_value & 0xF);
                tmp_value >>= 4;
            }
            if (tmp_value != 0) {
                i2 = 0;
                while (tmp_value != 0) {
                    tmp_value >>= 4;
                    ++i2;
                }
                throw new TtcnError(MessageFormat.format("The first argument of function int2hex(), which is {0}, does not fit in {1} hexadecimal digit{2}, needs at least {3}.", value, length, length > 1 ? "s" : "", length + i2));
            }
            return new TitanHexString(nibbles_ptr);
        }
        BigInteger tmp_value = value.get_BigInteger();
        byte[] nibbles_ptr = new byte[length];
        for (i = length - 1; i >= 0; --i) {
            BigInteger temp = tmp_value.and(BigInteger.valueOf(15L));
            nibbles_ptr[i] = temp.byteValue();
            tmp_value = tmp_value.shiftRight(4);
        }
        if (tmp_value.compareTo(BigInteger.ZERO) != 0) {
            i = 0;
            while (tmp_value.compareTo(BigInteger.ZERO) != 0) {
                tmp_value = tmp_value.shiftRight(4);
                ++i;
            }
            throw new TtcnError(MessageFormat.format("The first argument of function int2hex(), which is {0}, does not fit in {1} hexadecimal digit{2}, needs at least {3}.", value, length, length > 1 ? "s" : "", length + i));
        }
        return new TitanHexString(nibbles_ptr);
    }

    public static TitanHexString int2hex(TitanInteger value, TitanInteger length) {
        value.must_bound("The first argument (value) of function int2hex() is an unbound integer value.");
        length.must_bound("The second argument (length) of function int2hex() is an unbound integer value.");
        return AdditionalFunctions.int2hex(value, length.get_int());
    }

    public static TitanOctetString int2oct(int value, int length) {
        if (value < 0) {
            throw new TtcnError(MessageFormat.format("The first argument (value) of function int2oct() is a negative integer value:", value));
        }
        if (length < 0) {
            throw new TtcnError(MessageFormat.format("The second argument (length) of function int2oct() is a negative integer value:", length));
        }
        byte[] octets_ptr = new byte[length];
        int tmp_value = value;
        for (int i = length - 1; i >= 0; --i) {
            octets_ptr[i] = (byte)(tmp_value & 0xFF);
            tmp_value >>= 8;
        }
        if (tmp_value != 0) {
            throw new TtcnError(MessageFormat.format("The first argument of function int2oct(), which is {0}, does not fit in {1} octet{2}.", value, length, length > 1 ? "s" : ""));
        }
        return new TitanOctetString(octets_ptr);
    }

    public static TitanOctetString int2oct(int value, TitanInteger length) {
        length.must_bound("The second argument (length) of function int2oct() is an unbound integer value.");
        return AdditionalFunctions.int2oct(value, length.get_int());
    }

    public static TitanOctetString int2oct(TitanInteger value, int length) {
        int i;
        value.must_bound("The first argument (value) of function int2oct() is an unbound integer value.");
        if (value.is_native()) {
            return AdditionalFunctions.int2oct(value.get_int(), length);
        }
        if (value.is_less_than(0)) {
            throw new TtcnError(MessageFormat.format("The first argument (value) of function int2oct() is a negative integer value: {0}.", value));
        }
        if (length < 0) {
            throw new TtcnError(MessageFormat.format("The second argument (length) of function int2oct() is a negative integer value: {0}.", length));
        }
        BigInteger tmp_val = value.get_BigInteger();
        byte[] octets_ptr = new byte[length];
        BigInteger helper = new BigInteger("255");
        for (i = length - 1; i >= 0; --i) {
            octets_ptr[i] = (byte)tmp_val.and(helper).intValue();
            tmp_val = tmp_val.shiftRight(8);
        }
        if (tmp_val.compareTo(BigInteger.ZERO) != 0) {
            i = 0;
            while (tmp_val.compareTo(BigInteger.ZERO) == 1) {
                tmp_val = tmp_val.shiftRight(8);
                ++i;
            }
            throw new TtcnError(MessageFormat.format("The first argument of function int2oct(), which is {0}, does not fit in {1} octet{2}, needs at least {3}.", value, length, length > 1 ? "s" : "", length + i));
        }
        return new TitanOctetString(octets_ptr);
    }

    public static TitanOctetString int2oct(TitanInteger value, TitanInteger length) {
        value.must_bound("The first argument (value) of function int2oct() is an unbound integer value.");
        length.must_bound("The second argument (length) of function int2oct() is an unbound integer value.");
        if (value.is_native()) {
            return AdditionalFunctions.int2oct(value.get_int(), length.get_int());
        }
        return AdditionalFunctions.int2oct(value, length.get_int());
    }

    public static TitanCharString int2str(int value) {
        return new TitanCharString(Integer.toString(value));
    }

    public static TitanCharString int2str(TitanInteger value) {
        value.must_bound("The argument of function int2str() is an unbound integer value.");
        if (value.is_native()) {
            return AdditionalFunctions.int2str(value.get_int());
        }
        return new TitanCharString(value.get_BigInteger().toString());
    }

    public static TitanFloat int2float(int value) {
        return new TitanFloat(value);
    }

    public static TitanFloat int2float(TitanInteger value) {
        value.must_bound("The argument of function int2float() is an unbound integer value.");
        if (value.is_native()) {
            return AdditionalFunctions.int2float(value.get_int());
        }
        return new TitanFloat(value.get_BigInteger().doubleValue());
    }

    public static TitanInteger float2int(double value) {
        if (value > -2.147483648E9 && value < 2.147483647E9) {
            return new TitanInteger((int)value);
        }
        try {
            return new TitanInteger(new BigDecimal(value).toBigInteger());
        }
        catch (NumberFormatException e) {
            throw new TtcnError("Conversion of float value `" + value + "' to integer failed");
        }
    }

    public static TitanInteger float2int(Ttcn3Float value) {
        return AdditionalFunctions.float2int(value.getValue());
    }

    public static TitanInteger float2int(TitanFloat value) {
        value.must_bound("The argument of function float2int() is an unbound float value.");
        return AdditionalFunctions.float2int(value.get_value());
    }

    public static TitanInteger char2int(char value) {
        if (value > '\u007f') {
            throw new TtcnError(MessageFormat.format("The argument of function char2int() contains a character with character code {0}, which is outside the allowed range 0 .. 127.", Character.valueOf(value)));
        }
        return new TitanInteger(value);
    }

    public static TitanInteger char2int(String value) {
        if (value == null) {
            throw new TtcnError("The length of the argument in function char2int() must be exactly 1 instead of 0.");
        }
        if (value.length() != 1) {
            throw new TtcnError(MessageFormat.format("The length of the argument in function char2int() must be exactly 1 instead of {0}.", value.length()));
        }
        return AdditionalFunctions.char2int(value.charAt(0));
    }

    public static TitanInteger char2int(TitanCharString value) {
        value.must_bound("The argument of function char2int() is an unbound charstring value.");
        if (value.lengthof().get_int() != 1) {
            throw new TtcnError(MessageFormat.format("The length of the argument in function char2int() must be exactly 1 instead of {0}.", value.lengthof()));
        }
        return AdditionalFunctions.char2int(value.constGet_at(0).get_char());
    }

    public static TitanInteger char2int(TitanCharString_Element value) {
        value.must_bound("The argument of function char2int() is an unbound charstring element.");
        return AdditionalFunctions.char2int(value.get_char());
    }

    public static TitanOctetString char2oct(String value) {
        if (value == null || value.length() <= 0) {
            return new TitanOctetString("");
        }
        byte[] octets_ptr = new byte[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            octets_ptr[i] = AdditionalFunctions.int2oct((int)value.charAt(i), 1).get_nibble(0);
        }
        return new TitanOctetString(octets_ptr);
    }

    public static TitanOctetString char2oct(TitanCharString value) {
        value.must_bound("The argument of function char2oct() is an unbound charstring value.");
        return AdditionalFunctions.char2oct(value.get_value().toString());
    }

    public static TitanOctetString char2oct(TitanCharString_Element value) {
        value.must_bound("The argument of function char2oct() is an unbound charstring element.");
        return AdditionalFunctions.char2oct(String.valueOf(value.get_char()));
    }

    public static TitanInteger unichar2int(TitanUniversalChar value) {
        if (value.getUc_group() > '\u007f') {
            throw new TtcnError(MessageFormat.format("The argument of function unichar2int() is the invalid quadruple char {0},the first number of which is outside the allowed range 0 .. 127.", Character.valueOf(value.getUc_group())));
        }
        int result = value.getUc_group() << 24 | value.getUc_plane() << 16 | value.getUc_row() << 8 | value.getUc_cell();
        return new TitanInteger(result);
    }

    public static TitanInteger unichar2int(TitanUniversalCharString value) {
        value.must_bound("The argument of function unichar2int() is an unbound universal charstring value.");
        if (value.lengthof().get_int() != 1) {
            throw new TtcnError(MessageFormat.format("The length of the argument in function unichar2int() must be exactly 1 instead of {0}.", value.lengthof().get_int()));
        }
        return AdditionalFunctions.unichar2int(value.get_value().get(0));
    }

    public static TitanInteger unichar2int(TitanUniversalCharString_Element value) {
        value.must_bound("The argument of function unichar2int() is an unbound universal charstring element.");
        return AdditionalFunctions.unichar2int(value.get_char());
    }

    public static TitanInteger bit2int(TitanBitString value) {
        int start_index;
        value.must_bound("The argument of function bit2int() is an unbound bitstring value.");
        int n_bits = value.lengthof().get_int();
        int[] temp = value.get_value();
        for (start_index = 0; start_index < n_bits && (temp[start_index / 8] & 1 << start_index % 8) == 0; ++start_index) {
        }
        if (n_bits - start_index < 32) {
            int ret_val = 0;
            for (int i = start_index; i < n_bits; ++i) {
                ret_val <<= 1;
                if ((temp[i / 8] & 1 << i % 8) == 0) continue;
                ++ret_val;
            }
            return new TitanInteger(ret_val);
        }
        int ret_val = 0;
        for (int i = start_index; i < start_index + 31; ++i) {
            ret_val <<= 1;
            if ((temp[i / 8] & 1 << i % 8) == 0) continue;
            ++ret_val;
        }
        BigInteger ret_val2 = BigInteger.valueOf(ret_val);
        for (int i = start_index + 31; i < n_bits; ++i) {
            ret_val2 = ret_val2.shiftLeft(1);
            if ((temp[i / 8] & 1 << i % 8) == 0) continue;
            ret_val2 = ret_val2.add(BigInteger.ONE);
        }
        return new TitanInteger(ret_val2);
    }

    public static TitanInteger bit2int(TitanBitString_Element value) {
        value.must_bound("The argument of function bit2int() is an unbound bitstring element.");
        return new TitanInteger(value.get_bit() ? 1 : 0);
    }

    public static TitanHexString bit2hex(TitanBitString value) {
        value.must_bound("The argument of function bit2hex() is an unbound bitstring value.");
        int n_bits = value.lengthof().get_int();
        int n_nibbles = (n_bits + 3) / 4;
        int padding_bits = 4 * n_nibbles - n_bits;
        int[] bits_ptr = value.get_value();
        byte[] nibbles_ptr = new byte[n_nibbles];
        for (int i = 0; i < n_bits; ++i) {
            if ((bits_ptr[i / 8] & 1 << i % 8) == 0) continue;
            int n = (i + padding_bits) / 4;
            nibbles_ptr[n] = (byte)(nibbles_ptr[n] | 1 << 3 - (i + padding_bits) % 4);
        }
        return new TitanHexString(nibbles_ptr);
    }

    public static TitanHexString bit2hex(TitanBitString_Element value) {
        value.must_bound("The argument of function bit2hex() is an unbound bitstring element.");
        return new TitanHexString((byte)(value.get_bit() ? 1 : 0));
    }

    public static TitanOctetString bit2oct(TitanBitString value) {
        value.must_bound("The argument of function bit2oct() is an unbound bitstring value.");
        int n_bits = value.lengthof().get_int();
        int n_octets = (n_bits + 7) / 8;
        int padding_bits = 8 * n_octets - n_bits;
        byte[] octets_ptr = new byte[n_octets];
        int[] bits_ptr = value.get_value();
        for (int i = 0; i < n_bits; ++i) {
            if ((bits_ptr[i / 8] & 1 << i % 8) == 0) continue;
            int n = (i + padding_bits) / 8;
            octets_ptr[n] = (byte)(octets_ptr[n] | 1 << 7 - (i + padding_bits) % 8);
        }
        return new TitanOctetString(octets_ptr);
    }

    public static TitanOctetString bit2oct(TitanBitString_Element value) {
        value.must_bound("The argument of function bit2oct() is an unbound bitstring element.");
        return new TitanOctetString((byte)(value.get_bit() ? 1 : 0));
    }

    public static TitanCharString bit2str(TitanBitString value) {
        value.must_bound("The argument of function bit2str() is an unbound bitstring value.");
        int n_bits = value.lengthof().get_int();
        StringBuilder ret_val = new StringBuilder(n_bits);
        for (int i = 0; i < n_bits; ++i) {
            if (value.get_bit(i)) {
                ret_val.append('1');
                continue;
            }
            ret_val.append('0');
        }
        return new TitanCharString(ret_val);
    }

    public static TitanCharString bit2str(TitanBitString_Element value) {
        value.must_bound("The argument of function bit2str() is an unbound bitstring element.");
        if (value.get_bit()) {
            return new TitanCharString("1");
        }
        return new TitanCharString("0");
    }

    public static TitanInteger hex2int(TitanHexString value) {
        value.must_bound("The argument of function hex2int() is an unbound hexstring value.");
        int n_nibbles = value.lengthof().get_int();
        int start_index = 0;
        for (start_index = 0; start_index < n_nibbles && value.get_nibble(start_index) == 0; ++start_index) {
        }
        if (n_nibbles - start_index < 8) {
            int ret_val = 0;
            for (int i = start_index; i < n_nibbles; ++i) {
                ret_val <<= 4;
                ret_val += value.get_nibble(i) & 0xF;
            }
            return new TitanInteger(ret_val);
        }
        int ret_val = 0;
        for (int i = start_index; i < start_index + 7; ++i) {
            ret_val <<= 4;
            ret_val += value.get_nibble(i) & 0xF;
        }
        BigInteger ret_val2 = BigInteger.valueOf(ret_val);
        for (int i = start_index + 7; i < n_nibbles; ++i) {
            ret_val2 = ret_val2.shiftLeft(4);
            ret_val2 = ret_val2.add(BigInteger.valueOf(value.get_nibble(i) & 0xF));
        }
        return new TitanInteger(ret_val2);
    }

    public static TitanInteger hex2int(TitanHexString_Element value) {
        value.must_bound("The argument of function hex2int() is an unbound hexstring element.");
        return new TitanInteger(value.get_nibble());
    }

    public static TitanBitString hex2bit(TitanHexString value) {
        value.must_bound("The argument of function hex2bit() is an unbound hexstring value.");
        int n_nibbles = value.lengthof().get_int();
        int[] bits_ptr = new int[(n_nibbles + 1) / 2];
        if (n_nibbles == 1) {
            byte temp = value.get_nibble(0);
            bits_ptr[0] = nibble_reverse_table[temp];
            return new TitanBitString(bits_ptr, 4);
        }
        byte[] nibbles_ptr = value.get_value();
        for (int i = 0; i < n_nibbles - 1; i += 2) {
            int temp = nibble_reverse_table[nibbles_ptr[i + 1]];
            temp <<= 4;
            bits_ptr[i / 2] = temp |= nibble_reverse_table[nibbles_ptr[i]];
        }
        if ((n_nibbles & 1) == 1) {
            bits_ptr[n_nibbles / 2] = nibble_reverse_table[nibbles_ptr[n_nibbles - 1]];
        }
        return new TitanBitString(bits_ptr, 4 * n_nibbles);
    }

    public static TitanBitString hex2bit(TitanHexString_Element value) {
        value.must_bound("The argument of function hex2bit() is an unbound hexstring element.");
        int[] bits_ptr = new int[]{nibble_reverse_table[value.get_nibble()]};
        return new TitanBitString(bits_ptr, 4);
    }

    public static TitanOctetString hex2oct(TitanHexString value) {
        value.must_bound("The argument of function hex2oct() is an unbound hexstring value.");
        int n_nibbles = value.lengthof().get_int();
        int n_octets = (n_nibbles + 1) / 2;
        int n_padding_nibble = n_nibbles % 2;
        byte[] octet_ptr = new byte[n_octets];
        byte[] nibbles_ptr = new byte[n_nibbles + n_padding_nibble];
        if ((n_nibbles & 1) == 1) {
            nibbles_ptr[0] = 0;
        }
        System.arraycopy(value.get_value(), 0, nibbles_ptr, n_padding_nibble, value.get_value().length);
        for (int i = 1; i < nibbles_ptr.length; i += 2) {
            octet_ptr[i / 2] = (byte)(nibbles_ptr[i - 1] << 4 | nibbles_ptr[i]);
        }
        return new TitanOctetString(octet_ptr);
    }

    public static TitanOctetString hex2oct(TitanHexString_Element value) {
        value.must_bound("The argument of function hex2oct() is an unbound hexstring element.");
        byte octet = value.get_nibble();
        return new TitanOctetString(octet);
    }

    public static TitanCharString hex2str(TitanHexString value) {
        value.must_bound("The argument of function hex2str() is an unbound hexstring value.");
        int n_nibbles = value.lengthof().get_int();
        StringBuilder ret_val = new StringBuilder();
        for (int i = 0; i < n_nibbles; ++i) {
            byte hexdigit = value.constGet_at(i).get_nibble();
            ret_val.append(AdditionalFunctions.hexdigit_to_char(hexdigit));
        }
        return new TitanCharString(ret_val);
    }

    public static TitanCharString hex2str(TitanHexString_Element value) {
        value.must_bound("The argument of function hex2str() is an unbound hexstring element.");
        return new TitanCharString(String.valueOf(AdditionalFunctions.hexdigit_to_char(value.get_nibble())));
    }

    public static TitanInteger oct2int(TitanOctetString value) {
        value.must_bound("The argument of function oct2int() is an unbound octetstring value.");
        byte[] octets_ptr = value.get_value();
        int n_octets = octets_ptr.length;
        int start_index = 0;
        for (start_index = 0; start_index < n_octets && octets_ptr[start_index] == 0; ++start_index) {
        }
        if (n_octets - start_index < 4) {
            int ret_val = 0;
            for (int i = start_index; i < n_octets; ++i) {
                ret_val <<= 8;
                ret_val += octets_ptr[i] & 0xFF;
            }
            return new TitanInteger(ret_val);
        }
        int ret_val = 0;
        for (int i = start_index; i < start_index + 3; ++i) {
            ret_val <<= 8;
            ret_val += octets_ptr[i] & 0xFF;
        }
        BigInteger ret_val2 = BigInteger.valueOf(ret_val);
        for (int i = start_index + 3; i < n_octets; ++i) {
            ret_val2 = ret_val2.shiftLeft(8);
            ret_val2 = ret_val2.add(BigInteger.valueOf(octets_ptr[i] & 0xFF));
        }
        return new TitanInteger(ret_val2);
    }

    public static TitanInteger oct2int(TitanOctetString_Element value) {
        value.must_bound("The argument of function oct2int() is an unbound octetstring element.");
        return new TitanInteger(value.get_nibble() & 0xFF);
    }

    public static TitanBitString oct2bit(TitanOctetString value) {
        value.must_bound("The argument of function oct2bit() is an unbound octetstring value.");
        int n_octets = value.lengthof().get_int();
        int[] bits_ptr = new int[n_octets];
        byte[] octets_ptr = value.get_value();
        for (int i = 0; i < n_octets; ++i) {
            bits_ptr[i] = bit_reverse_table[octets_ptr[i] & 0xFF];
        }
        return new TitanBitString(bits_ptr, 8 * n_octets);
    }

    public static TitanBitString oct2bit(TitanOctetString_Element value) {
        value.must_bound("The argument of function oct2bit() is an unbound octetstring value.");
        int bits = bit_reverse_table[value.get_nibble() & 0xFF];
        return new TitanBitString((byte)bits);
    }

    public static TitanHexString oct2hex(TitanOctetString value) {
        value.must_bound("The argument of function oct2hex() is an unbound octetstring value.");
        int n_octets = value.lengthof().get_int();
        byte[] ret_val = new byte[n_octets * 2];
        byte[] octets_ptr = value.get_value();
        for (int i = 0; i < n_octets; ++i) {
            ret_val[i * 2] = (byte)((octets_ptr[i] & 0xF0) >> 4);
            ret_val[i * 2 + 1] = (byte)(octets_ptr[i] & 0xF);
        }
        return new TitanHexString(ret_val);
    }

    public static TitanHexString oct2hex(TitanOctetString_Element value) {
        value.must_bound("The argument of function oct2hex() is an unbound octetstring element.");
        byte[] ret_val = new byte[]{(byte)((value.get_nibble() & 0xF0) >> 4), (byte)(value.get_nibble() & 0xF)};
        return new TitanHexString(ret_val);
    }

    public static TitanCharString oct2str(TitanOctetString value) {
        value.must_bound("The argument of function oct2str() is an unbound octetstring value.");
        StringBuilder ret_val = new StringBuilder();
        byte[] octets_ptr = value.get_value();
        int n_octets = octets_ptr.length;
        for (int i = 0; i < n_octets; ++i) {
            int digit = octets_ptr[i] & 0xFF;
            ret_val.append(AdditionalFunctions.hexdigit_to_char(digit / 16));
            ret_val.append(AdditionalFunctions.hexdigit_to_char(digit % 16));
        }
        return new TitanCharString(ret_val);
    }

    public static TitanCharString oct2str(TitanOctetString_Element value) {
        value.must_bound("The argument of function oct2str() is an unbound octetstring element.");
        StringBuilder ret_val = new StringBuilder();
        int digit = value.get_nibble() & 0xFF;
        ret_val.append(AdditionalFunctions.hexdigit_to_char(digit / 16));
        ret_val.append(AdditionalFunctions.hexdigit_to_char(digit % 16));
        return new TitanCharString(ret_val);
    }

    public static TitanCharString oct2char(TitanOctetString value) {
        value.must_bound("The argument of function oct2char() is an unbound octetstring value.");
        byte[] octets_ptr = value.get_value();
        int value_length = octets_ptr.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value_length; ++i) {
            if ((octets_ptr[i] & 0xFF) > 127) {
                throw new TtcnError(MessageFormat.format("The argument of function oct2char() contains octet {0} at index {1}, which is outside the allowed range 00 .. 7F.", value.get_nibble(i), i));
            }
            sb.append((char)(octets_ptr[i] & 0xFF));
        }
        return new TitanCharString(sb);
    }

    public static TitanCharString oct2char(TitanOctetString_Element value) {
        value.must_bound("The argument of function oct2char() is an unbound octetstring element.");
        int octet = value.get_nibble() & 0xFF;
        if (octet > 127) {
            throw new TtcnError(MessageFormat.format("The argument of function oct2char() contains the octet {0}, which is outside the allowed range 00 .. 7F.", octet));
        }
        return new TitanCharString(String.valueOf(octet));
    }

    public static TitanInteger str2int(String value) {
        return AdditionalFunctions.str2int(new TitanCharString(value));
    }

    public static TitanInteger str2int(TitanCharString value) {
        value.must_bound("The argument of function str2int() is an unbound charstring value.");
        int value_len = value.lengthof().get_int();
        if (value_len == 0) {
            throw new TtcnError("The argument of function str2int() is an empty string, which does not represent a valid integer value.");
        }
        StringBuilder value_str = new StringBuilder();
        value_str.append(value.get_value().toString());
        str2intState state = str2intState.S_INITIAL;
        boolean leading_ws = false;
        boolean leading_zero = false;
        for (int i = 0; i < value_len; ++i) {
            char c = value_str.charAt(i);
            switch (state) {
                case S_INITIAL: {
                    if (c == '+' || c == '-') {
                        state = str2intState.S_FIRST;
                        break;
                    }
                    if (c == '0') {
                        state = str2intState.S_ZERO;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = str2intState.S_MORE;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        leading_ws = true;
                        break;
                    }
                    state = str2intState.S_ERR;
                    break;
                }
                case S_FIRST: {
                    if (c == '0') {
                        state = str2intState.S_ZERO;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = str2intState.S_MORE;
                        break;
                    }
                    state = str2intState.S_ERR;
                    break;
                }
                case S_ZERO: {
                    if (c >= '0' && c <= '9') {
                        leading_zero = true;
                        state = str2intState.S_MORE;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        state = str2intState.S_END;
                        break;
                    }
                    state = str2intState.S_ERR;
                    break;
                }
                case S_MORE: {
                    if (c >= '0' && c <= '9') break;
                    if (Character.isWhitespace(c)) {
                        state = str2intState.S_END;
                        break;
                    }
                    state = str2intState.S_ERR;
                    break;
                }
                case S_END: {
                    if (Character.isWhitespace(c)) break;
                    state = str2intState.S_ERR;
                    break;
                }
            }
            if (state != str2intState.S_ERR) continue;
            TtcnError.TtcnErrorBegin("The argument of function str2int(), which is ");
            value.log();
            TTCN_Logger.log_event_str(", does not represent a valid integer value. Invalid character `");
            TTCN_Logger.log_char_escaped(c);
            TTCN_Logger.log_event("' was found at index %d.", i);
            TtcnError.TtcnErrorEnd();
        }
        if (state != str2intState.S_ZERO && state != str2intState.S_MORE && state != str2intState.S_END) {
            TtcnError.TtcnErrorBegin("The argument of function str2int(), which is ");
            value.log();
            TTCN_Logger.log_event_str(", does not represent a valid integer value. Premature end of the string.");
            TtcnError.TtcnErrorEnd();
        }
        if (leading_ws) {
            TtcnError.TtcnWarningBegin("Leading whitespace was detected in the argument of function str2int(): ");
            value.log();
            TTCN_Logger.log_event_str(".");
            TtcnError.TtcnWarningEnd();
        }
        if (leading_zero) {
            TtcnError.TtcnWarningBegin("Leading zero digit was detected in the argument of function str2int(): ");
            value.log();
            TTCN_Logger.log_event_str(".");
            TtcnError.TtcnWarningEnd();
        }
        if (state == str2intState.S_END) {
            TtcnError.TtcnWarningBegin("Trailing whitespace was detected in the argument of function str2int(): ");
            value.log();
            TTCN_Logger.log_event_str(".");
            TtcnError.TtcnWarningEnd();
        }
        return new TitanInteger(value_str.toString());
    }

    public static TitanInteger str2int(TitanCharString_Element value) {
        value.must_bound("The argument of function str2int() is an unbound charstring element.");
        char c = value.get_char();
        if (c < '0' || c > '9') {
            TtcnError.TtcnErrorBegin("The argument of function str2int(), which is a charstring element containing character `");
            TTCN_Logger.log_char_escaped(c);
            TTCN_Logger.log_event_str("', does not represent a valid integer value.");
            TtcnError.TtcnErrorEnd();
        }
        return new TitanInteger(c - 48);
    }

    public static TitanHexString str2hex(String value) {
        if (value == null) {
            return new TitanHexString();
        }
        return AdditionalFunctions.str2hex(new TitanCharString(value));
    }

    public static TitanHexString str2hex(TitanCharString value) {
        value.must_bound("The argument of function str2hex() is an unbound charstring value.");
        int value_length = value.lengthof().get_int();
        StringBuilder chars_ptr = new StringBuilder();
        chars_ptr.append(value.get_value().toString());
        byte[] ret_val = new byte[value_length];
        for (int i = 0; i < value_length; ++i) {
            char c = chars_ptr.charAt(i);
            byte hexdigit = AdditionalFunctions.char_to_hexdigit(c);
            if (hexdigit < 0) {
                TtcnError.TtcnErrorBegin("The argument of function str2hex() shall contain hexadecimal digits only, but character `");
                TTCN_Logger.log_char_escaped(c);
                TTCN_Logger.log_event_str(MessageFormat.format("'' was found at index {0}.", i));
                TtcnError.TtcnErrorEnd();
            }
            ret_val[i] = hexdigit;
        }
        return new TitanHexString(ret_val);
    }

    public static TitanHexString str2hex(TitanCharString_Element value) {
        value.must_bound("The argument of function str2hex() is an unbound charstring element.");
        char c = value.get_char();
        byte hexdigit = AdditionalFunctions.char_to_hexdigit(c);
        if (hexdigit < 0) {
            TtcnError.TtcnErrorBegin("The argument of function str2hex() shall contain only hexadecimal digits, but the given charstring element contains the character `");
            TTCN_Logger.log_char_escaped(c);
            TTCN_Logger.log_event_str("'.");
            TtcnError.TtcnErrorEnd();
        }
        return new TitanHexString(hexdigit);
    }

    public static TitanOctetString str2oct(String value) {
        if (value == null) {
            return new TitanOctetString();
        }
        return AdditionalFunctions.str2oct(new TitanCharString(value));
    }

    public static TitanOctetString str2oct(TitanCharString value) {
        value.must_bound("The argument of function str2oct() is an unbound charstring value.");
        int value_len = value.lengthof().get_int();
        if (value_len % 2 != 0) {
            throw new TtcnError(MessageFormat.format("The argument of function str2oct() must have even number of characters containing hexadecimal digits, but the length of the string is odd: {0}.", value_len));
        }
        byte[] octets_ptr = new byte[value_len / 2];
        StringBuilder chars_ptr = new StringBuilder();
        chars_ptr.append(value.get_value().toString());
        for (int i = 0; i < value_len; ++i) {
            char c = chars_ptr.charAt(i);
            byte hexdigit = AdditionalFunctions.char_to_hexdigit(c);
            if (hexdigit > 15) {
                TtcnError.TtcnErrorBegin("The argument of function str2oct() shall contain hexadecimal digits only, but character `");
                TTCN_Logger.log_char_escaped(c);
                TTCN_Logger.log_event_str(MessageFormat.format("' was found at index {0}.", i));
                TtcnError.TtcnErrorEnd();
            }
            octets_ptr[i / 2] = i % 2 != 0 ? (byte)(octets_ptr[i / 2] | hexdigit) : (byte)(hexdigit << 4);
        }
        return new TitanOctetString(octets_ptr);
    }

    public static TitanFloat str2float(String value) {
        return AdditionalFunctions.str2float(new TitanCharString(value));
    }

    public static TitanFloat str2float(TitanCharString value) {
        value.must_bound("The argument of function str2float() is an unbound charstring value.");
        int value_len = value.lengthof().get_int();
        if (value_len == 0) {
            throw new TtcnError("The argument of function str2float() is an empty string, which does not represent a valid float value.");
        }
        if (value.operator_equals("infinity")) {
            return new TitanFloat(Double.POSITIVE_INFINITY);
        }
        if (value.operator_equals("-infinity")) {
            return new TitanFloat(Double.NEGATIVE_INFINITY);
        }
        if (value.operator_equals("not_a_number")) {
            return new TitanFloat(Double.NaN);
        }
        StringBuilder value_str = value.get_value();
        str2floatState state = str2floatState.S_INITIAL;
        boolean leading_ws = false;
        boolean leading_zero = false;
        for (int i = 0; i < value_len; ++i) {
            char c = value_str.charAt(i);
            switch (state) {
                case S_INITIAL: {
                    if (c == '+' || c == '-') {
                        state = str2floatState.S_FIRST_M;
                        break;
                    }
                    if (c == '0') {
                        state = str2floatState.S_ZERO_M;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = str2floatState.S_MORE_M;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        leading_ws = true;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_FIRST_M: {
                    if (c == '0') {
                        state = str2floatState.S_ZERO_M;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = str2floatState.S_MORE_M;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_ZERO_M: {
                    if (c == '.') {
                        state = str2floatState.S_FIRST_F;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        state = str2floatState.S_INITIAL_E;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        leading_zero = true;
                        state = str2floatState.S_MORE_M;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_MORE_M: {
                    if (c == '.') {
                        state = str2floatState.S_FIRST_F;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        state = str2floatState.S_INITIAL_E;
                        break;
                    }
                    if (c >= '0' && c <= '9') break;
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_FIRST_F: {
                    if (c >= '0' && c <= '9') {
                        state = str2floatState.S_MORE_F;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_MORE_F: {
                    if (c == 'E' || c == 'e') {
                        state = str2floatState.S_INITIAL_E;
                        break;
                    }
                    if (c >= '0' && c <= '9') break;
                    if (Character.isWhitespace(c)) {
                        state = str2floatState.S_END;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_INITIAL_E: {
                    if (c == '+' || c == '-') {
                        state = str2floatState.S_FIRST_E;
                        break;
                    }
                    if (c == '0') {
                        state = str2floatState.S_ZERO_E;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = str2floatState.S_MORE_E;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_FIRST_E: {
                    if (c == '0') {
                        state = str2floatState.S_ZERO_E;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        state = str2floatState.S_MORE_E;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_ZERO_E: {
                    if (c >= '0' && c <= '9') {
                        leading_zero = true;
                        state = str2floatState.S_MORE_E;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        state = str2floatState.S_END;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_MORE_E: {
                    if (c >= '0' && c <= '9') break;
                    if (Character.isWhitespace(c)) {
                        state = str2floatState.S_END;
                        break;
                    }
                    state = str2floatState.S_ERR;
                    break;
                }
                case S_END: {
                    if (!Character.isWhitespace(c)) break;
                    state = str2floatState.S_ERR;
                    break;
                }
            }
            if (state != str2floatState.S_ERR) continue;
            TtcnError.TtcnErrorBegin("The argument of function str2float() which is ");
            value.log();
            TTCN_Logger.log_event_str("' , does not represent a valid float value. Invalid character ");
            TTCN_Logger.log_char_escaped(c);
            TTCN_Logger.log_event_str(MessageFormat.format("' was found at index {0}.", i));
            TtcnError.TtcnErrorEnd();
        }
        switch (state) {
            case S_MORE_F: 
            case S_ZERO_E: 
            case S_MORE_E: {
                break;
            }
            case S_ZERO_M: 
            case S_MORE_M: {
                break;
            }
            case S_FIRST_F: {
                break;
            }
            default: {
                TtcnError.TtcnErrorBegin("The argument of function str2float() which is ");
                value.log();
                TTCN_Logger.log_event_str("' , does not represent a valid float value. Premature end of the string.");
                TtcnError.TtcnErrorEnd();
            }
        }
        if (leading_ws) {
            TtcnError.TtcnWarningBegin("Leading whitespace was detected in the argument of function str2float(): ");
            value.log();
            TTCN_Logger.log_char('.');
            TtcnError.TtcnWarningEnd();
        }
        if (leading_zero) {
            TtcnError.TtcnWarningBegin("Leading zero digit was detected in the argument of function str2float(): ");
            value.log();
            TTCN_Logger.log_char('.');
            TtcnError.TtcnWarningEnd();
        }
        if (state == str2floatState.S_END) {
            TtcnError.TtcnWarningBegin("Trailing whitespace was detected in the argument of function str2float(): ");
            value.log();
            TTCN_Logger.log_char('.');
            TtcnError.TtcnWarningEnd();
        }
        return new TitanFloat(Double.valueOf(value_str.toString()));
    }

    public static TitanUniversalCharString oct2unichar(TitanOctetString value) {
        TitanUniversalCharString unicharStr = new TitanUniversalCharString();
        TTCN_EncDec.error_behavior_type err_behavior = TTCN_EncDec.get_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR);
        TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR, TTCN_EncDec.error_behavior_type.EB_ERROR);
        unicharStr.decode_utf8(value.get_value(), TitanCharString.CharCoding.UTF_8, true);
        TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR, err_behavior);
        return unicharStr;
    }

    public static TitanUniversalCharString oct2unichar(TitanOctetString value, TitanCharString encodeStr) {
        TitanUniversalCharString unicharStr = new TitanUniversalCharString();
        TTCN_EncDec.error_behavior_type err_behavior = TTCN_EncDec.get_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR);
        TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR, TTCN_EncDec.error_behavior_type.EB_ERROR);
        if (encodeStr.operator_equals("UTF-8")) {
            unicharStr.decode_utf8(value.get_value(), TitanCharString.CharCoding.UTF_8, true);
        } else if (encodeStr.operator_equals("UTF-16")) {
            unicharStr.decode_utf16(value.lengthof().get_int(), value.get_value(), TitanCharString.CharCoding.UTF16);
        } else if (encodeStr.operator_equals("UTF-16BE")) {
            unicharStr.decode_utf16(value.lengthof().get_int(), value.get_value(), TitanCharString.CharCoding.UTF16BE);
        } else if (encodeStr.operator_equals("UTF-16LE")) {
            unicharStr.decode_utf16(value.lengthof().get_int(), value.get_value(), TitanCharString.CharCoding.UTF16LE);
        } else if (encodeStr.operator_equals("UTF-32")) {
            unicharStr.decode_utf32(value.lengthof().get_int(), value.get_value(), TitanCharString.CharCoding.UTF32);
        } else if (encodeStr.operator_equals("UTF-32BE")) {
            unicharStr.decode_utf32(value.lengthof().get_int(), value.get_value(), TitanCharString.CharCoding.UTF32BE);
        } else if (encodeStr.operator_equals("UTF-32LE")) {
            unicharStr.decode_utf32(value.lengthof().get_int(), value.get_value(), TitanCharString.CharCoding.UTF32LE);
        } else {
            throw new TtcnError("oct2unichar: Invalid parameter: " + encodeStr);
        }
        TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR, err_behavior);
        return unicharStr;
    }

    public static TitanUniversalCharString oct2unichar(TitanOctetString value, String encodeStr) {
        return AdditionalFunctions.oct2unichar(value, new TitanCharString(encodeStr));
    }

    public static TitanOctetString unichar2oct(TitanUniversalCharString value) {
        value.must_bound("The argument of function unichar2oct() is an unbound universal charstring value.");
        TTCN_EncDec.error_behavior_type err_behavior = TTCN_EncDec.get_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR);
        TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR, TTCN_EncDec.error_behavior_type.EB_ERROR);
        TTCN_Buffer buf = new TTCN_Buffer();
        value.encode_utf8(buf, false);
        TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR, err_behavior);
        return new TitanOctetString(buf.get_data());
    }

    public static TitanOctetString unichar2oct(TitanUniversalCharString value, TitanCharString stringEncoding) {
        value.must_bound("The argument of function unichar2oct() is an unbound universal charstring value.");
        TTCN_EncDec.error_behavior_type err_behavior = TTCN_EncDec.get_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR);
        TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR, TTCN_EncDec.error_behavior_type.EB_ERROR);
        TTCN_Buffer buf = new TTCN_Buffer();
        if (stringEncoding.operator_equals("UTF-8")) {
            value.encode_utf8(buf, false);
        } else if (stringEncoding.operator_equals("UTF-8 BOM")) {
            value.encode_utf8(buf, true);
        } else if (stringEncoding.operator_equals("UTF-16")) {
            value.encode_utf16(buf, TitanCharString.CharCoding.UTF16);
        } else if (stringEncoding.operator_equals("UTF-16BE")) {
            value.encode_utf16(buf, TitanCharString.CharCoding.UTF16BE);
        } else if (stringEncoding.operator_equals("UTF-16LE")) {
            value.encode_utf16(buf, TitanCharString.CharCoding.UTF16LE);
        } else if (stringEncoding.operator_equals("UTF-32")) {
            value.encode_utf32(buf, TitanCharString.CharCoding.UTF32);
        } else if (stringEncoding.operator_equals("UTF-32BE")) {
            value.encode_utf32(buf, TitanCharString.CharCoding.UTF32BE);
        } else if (stringEncoding.operator_equals("UTF-32LE")) {
            value.encode_utf32(buf, TitanCharString.CharCoding.UTF32LE);
        } else {
            throw new TtcnError("unichar2oct: Invalid parameter: " + stringEncoding);
        }
        TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_DEC_UCSTR, err_behavior);
        return new TitanOctetString(buf.get_data());
    }

    public static TitanOctetString unichar2oct(TitanUniversalCharString value, String stringEncoding) {
        return AdditionalFunctions.unichar2oct(value, new TitanCharString(stringEncoding));
    }

    public static void check_substr_arguments(int value_length, int idx, int returncount, String string_type, String element_name) {
        if (idx < 0) {
            throw new TtcnError(MessageFormat.format("The second argument (index) of function substr() is a negative integer value: {0}.", idx));
        }
        if (idx > value_length) {
            throw new TtcnError(MessageFormat.format("The second argument (index) of function substr(), which is {0} , is greater than the length of the {1} value: {2}.", idx, string_type, value_length));
        }
        if (returncount < 0) {
            throw new TtcnError(MessageFormat.format("The third argument (returncount) of function substr() is a negative integer value: {0}.", returncount));
        }
        if (idx + returncount > value_length) {
            throw new TtcnError(MessageFormat.format("The first argument of function substr(), the length of which is {0}, does not have enough {1}s starting at index {2}: {3} {4}{5} needed, but there {6} only {7}.", value_length, element_name, idx, returncount, element_name, returncount > 1 ? "s are" : " is", value_length - idx > 1 ? "are" : "is", value_length - idx));
        }
    }

    public static void check_substr_arguments(int idx, int returncount, String string_type, String element_name) {
        if (idx < 0) {
            throw new TtcnError(MessageFormat.format("The second argument (index) of function substr() is a negative integer value: {0}.", idx));
        }
        if (idx > 1) {
            throw new TtcnError(MessageFormat.format("The second argument (index) of function substr(), which is {0}, is greater than 1 (i.e. the length of the {1} element).", idx, string_type));
        }
        if (returncount < 0) {
            throw new TtcnError(MessageFormat.format("The third argument (returncount) of function substr() is a negative integer value: {0}.", returncount));
        }
        if (idx + returncount > 1) {
            throw new TtcnError(MessageFormat.format("The first argument of function substr(), which is a{0} {1} element, does not have enough {2}s starting at index {3}: {4} {5}{6} needed, but there is only {7}.", string_type.charAt(0) == 'o' ? "n" : "", string_type, element_name, idx, returncount, element_name, returncount > 1 ? "s are" : " is", 1 - idx));
        }
    }

    public static TitanBitString substr(TitanBitString value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound bitstring value.");
        AdditionalFunctions.check_substr_arguments(value.lengthof().get_int(), idx, returncount, "bitstring", "bit");
        if (idx % 8 != 0) {
            StringBuilder sb = new StringBuilder(returncount);
            for (int i = 0; i < returncount; ++i) {
                sb.append(value.get_bit(idx + i) ? (char)'1' : '0');
            }
            return new TitanBitString(sb.toString());
        }
        int[] bits_ptr = value.get_value();
        int[] ret_val = new int[(returncount + 7) / 8];
        System.arraycopy(bits_ptr, idx / 8, ret_val, 0, (returncount + 7) / 8);
        return new TitanBitString(ret_val, returncount);
    }

    public static TitanBitString substr(TitanBitString value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanBitString substr(TitanBitString value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanBitString substr(TitanBitString value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanBitString substr(TitanBitString_Element value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound bitstring element.");
        AdditionalFunctions.check_substr_arguments(idx, returncount, "bitstring", "bit");
        if (returncount == 0) {
            return new TitanBitString();
        }
        return new TitanBitString(value.get_bit() ? "1" : "0");
    }

    public static TitanBitString substr(TitanBitString_Element value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanBitString substr(TitanBitString_Element value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanBitString substr(TitanBitString_Element value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanHexString substr(TitanHexString value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound hexstring value.");
        AdditionalFunctions.check_substr_arguments(value.lengthof().get_int(), idx, returncount, "hexstring", "hexadecimal digi");
        byte[] src_ptr = value.get_value();
        byte[] ret_val = new byte[returncount];
        System.arraycopy(src_ptr, idx, ret_val, 0, returncount);
        return new TitanHexString(ret_val);
    }

    public static TitanHexString substr(TitanHexString value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanHexString substr(TitanHexString value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanHexString substr(TitanHexString value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanHexString substr(TitanHexString_Element value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound hexstring element.");
        AdditionalFunctions.check_substr_arguments(idx, returncount, "hexstring", "hexadecimal digit");
        if (returncount == 0) {
            return new TitanHexString();
        }
        return new TitanHexString(String.valueOf(value.get_nibble()));
    }

    public static TitanHexString substr(TitanHexString_Element value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanHexString substr(TitanHexString_Element value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanHexString substr(TitanHexString_Element value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanOctetString substr(TitanOctetString value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound octetstring value.");
        AdditionalFunctions.check_substr_arguments(value.lengthof().get_int(), idx, returncount, "octetstring", "octet");
        byte[] ret_val = new byte[returncount];
        byte[] src_ptr = value.get_value();
        System.arraycopy(src_ptr, idx, ret_val, 0, returncount);
        return new TitanOctetString(ret_val);
    }

    public static TitanOctetString substr(TitanOctetString value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanOctetString substr(TitanOctetString value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanOctetString substr(TitanOctetString value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanOctetString substr(TitanOctetString_Element value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound octetstring element.");
        AdditionalFunctions.check_substr_arguments(idx, returncount, "octetstring", "octet");
        if (returncount == 0) {
            return new TitanOctetString();
        }
        return new TitanOctetString(value.get_nibble());
    }

    public static TitanOctetString substr(TitanOctetString_Element value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanOctetString substr(TitanOctetString_Element value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanOctetString substr(TitanOctetString_Element value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanCharString substr(TitanCharString value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound charstring value.");
        AdditionalFunctions.check_substr_arguments(value.lengthof().get_int(), idx, returncount, "charstring", "character");
        return new TitanCharString(value.get_value().substring(idx, idx + returncount));
    }

    public static TitanCharString substr(TitanCharString value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanCharString substr(TitanCharString value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanCharString substr(TitanCharString value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanCharString substr(TitanCharString_Element value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound charstring element.");
        AdditionalFunctions.check_substr_arguments(idx, returncount, "charstring", "character");
        return new TitanCharString(String.valueOf(value.get_char()));
    }

    public static TitanCharString substr(TitanCharString_Element value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanCharString substr(TitanCharString_Element value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanCharString substr(TitanCharString_Element value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound universal charstring value.");
        AdditionalFunctions.check_substr_arguments(value.lengthof().get_int(), idx, returncount, "universal charstring", "character");
        if (value.charstring) {
            return new TitanUniversalCharString(value.cstr.substring(idx, idx + returncount));
        }
        ArrayList<TitanUniversalChar> ret_val = new ArrayList<TitanUniversalChar>(returncount);
        List<TitanUniversalChar> src_ptr = value.get_value();
        for (int i = 0; i < returncount; ++i) {
            ret_val.add(src_ptr.get(i + idx));
        }
        return new TitanUniversalCharString(ret_val);
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString_Element value, int idx, int returncount) {
        value.must_bound("The first argument (value) of function substr() is an unbound universal charstring element.");
        AdditionalFunctions.check_substr_arguments(idx, returncount, "universal charstring", "character");
        if (returncount == 0) {
            return new TitanUniversalCharString();
        }
        return new TitanUniversalCharString(value.get_char());
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString_Element value, int idx, TitanInteger returncount) {
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx, returncount.get_int());
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString_Element value, TitanInteger idx, int returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount);
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString_Element value, TitanInteger idx, TitanInteger returncount) {
        idx.must_bound("The second argument (index) of function substr() is an unbound integer value.");
        returncount.must_bound("The third argument (returncount) of function substr() is an unbound integer value.");
        return AdditionalFunctions.substr(value, idx.get_int(), returncount.get_int());
    }

    public static TitanBitString substr(TitanBitString_template value, int idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanBitString substr(TitanBitString_template value, int idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanBitString substr(TitanBitString_template value, TitanInteger idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanBitString substr(TitanBitString_template value, TitanInteger idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanHexString substr(TitanHexString_template value, int idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanHexString substr(TitanHexString_template value, int idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanHexString substr(TitanHexString_template value, TitanInteger idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanHexString substr(TitanHexString_template value, TitanInteger idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanOctetString substr(TitanOctetString_template value, int idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanOctetString substr(TitanOctetString_template value, int idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanOctetString substr(TitanOctetString_template value, TitanInteger idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanOctetString substr(TitanOctetString_template value, TitanInteger idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanCharString substr(TitanCharString_template value, int idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanCharString substr(TitanCharString_template value, int idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanCharString substr(TitanCharString_template value, TitanInteger idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanCharString substr(TitanCharString_template value, TitanInteger idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString_template value, int idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString_template value, int idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString_template value, TitanInteger idx, int returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static TitanUniversalCharString substr(TitanUniversalCharString_template value, TitanInteger idx, TitanInteger returncount) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function substr() is a template with non-specific value.");
        }
        return AdditionalFunctions.substr(value.valueof(), idx, returncount);
    }

    public static void check_replace_arguments(int value_length, int idx, int len, String string_type, String element_name) {
        if (idx < 0) {
            throw new TtcnError(MessageFormat.format("The second argument (index) of function replace() is a negative integer value: {0}.", idx));
        }
        if (idx > value_length) {
            throw new TtcnError(MessageFormat.format("The second argument (index) of function replace(), which is {0}, is greater than the length of the {1} value: {2}.", idx, string_type, value_length));
        }
        if (len < 0) {
            throw new TtcnError(MessageFormat.format("The third argument (len) of function replace() is a negative integer value: {0}.", len));
        }
        if (len > value_length) {
            throw new TtcnError(MessageFormat.format("The third argument (len) of function replace(), which is {0}, is greater than the length of the {1} value: {2}.", len, string_type, value_length));
        }
        if (idx + len > value_length) {
            throw new TtcnError(MessageFormat.format("The first argument of function replace(), the length of which is {0}, does not have enough {1}s starting at index {2}: {3} {4}{5} needed, but there {6} only {7}.", value_length, element_name, idx, len, element_name, len > 1 ? "s are" : " is", value_length - idx > 1 ? "are" : "is", value_length - idx));
        }
    }

    public static TitanBitString replace(TitanBitString value, int idx, int len, TitanBitString repl) {
        int i;
        value.must_bound("The first argument (value) of function replace() is an unbound bitstring value.");
        repl.must_bound("The fourth argument (repl) of function replace() is an unbound bitstring value.");
        int value_len = value.lengthof().get_int();
        AdditionalFunctions.check_replace_arguments(value_len, idx, len, "bitstring", "bit");
        int repl_len = repl.lengthof().get_int();
        StringBuilder temp_sb = new StringBuilder(value_len);
        for (i = 0; i < idx; ++i) {
            temp_sb.append(value.get_bit(i) ? (char)'1' : '0');
        }
        for (i = 0; i < repl_len; ++i) {
            temp_sb.append(repl.get_bit(i) ? (char)'1' : '0');
        }
        for (i = 0; i < value_len - idx - len; ++i) {
            temp_sb.append(value.get_bit(idx + len + i) ? (char)'1' : '0');
        }
        return new TitanBitString(temp_sb.toString());
    }

    public static TitanBitString replace(TitanBitString value, int idx, TitanInteger len, TitanBitString repl) {
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx, len.get_int(), repl);
    }

    public static TitanBitString replace(TitanBitString value, TitanInteger idx, int len, TitanBitString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len, repl);
    }

    public static TitanBitString replace(TitanBitString value, TitanInteger idx, TitanInteger len, TitanBitString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len.get_int(), repl);
    }

    public static TitanHexString replace(TitanHexString value, int idx, int len, TitanHexString repl) {
        value.must_bound("The first argument (value) of function replace() is an unbound hexstring value.");
        repl.must_bound("The fourth argument (repl) of function replace() is an unbound hexstring value.");
        int value_len = value.lengthof().get_int();
        AdditionalFunctions.check_replace_arguments(value_len, idx, len, "hexstring", "hexadecimal digit");
        int repl_len = repl.lengthof().get_int();
        byte[] src_ptr = value.get_value();
        byte[] repl_ptr = repl.get_value();
        byte[] ret_val = new byte[value_len + repl_len - len];
        System.arraycopy(src_ptr, 0, ret_val, 0, idx);
        System.arraycopy(repl_ptr, 0, ret_val, idx, repl_len);
        System.arraycopy(src_ptr, idx + len, ret_val, idx + repl_len, value_len - idx - len);
        return new TitanHexString(ret_val);
    }

    public static TitanHexString replace(TitanHexString value, int idx, TitanInteger len, TitanHexString repl) {
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx, len.get_int(), repl);
    }

    public static TitanHexString replace(TitanHexString value, TitanInteger idx, int len, TitanHexString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len, repl);
    }

    public static TitanHexString replace(TitanHexString value, TitanInteger idx, TitanInteger len, TitanHexString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len.get_int(), repl);
    }

    public static TitanOctetString replace(TitanOctetString value, int idx, int len, TitanOctetString repl) {
        value.must_bound("The first argument (value) of function replace() is an unbound octetstring value.");
        repl.must_bound("The fourth argument (repl) of function replace() is an unbound octetstring value.");
        int value_len = value.lengthof().get_int();
        AdditionalFunctions.check_replace_arguments(value_len, idx, len, "octetstring", "octet");
        int repl_len = repl.lengthof().get_int();
        byte[] src_ptr = value.get_value();
        byte[] repl_ptr = repl.get_value();
        byte[] ret_val = new byte[value_len + repl_len - len];
        System.arraycopy(src_ptr, 0, ret_val, 0, idx);
        System.arraycopy(repl_ptr, 0, ret_val, idx, repl_len);
        System.arraycopy(src_ptr, idx + len, ret_val, idx + repl_len, value_len - idx - len);
        return new TitanOctetString(ret_val);
    }

    public static TitanOctetString replace(TitanOctetString value, int idx, TitanInteger len, TitanOctetString repl) {
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx, len.get_int(), repl);
    }

    public static TitanOctetString replace(TitanOctetString value, TitanInteger idx, int len, TitanOctetString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len, repl);
    }

    public static TitanOctetString replace(TitanOctetString value, TitanInteger idx, TitanInteger len, TitanOctetString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len.get_int(), repl);
    }

    public static TitanCharString replace(TitanCharString value, int idx, int len, TitanCharString repl) {
        value.must_bound("The first argument (value) of function replace() is an unbound charstring value.");
        repl.must_bound("The fourth argument (repl) of function replace() is an unbound charstring value.");
        int value_len = value.lengthof().get_int();
        AdditionalFunctions.check_replace_arguments(value_len, idx, len, "charstring", "character");
        StringBuilder ret_val = new StringBuilder();
        ret_val.append((CharSequence)value.get_value());
        ret_val.replace(idx, idx + len, repl.get_value().toString());
        return new TitanCharString(ret_val);
    }

    public static TitanCharString replace(TitanCharString value, int idx, TitanInteger len, TitanCharString repl) {
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx, len.get_int(), repl);
    }

    public static TitanCharString replace(TitanCharString value, TitanInteger idx, int len, TitanCharString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len, repl);
    }

    public static TitanCharString replace(TitanCharString value, TitanInteger idx, TitanInteger len, TitanCharString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len.get_int(), repl);
    }

    public static TitanUniversalCharString replace(TitanUniversalCharString value, int idx, int len, TitanUniversalCharString repl) {
        int i;
        value.must_bound("The first argument (value) of function replace() is an unbound universal charstring value.");
        repl.must_bound("The fourth argument (repl) of function replace() is an unbound universal charstring value.");
        int value_len = value.lengthof().get_int();
        AdditionalFunctions.check_replace_arguments(value_len, idx, len, "universal charstring", "character");
        int repl_len = repl.lengthof().get_int();
        if (value.charstring) {
            int i2;
            if (repl.charstring) {
                StringBuilder ret_val = new StringBuilder();
                ret_val.append(value.cstr.toString());
                ret_val.replace(idx, idx + len, repl.cstr.toString());
                return new TitanUniversalCharString(ret_val);
            }
            int newSize = repl_len + value_len - len;
            ArrayList<TitanUniversalChar> ret_val = new ArrayList<TitanUniversalChar>(newSize);
            for (i2 = 0; i2 < idx; ++i2) {
                ret_val.add(i2, new TitanUniversalChar('\u0000', '\u0000', '\u0000', value.cstr.charAt(i2)));
            }
            for (i2 = 0; i2 < repl_len; ++i2) {
                ret_val.add(idx + i2, repl.val_ptr.get(i2));
            }
            for (i2 = 0; i2 < value_len - idx - len; ++i2) {
                ret_val.add(idx + i2 + repl_len, new TitanUniversalChar('\u0000', '\u0000', '\u0000', value.cstr.charAt(idx + i2 + len)));
            }
            return new TitanUniversalCharString(ret_val);
        }
        if (repl.charstring) {
            int i3;
            int newSize = repl_len + value_len - len;
            ArrayList<TitanUniversalChar> ret_val = new ArrayList<TitanUniversalChar>(newSize);
            for (i3 = 0; i3 < idx; ++i3) {
                ret_val.add(idx + i3, value.val_ptr.get(i3));
            }
            for (i3 = 0; i3 < repl_len; ++i3) {
                ret_val.add(i3, new TitanUniversalChar('\u0000', '\u0000', '\u0000', repl.cstr.charAt(i3)));
            }
            for (i3 = 0; i3 < value_len - idx - len; ++i3) {
                ret_val.add(idx + i3 + repl_len, value.val_ptr.get(idx + i3 + len));
            }
            return new TitanUniversalCharString(ret_val);
        }
        int newSize = repl_len + value_len - len;
        ArrayList<TitanUniversalChar> ret_val = new ArrayList<TitanUniversalChar>(newSize);
        for (i = 0; i < idx; ++i) {
            ret_val.add(i, value.val_ptr.get(i));
        }
        for (i = 0; i < repl_len; ++i) {
            ret_val.add(idx + i, repl.val_ptr.get(i));
        }
        for (i = 0; i < value_len - idx - len; ++i) {
            ret_val.add(idx + i + repl_len, value.val_ptr.get(idx + i + len));
        }
        return new TitanUniversalCharString(ret_val);
    }

    public static TitanUniversalCharString replace(TitanUniversalCharString value, int idx, TitanInteger len, TitanUniversalCharString repl) {
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx, len.get_int(), repl);
    }

    public static TitanUniversalCharString replace(TitanUniversalCharString value, TitanInteger idx, int len, TitanUniversalCharString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len, repl);
    }

    public static TitanUniversalCharString replace(TitanUniversalCharString value, TitanInteger idx, TitanInteger len, TitanUniversalCharString repl) {
        idx.must_bound("The second argument (index) of function replace() is an unbound integer value.");
        len.must_bound("The third argument (len) of function replace() is an unbound integer value.");
        return AdditionalFunctions.replace(value, idx.get_int(), len.get_int(), repl);
    }

    public static TitanBitString replace(TitanBitString_template value, int idx, int len, TitanBitString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanBitString replace(TitanBitString_template value, int idx, TitanInteger len, TitanBitString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanBitString replace(TitanBitString_template value, TitanInteger idx, int len, TitanBitString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanBitString replace(TitanBitString_template value, TitanInteger idx, TitanInteger len, TitanBitString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanHexString replace(TitanHexString_template value, int idx, int len, TitanHexString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanHexString replace(TitanHexString_template value, int idx, TitanInteger len, TitanHexString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanHexString replace(TitanHexString_template value, TitanInteger idx, int len, TitanHexString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanHexString replace(TitanHexString_template value, TitanInteger idx, TitanInteger len, TitanHexString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanOctetString replace(TitanOctetString_template value, int idx, int len, TitanOctetString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanOctetString replace(TitanOctetString_template value, int idx, TitanInteger len, TitanOctetString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanOctetString replace(TitanOctetString_template value, TitanInteger idx, int len, TitanOctetString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanOctetString replace(TitanOctetString_template value, TitanInteger idx, TitanInteger len, TitanOctetString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanCharString replace(TitanCharString_template value, int idx, int len, TitanCharString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanCharString replace(TitanCharString_template value, int idx, TitanInteger len, TitanCharString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanCharString replace(TitanCharString_template value, TitanInteger idx, int len, TitanCharString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanCharString replace(TitanCharString_template value, TitanInteger idx, TitanInteger len, TitanCharString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanUniversalCharString replace(TitanUniversalCharString_template value, int idx, int len, TitanUniversalCharString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanUniversalCharString replace(TitanUniversalCharString_template value, int idx, TitanInteger len, TitanUniversalCharString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanUniversalCharString replace(TitanUniversalCharString_template value, TitanInteger idx, int len, TitanUniversalCharString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanUniversalCharString replace(TitanUniversalCharString_template value, TitanInteger idx, TitanInteger len, TitanUniversalCharString_template repl) {
        if (!value.is_value()) {
            throw new TtcnError("The first argument of function replace() is a template with non-specific value.");
        }
        if (!repl.is_value()) {
            throw new TtcnError("The fourth argument of function replace() is a template with non-specific value.");
        }
        return AdditionalFunctions.replace(value.valueof(), idx, len, repl.valueof());
    }

    public static TitanCharString get_stringencoding(TitanOctetString encoded_value) {
        if (encoded_value.lengthof().operator_equals(0)) {
            return new TitanCharString("<unknown>");
        }
        int i = 0;
        byte[] strptr = encoded_value.get_value();
        int length = strptr.length;
        if (length >= 2) {
            switch (strptr[0] & 0xFF) {
                case 239: {
                    for (i = 1; i < UTF8_BOM.length && i < strptr.length && UTF8_BOM[i] == (strptr[i] & 0xFF); ++i) {
                    }
                    if (i != UTF8_BOM.length || UTF8_BOM.length > length) break;
                    return new TitanCharString("UTF-8");
                }
                case 254: {
                    for (i = 1; i < UTF16BE_BOM.length && i < strptr.length && UTF16BE_BOM[i] == (strptr[i] & 0xFF); ++i) {
                    }
                    if (i != UTF16BE_BOM.length || UTF16BE_BOM.length > length) break;
                    return new TitanCharString("UTF-16BE");
                }
                case 255: {
                    for (i = 1; i < UTF32LE_BOM.length && i < strptr.length && UTF32LE_BOM[i] == (strptr[i] & 0xFF); ++i) {
                    }
                    if (i == UTF32LE_BOM.length && UTF32LE_BOM.length <= length) {
                        return new TitanCharString("UTF-32LE");
                    }
                    for (i = 1; i < UTF16LE_BOM.length && i < strptr.length && UTF16LE_BOM[i] == (strptr[i] & 0xFF); ++i) {
                    }
                    if (i != UTF16LE_BOM.length || UTF16LE_BOM.length > length) break;
                    return new TitanCharString("UTF-16LE");
                }
                case 0: {
                    for (i = 1; i < UTF32BE_BOM.length && i < strptr.length && UTF32BE_BOM[i] == (strptr[i] & 0xFF); ++i) {
                    }
                    if (i != UTF32BE_BOM.length || UTF32BE_BOM.length > length) break;
                    return new TitanCharString("UTF-32BE");
                }
            }
        }
        if (AdditionalFunctions.is_ascii(encoded_value) == TitanCharString.CharCoding.ASCII) {
            return new TitanCharString("ASCII");
        }
        if (AdditionalFunctions.is_utf8(encoded_value) == TitanCharString.CharCoding.UTF_8) {
            return new TitanCharString("UTF-8");
        }
        return new TitanCharString("<unknown>");
    }

    public static TitanOctetString remove_bom(TitanOctetString encoded_value) {
        byte[] str = encoded_value.get_value();
        int length_of_BOM = 0;
        if (0 == (str[0] & 0xFF) && 0 == (str[1] & 0xFF) && 254 == (str[2] & 0xFF) && 255 == (str[3] & 0xFF)) {
            length_of_BOM = 4;
        } else if (255 == (str[0] & 0xFF) && 254 == (str[1] & 0xFF) && 0 == (str[2] & 0xFF) && 0 == (str[3] & 0xFF)) {
            length_of_BOM = 4;
        } else if (254 == (str[0] & 0xFF) && 255 == (str[1] & 0xFF)) {
            length_of_BOM = 2;
        } else if (255 == (str[0] & 0xFF) && 254 == (str[1] & 0xFF)) {
            length_of_BOM = 2;
        } else if (239 == (str[0] & 0xFF) && 187 == (str[1] & 0xFF) && 191 == (str[2] & 0xFF)) {
            length_of_BOM = 3;
        } else {
            return new TitanOctetString(encoded_value);
        }
        byte[] tmp_str = new byte[str.length - length_of_BOM];
        System.arraycopy(str, length_of_BOM, tmp_str, 0, str.length - length_of_BOM);
        return new TitanOctetString(tmp_str);
    }

    public static void set_rnd_seed(double floatSeed) {
        TitanFloat.check_numeric(floatSeed, "The seed value of function rnd()");
        random.setSeed((long)floatSeed);
        TTCN_Logger.log_random(TitanLoggerApi.RandomAction.enum_type.seed, floatSeed, (long)floatSeed);
        rndSeedSet = true;
    }

    public static TitanFloat rnd_generate() {
        double returnValue = random.nextDouble();
        TTCN_Logger.log_random(TitanLoggerApi.RandomAction.enum_type.read__out, returnValue, 0L);
        return new TitanFloat(returnValue);
    }

    public static TitanFloat rnd() {
        if (!rndSeedSet) {
            AdditionalFunctions.set_rnd_seed(TTCN_Snapshot.time_now());
        }
        return AdditionalFunctions.rnd_generate();
    }

    public static TitanFloat rnd(double seed) {
        AdditionalFunctions.set_rnd_seed(seed);
        return AdditionalFunctions.rnd_generate();
    }

    public static TitanFloat rnd(TitanFloat seed) {
        seed.must_bound("Initializing the random number generator with an unbound float value as seed.");
        AdditionalFunctions.set_rnd_seed(seed.get_value());
        return AdditionalFunctions.rnd_generate();
    }

    public static TitanBitString str2bit(String value) {
        if (value == null) {
            return new TitanBitString();
        }
        return AdditionalFunctions.str2bit(new TitanCharString(value));
    }

    public static TitanBitString str2bit(TitanCharString value) {
        value.must_bound("The argument of function str2bit() is an unbound charstring value.");
        int value_length = value.lengthof().get_int();
        StringBuilder chars_ptr = new StringBuilder();
        chars_ptr.append(value.get_value().toString());
        StringBuilder ret_val = new StringBuilder();
        block4: for (int i = 0; i < value_length; ++i) {
            char c = chars_ptr.charAt(i);
            switch (c) {
                case '0': {
                    ret_val.append('0');
                    continue block4;
                }
                case '1': {
                    ret_val.append('1');
                    continue block4;
                }
                default: {
                    TtcnError.TtcnErrorBegin("The argument of function str2bit() shall contain characters '0' and '1' only, but character `");
                    TTCN_Logger.log_char_escaped(c);
                    TTCN_Logger.log_event_str(MessageFormat.format("'' was found at index {0}.", i));
                    TtcnError.TtcnErrorEnd();
                }
            }
        }
        return new TitanBitString(ret_val.toString());
    }

    public static TitanBitString str2bit(TitanCharString_Element value) {
        value.must_bound("The argument of function str2bit() is an unbound charstring element.");
        char c = value.get_char();
        if (c != '0' && c != '1') {
            TtcnError.TtcnErrorBegin("The argument of function str2bit() shall contain characters '0' and '1' only, but the given charstring element contains the character `");
            TTCN_Logger.log_char_escaped(c);
            TTCN_Logger.log_event_str("'.");
            TtcnError.TtcnErrorEnd();
        }
        return new TitanBitString(value.get_char() == '1' ? "1" : "0");
    }

    public static TitanCharString float2str(double value) {
        if (Double.isNaN(value)) {
            return new TitanCharString("not_a_number");
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return new TitanCharString("-infinity");
        }
        if (value == Double.POSITIVE_INFINITY) {
            return new TitanCharString("infinity");
        }
        if (value == 0.0 || value > -1.0E10 && value <= -1.0E-4 || value >= 1.0E-4 && value < 1.0E10) {
            return new TitanCharString(String.format(Locale.US, "%f", value));
        }
        return new TitanCharString(String.format(Locale.US, "%e", value));
    }

    public static TitanCharString float2str(Ttcn3Float value) {
        if (Double.isNaN(value.getValue())) {
            return new TitanCharString("not_a_number");
        }
        if (value.getValue() == Double.NEGATIVE_INFINITY) {
            return new TitanCharString("-infinity");
        }
        if (value.getValue() == Double.POSITIVE_INFINITY) {
            return new TitanCharString("infinity");
        }
        if (value.getValue() == 0.0 || value.getValue() > -1.0E10 && value.getValue() <= -1.0E-4 || value.getValue() >= 1.0E-4 && value.getValue() < 1.0E10) {
            return new TitanCharString(String.format(Locale.US, "%f", value.getValue()));
        }
        return new TitanCharString(String.format(Locale.US, "%e", value.getValue()));
    }

    public static TitanCharString float2str(TitanFloat value) {
        value.must_bound("The argument of function float2str() is an unbound float value.");
        if (value.get_value().isNaN()) {
            return new TitanCharString("not_a_number");
        }
        if (value.get_value() == Double.NEGATIVE_INFINITY) {
            return new TitanCharString("-infinity");
        }
        if (value.get_value() == Double.POSITIVE_INFINITY) {
            return new TitanCharString("infinity");
        }
        if (value.get_value() == 0.0 || value.get_value() > -1.0E10 && value.get_value() <= -1.0E-4 || value.get_value() >= 1.0E-4 && value.get_value() < 1.0E10) {
            return new TitanCharString(String.format(Locale.US, "%f", value.get_value()));
        }
        return new TitanCharString(String.format(Locale.US, "%e", value.get_value()));
    }

    public static TitanCharString unichar2char(TitanUniversalCharString value) {
        value.must_bound("The argument of function unichar2char() is an unbound universal charstring value.");
        int value_length = value.lengthof().get_int();
        if (value.charstring) {
            return new TitanCharString(value.cstr);
        }
        StringBuilder ret_val = new StringBuilder();
        List<TitanUniversalChar> uchars_ptr = value.val_ptr;
        for (int i = 0; i < value_length; ++i) {
            TitanUniversalChar uchar = uchars_ptr.get(i);
            if (uchar.getUc_group() != '\u0000' || uchar.getUc_plane() != '\u0000' || uchar.getUc_row() != '\u0000' || uchar.getUc_cell() > '\u007f') {
                throw new TtcnError(MessageFormat.format("The characters in the argument of function unichar2char() shall be within the range char(0, 0, 0, 0) .. char(0, 0, 0, 127), but quadruple char({0}, {1}, {2}, {3}) was found at index {4}.", Character.valueOf(uchar.getUc_group()), Character.valueOf(uchar.getUc_plane()), Character.valueOf(uchar.getUc_row()), Character.valueOf(uchar.getUc_row()), i));
            }
            ret_val.append(uchar.getUc_cell());
        }
        return new TitanCharString(ret_val);
    }

    public static TitanCharString unichar2char(TitanUniversalCharString_Element value) {
        value.must_bound("The argument of function unichar2char() is an unbound universal charstring element.");
        TitanUniversalChar uchar = value.get_char();
        if (uchar.getUc_group() != '\u0000' || uchar.getUc_plane() != '\u0000' || uchar.getUc_row() != '\u0000' || uchar.getUc_cell() > '\u007f') {
            throw new TtcnError(MessageFormat.format("The characters in the argument of function unichar2char() shall be within the range char(0, 0, 0, 0) .. char(0, 0, 0, 127), but the given universal charstring element contains the quadruple char({0}, {1}, {2}, {3}).", Character.valueOf(uchar.getUc_group()), Character.valueOf(uchar.getUc_plane()), Character.valueOf(uchar.getUc_row()), Character.valueOf(uchar.getUc_row())));
        }
        return new TitanCharString(String.valueOf(uchar.getUc_cell()));
    }

    public static TitanCharString regexp(TitanCharString instr, TitanCharString expression, int groupno, boolean nocase) {
        Pattern posix_str;
        instr.must_bound("The first argument (instr) of function regexp() is an unbound charstring value.");
        expression.must_bound("The second argument (expression) of function regexp() is an unbound charstring value.");
        if (groupno < 0) {
            throw new TtcnError(MessageFormat.format("The third argument (groupno) of function regexp() is a negative integer value: {0}.", groupno));
        }
        String instr_str = instr.get_value().toString();
        for (int i = 0; i < instr_str.length(); ++i) {
            if (instr_str.charAt(i) != '\u0000') continue;
            TtcnError.TtcnWarningBegin("The first argument (instr) of function regexp(), which is ");
            instr.log();
            TTCN_Logger.log_event(", contains a character with zero character code at index %d. The rest of the string will be ignored during matching.", i);
            TtcnError.TtcnWarningEnd();
            break;
        }
        String expression_str = expression.get_value().toString();
        for (int i = 0; i < expression_str.length(); ++i) {
            if (expression_str.charAt(i) != '\u0000') continue;
            TtcnError.TtcnWarningBegin("The second argument (expression) of function regexp(), which is ");
            expression.log();
            TTCN_Logger.log_event(", contains a character with zero character code at index %d. The rest of the string will be ignored during matching.", i);
            TtcnError.TtcnWarningEnd();
            break;
        }
        if ((posix_str = TTCN_Pattern.convert_pattern(expression_str, nocase)) == null) {
            TtcnError.TtcnErrorBegin("The second argument (expression) of function regexp(), which is ");
            expression.log();
            TTCN_Logger.log_event(", is not a valid TTCN-3 character pattern.", new Object[0]);
            TtcnError.TtcnErrorEnd();
        }
        if (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_UNQUALIFIED)) {
            TTCN_Logger.begin_event(TTCN_Logger.Severity.DEBUG_UNQUALIFIED);
            TTCN_Logger.log_event_str("regexp(): POSIX ERE equivalent of ");
            new TitanCharString_template(Base_Template.template_sel.STRING_PATTERN, expression, nocase).log();
            TTCN_Logger.log_event_str(" is: ");
            new TitanCharString(posix_str.toString()).log();
            TTCN_Logger.end_event();
        }
        return new TitanCharString(TTCN_Pattern.regexp(instr_str, posix_str, groupno, nocase));
    }

    public static TitanCharString regexp(TitanCharString instr, TitanCharString expression, TitanInteger groupno, boolean nocase) {
        groupno.must_bound("The third argument (groupno) of function regexp() is an unbound integer value.");
        return AdditionalFunctions.regexp(instr, expression, groupno.get_int(), nocase);
    }

    public static TitanUniversalCharString regexp(TitanUniversalCharString instr, TitanUniversalCharString expression_val, TitanUniversalCharString expression_templ, int groupno, boolean nocase) {
        if (expression_val != null && expression_templ != null || expression_val == null && expression_templ == null) {
            throw new TtcnError("Internal error: regexp(): invalid parameters");
        }
        instr.must_bound("The first argument (instr) of function regexp() is an unbound charstring value.");
        if (expression_val != null) {
            expression_val.must_bound("The second argument (expression) of function regexp() is an unbound universal charstring value.");
        } else if (!expression_templ.is_bound()) {
            throw new TtcnError("The second argument (expression) of function regexp() is an unbound universal charstring template.");
        }
        if (groupno < 0) {
            throw new TtcnError(MessageFormat.format("The third argument (groupno) of function regexp() is a negative integer value: {0}.", groupno));
        }
        Pattern posix_str = expression_val != null ? TTCN_Pattern.convert_pattern(expression_val.get_stringRepr_for_pattern().toString(), nocase) : TTCN_Pattern.convert_pattern(expression_templ.get_stringRepr_for_pattern().toString(), nocase);
        if (posix_str == null) {
            TtcnError.TtcnErrorBegin("The second argument (expression) of function regexp(), which is ");
            if (expression_val != null) {
                expression_val.log();
            } else {
                expression_templ.log();
            }
            TTCN_Logger.log_event(", is not a valid TTCN-3 character pattern.", new Object[0]);
            TtcnError.TtcnErrorEnd();
        }
        if (TTCN_Logger.log_this_event(TTCN_Logger.Severity.DEBUG_UNQUALIFIED)) {
            TTCN_Logger.begin_event(TTCN_Logger.Severity.DEBUG_UNQUALIFIED);
            TTCN_Logger.log_event_str("regexp(): POSIX ERE equivalent of ");
            new TitanCharString_template(Base_Template.template_sel.STRING_PATTERN, new TitanCharString(posix_str.toString()), nocase).log();
            TTCN_Logger.log_event_str(" is: ");
            new TitanCharString(posix_str.toString()).log();
            TTCN_Logger.end_event();
        }
        if (instr.charstring) {
            return new TitanUniversalCharString(TTCN_Pattern.regexp(instr.cstr.toString(), posix_str, groupno, nocase));
        }
        String regexp_str = TTCN_Pattern.regexp(instr.to_utf(), posix_str, groupno, nocase);
        ArrayList<TitanUniversalChar> uc_chars = new ArrayList<TitanUniversalChar>(regexp_str.length());
        try {
            byte[] utf_bytes = regexp_str.getBytes("UTF-32");
            for (int i = 0; i < utf_bytes.length; i += 4) {
                char uc_group = (char)(utf_bytes[i] & 0xFF);
                char uc_plane = (char)(utf_bytes[i + 1] & 0xFF);
                char uc_row = (char)(utf_bytes[i + 2] & 0xFF);
                char uc_cell = (char)(utf_bytes[i + 3] & 0xFF);
                uc_chars.add(new TitanUniversalChar(uc_group, uc_plane, uc_row, uc_cell));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new TtcnError(e);
        }
        return new TitanUniversalCharString(uc_chars);
    }

    public static TitanUniversalCharString regexp(TitanUniversalCharString instr, TitanUniversalCharString expression, int groupno, boolean nocase) {
        return AdditionalFunctions.regexp(instr, expression, null, groupno, nocase);
    }

    public static TitanUniversalCharString regexp(TitanUniversalCharString instr, TitanUniversalCharString expression, TitanInteger groupno, boolean nocase) {
        groupno.must_bound("The third argument (groupno) of function regexp() is an unbound integer value.");
        return AdditionalFunctions.regexp(instr, expression, groupno.get_int(), nocase);
    }

    public static TitanCharString regexp(TitanCharString_template instr, TitanCharString_template expression, int groupno, boolean nocase) {
        if (!instr.is_value()) {
            throw new TtcnError("The first argument of function regexp() is a template with non-specific value.");
        }
        if (expression.is_value()) {
            return AdditionalFunctions.regexp(instr.valueof(), expression.valueof(), groupno, nocase);
        }
        if (expression.get_selection() == Base_Template.template_sel.STRING_PATTERN) {
            return AdditionalFunctions.regexp(instr.valueof(), expression.single_value, groupno, nocase);
        }
        throw new TtcnError("The second argument of function regexp() should be specific value or pattern matching template.");
    }

    public static TitanCharString regexp(TitanCharString_template instr, TitanCharString_template expression, TitanInteger groupno, boolean nocase) {
        groupno.must_bound("The third argument (groupno) of function regexp() is an unbound integer value.");
        return AdditionalFunctions.regexp(instr, expression, groupno.get_int(), nocase);
    }

    public static TitanUniversalCharString regexp(TitanUniversalCharString_template instr, TitanUniversalCharString_template expression, int groupno, boolean nocase) {
        if (!instr.is_value()) {
            throw new TtcnError("The first argument of function regexp() is a template with non-specific value.");
        }
        if (expression.is_value()) {
            return AdditionalFunctions.regexp(instr.valueof(), expression.valueof(), groupno, nocase);
        }
        if (expression.get_selection() == Base_Template.template_sel.STRING_PATTERN) {
            return AdditionalFunctions.regexp(instr.valueof(), null, expression.valueof(), groupno, nocase);
        }
        throw new TtcnError("The second argument of function regexp() should be specific value or pattern matching template.");
    }

    public static TitanUniversalCharString regexp(TitanUniversalCharString_template instr, TitanUniversalCharString_template expression, TitanInteger groupno, boolean nocase) {
        groupno.must_bound("The third argument (groupno) of function regexp() is an unbound integer value.");
        return AdditionalFunctions.regexp(instr, expression, groupno.get_int(), nocase);
    }

    public static TitanCharString regexp(TitanCharString instr, TitanCharString_template expression, int groupno, boolean nocase) {
        if (!instr.is_value()) {
            throw new TtcnError("The first argument of function regexp() is a template with non-specific value.");
        }
        if (expression.is_value()) {
            return AdditionalFunctions.regexp(instr, expression.valueof(), groupno, nocase);
        }
        if (expression.get_selection() == Base_Template.template_sel.STRING_PATTERN) {
            return AdditionalFunctions.regexp(instr, expression.single_value, groupno, nocase);
        }
        throw new TtcnError("The second argument of function regexp() should be specific value or pattern matching template.");
    }

    public static TitanCharString regexp(TitanCharString instr, TitanCharString_template expression, TitanInteger groupno, boolean nocase) {
        groupno.must_bound("The third argument (groupno) of function regexp() is an unbound integer value.");
        return AdditionalFunctions.regexp(instr, expression, groupno.get_int(), nocase);
    }

    public static TitanCharString regexp(TitanUniversalCharString instr, TitanCharString expression, TitanInteger groupno, boolean nocase) {
        instr.must_bound("The first argument (instr) of function regexp() is an unbound universal charstring value.");
        if (instr.charstring) {
            return AdditionalFunctions.regexp(new TitanCharString(instr.cstr), expression, groupno, nocase);
        }
        throw new TtcnError("The first argument (instr) of function regexp() should be a charstring value.");
    }

    public static String get_port_name(String port_name, int array_index) {
        return MessageFormat.format("{0}[{1}]", port_name, array_index);
    }

    public static String get_port_name(String port_name, TitanInteger array_index) {
        array_index.must_bound("Using an unbound integer value for indexing an array of ports.");
        return AdditionalFunctions.get_port_name(port_name, array_index.get_int());
    }

    public static String get_port_name(TitanCharString port_name, int array_index) {
        port_name.must_bound("Internal error: Using an unbound charstring value to obtain the name of a port.");
        return AdditionalFunctions.get_port_name(port_name.get_value().toString(), array_index);
    }

    public static String get_port_name(TitanCharString port_name, TitanInteger array_index) {
        port_name.must_bound("Internal error: Using an unbound charstring value to obtain the name of a port.");
        array_index.must_bound("Using an unbound integer value for indexing an array of ports.");
        return AdditionalFunctions.get_port_name(port_name.get_value().toString(), array_index.get_int());
    }

    public static TitanCharString encode_base64(TitanOctetString msg, TitanBoolean use_linebreaks) {
        int octets_left;
        byte[] p_msg = msg.get_value();
        int msgPos = 0;
        char[] output = new char[(octets_left * 22 >> 4) + 7];
        int outpotPos = 0;
        int n_4chars = 0;
        boolean linebreaks = use_linebreaks.get_value();
        for (octets_left = p_msg.length; octets_left >= 3; octets_left -= 3) {
            output[outpotPos++] = code_table.charAt((p_msg[msgPos + 0] & 0xFF) >> 2);
            output[outpotPos++] = code_table.charAt(((p_msg[msgPos + 0] & 0xFF) << 4 | (p_msg[msgPos + 1] & 0xFF) >> 4) & 0x3F);
            output[outpotPos++] = code_table.charAt(((p_msg[msgPos + 1] & 0xFF) << 2 | (p_msg[msgPos + 2] & 0xFF) >> 6) & 0x3F);
            output[outpotPos++] = code_table.charAt(p_msg[msgPos + 2] & 0xFF & 0x3F);
            if (linebreaks && ++n_4chars >= 19 && octets_left != 3) {
                output[outpotPos++] = 13;
                output[outpotPos++] = 10;
                n_4chars = 0;
            }
            msgPos += 3;
        }
        switch (octets_left) {
            case 1: {
                output[outpotPos++] = code_table.charAt((p_msg[msgPos + 0] & 0xFF) >> 2);
                output[outpotPos++] = code_table.charAt((p_msg[msgPos + 0] & 0xFF) << 4 & 0x3F);
                output[outpotPos++] = 61;
                output[outpotPos++] = 61;
                break;
            }
            case 2: {
                output[outpotPos++] = code_table.charAt((p_msg[msgPos + 0] & 0xFF) >> 2);
                output[outpotPos++] = code_table.charAt(((p_msg[msgPos + 0] & 0xFF) << 4 | (p_msg[msgPos + 1] & 0xFF) >> 4) & 0x3F);
                output[outpotPos++] = code_table.charAt((p_msg[msgPos + 1] & 0xFF) << 2 & 0x3F);
                output[outpotPos++] = 61;
                break;
            }
        }
        return new TitanCharString(new String(output, 0, outpotPos));
    }

    public static TitanCharString encode_base64(TitanOctetString msg) {
        int octets_left;
        byte[] p_msg = msg.get_value();
        int msgPos = 0;
        char[] output = new char[(octets_left * 22 >> 4) + 7];
        int outpotPos = 0;
        for (octets_left = p_msg.length; octets_left >= 3; octets_left -= 3) {
            output[outpotPos++] = code_table.charAt((p_msg[msgPos + 0] & 0xFF) >> 2);
            output[outpotPos++] = code_table.charAt(((p_msg[msgPos + 0] & 0xFF) << 4 | (p_msg[msgPos + 1] & 0xFF) >> 4) & 0x3F);
            output[outpotPos++] = code_table.charAt(((p_msg[msgPos + 1] & 0xFF) << 2 | (p_msg[msgPos + 2] & 0xFF) >> 6) & 0x3F);
            output[outpotPos++] = code_table.charAt(p_msg[msgPos + 2] & 0xFF & 0x3F);
            msgPos += 3;
        }
        switch (octets_left) {
            case 1: {
                output[outpotPos++] = code_table.charAt((p_msg[msgPos + 0] & 0xFF) >> 2);
                output[outpotPos++] = code_table.charAt((p_msg[msgPos + 0] & 0xFF) << 4 & 0x3F);
                output[outpotPos++] = 61;
                output[outpotPos++] = 61;
                break;
            }
            case 2: {
                output[outpotPos++] = code_table.charAt((p_msg[msgPos + 0] & 0xFF) >> 2);
                output[outpotPos++] = code_table.charAt(((p_msg[msgPos + 0] & 0xFF) << 4 | (p_msg[msgPos + 1] & 0xFF) >> 4) & 0x3F);
                output[outpotPos++] = code_table.charAt((p_msg[msgPos + 1] & 0xFF) << 2 & 0x3F);
                output[outpotPos++] = 61;
                break;
            }
        }
        return new TitanCharString(new String(output, 0, outpotPos));
    }

    public static TitanOctetString decode_base64(TitanCharString b64) {
        byte[] p_b64 = b64.get_value().toString().getBytes();
        int b64Pos = 0;
        int chars_left = b64.lengthof().get_int();
        byte[] output = new byte[((chars_left >> 2) + 1) * 3];
        int outpotPos = 0;
        int bits = 0;
        int n_bits = 0;
        while (chars_left > 0) {
            --chars_left;
            byte p_b64_b64Pos = p_b64[b64Pos];
            if (p_b64_b64Pos > 0 && decode_table[p_b64_b64Pos] < 64) {
                bits <<= 6;
                bits |= decode_table[p_b64_b64Pos];
                if ((n_bits += 6) >= 8) {
                    output[outpotPos++] = (byte)(bits >> n_bits - 8 & 0xFF);
                    n_bits -= 8;
                }
            } else {
                if (p_b64_b64Pos == 61) break;
                if (p_b64_b64Pos == 13 && p_b64[b64Pos + 1] == 10) {
                    ++b64Pos;
                } else {
                    throw new TtcnError(String.format("Error: Invalid character in Base64 encoded data: 0x%02X", p_b64_b64Pos));
                }
            }
            ++b64Pos;
        }
        byte[] result = new byte[outpotPos];
        System.arraycopy(output, 0, result, 0, outpotPos);
        return new TitanOctetString(result);
    }

    public static TitanOctetString json2cbor(TitanUniversalCharString value) {
        TTCN_Buffer buff = new TTCN_Buffer();
        value.encode_utf8(buff);
        byte[] ustr = buff.get_data();
        int ustr_len = buff.get_len();
        String json_str = new String(ustr);
        JSON_Tokenizer tok = new JSON_Tokenizer(json_str, ustr_len);
        buff.clear();
        AtomicInteger num_of_items = new AtomicInteger(0);
        JSON.json2cbor_coding(buff, tok, num_of_items);
        TitanOctetString result = new TitanOctetString();
        buff.get_string(result);
        return result;
    }

    public static TitanUniversalCharString cbor2json(TitanOctetString value) {
        TTCN_Buffer buff = new TTCN_Buffer();
        buff.put_os(value);
        JSON_Tokenizer tok = new JSON_Tokenizer();
        JSON.cbor2json_coding(buff, tok, false);
        byte[] resultBytes = tok.get_buffer().toString().getBytes();
        TitanUniversalCharString result = new TitanUniversalCharString();
        result.decode_utf8(resultBytes, TitanCharString.CharCoding.UTF_8, false);
        return result;
    }

    public static TitanUniversalCharString bson2json(TitanOctetString value) {
        TTCN_Buffer buff = new TTCN_Buffer();
        buff.put_os(value);
        JSON_Tokenizer tok = new JSON_Tokenizer();
        JSON.bson2json_coding(buff, tok, false, false);
        byte[] resultBytes = tok.get_buffer().toString().getBytes();
        TitanUniversalCharString result = new TitanUniversalCharString();
        result.decode_utf8(resultBytes, TitanCharString.CharCoding.UTF_8, false);
        return result;
    }

    public static TitanOctetString json2bson(TitanUniversalCharString value) {
        TTCN_Buffer buff = new TTCN_Buffer();
        value.encode_utf8(buff);
        byte[] ustr = buff.get_data();
        int ustr_len = buff.get_len();
        String json_str = new String(ustr);
        JSON_Tokenizer tok = new JSON_Tokenizer(json_str, ustr_len);
        buff.clear();
        TitanInteger length = new TitanInteger(0);
        TitanCharString cs = new TitanCharString();
        boolean is_special = false;
        JSON.json2bson_coding(buff, tok, false, false, length, cs, false);
        TitanOctetString result = new TitanOctetString();
        buff.get_string(result);
        return result;
    }

    private static enum str2floatState {
        S_INITIAL,
        S_FIRST_M,
        S_ZERO_M,
        S_MORE_M,
        S_FIRST_F,
        S_MORE_F,
        S_INITIAL_E,
        S_FIRST_E,
        S_ZERO_E,
        S_MORE_E,
        S_END,
        S_ERR;

    }

    private static enum str2intState {
        S_INITIAL,
        S_FIRST,
        S_ZERO,
        S_MORE,
        S_END,
        S_ERR;

    }
}

