/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanBitString;
import org.eclipse.titan.runtime.core.TitanBoolean;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public abstract class TitanRecordOf
extends Base_Type {
    List<Base_Type> valueElements;
    private final Class<? extends Base_Type> ofType;

    public TitanRecordOf(Class<? extends Base_Type> aOfType) {
        this.ofType = aOfType;
    }

    public TitanRecordOf(TitanRecordOf other_value) {
        other_value.must_bound("Copying an unbound record of/set of value.");
        this.ofType = other_value.ofType;
        this.valueElements = this.copy_list(other_value.valueElements);
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_bound() {
        return this.valueElements != null;
    }

    @Override
    public void clean_up() {
        this.valueElements = null;
    }

    @Override
    public void log() {
        if (this.valueElements == null) {
            TTCN_Logger.log_event_unbound();
            return;
        }
        TTCN_Logger.log_event_str("{ ");
        int size = this.valueElements.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                TTCN_Logger.log_event_str(", ");
            }
            this.valueElements.get(i).log();
        }
        TTCN_Logger.log_event_str(" }");
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        if (this.valueElements == null) {
            throw new TtcnError("Text encoder: Encoding an unbound value of type record of.");
        }
        text_buf.push_int(this.valueElements.size());
        for (int i = 0; i < this.valueElements.size(); ++i) {
            this.valueElements.get(i).encode_text(text_buf);
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        int new_size = text_buf.pull_int().get_int();
        if (new_size < 0) {
            throw new TtcnError("Text decoder: Negative size was received for a value of type record of.");
        }
        this.valueElements = new ArrayList<Base_Type>(new_size);
        for (int i = 0; i < new_size; ++i) {
            Base_Type newElem = this.get_unbound_elem();
            newElem.decode_text(text_buf);
            this.valueElements.add(newElem);
        }
    }

    private boolean is_same_type(Base_Type otherValue) {
        return otherValue instanceof TitanRecordOf && this.ofType == ((TitanRecordOf)otherValue).ofType;
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (!this.is_same_type(otherValue)) {
            throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to record of {1}", otherValue, this.get_of_type_name()));
        }
        return this.operator_equals((TitanRecordOf)otherValue);
    }

    public boolean operator_equals(TitanRecordOf otherValue) {
        this.must_bound("The left operand of comparison is an unbound value of type record of " + this.get_of_type_name() + ".");
        otherValue.must_bound("The right operand of comparison is an unbound value of type" + otherValue.get_of_type_name() + ".");
        int size = this.valueElements.size();
        if (size != otherValue.valueElements.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Base_Type rightElem;
            Base_Type leftElem = this.valueElements.get(i);
            if (leftElem.operator_equals(rightElem = otherValue.valueElements.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Base_Type operator_assign(Base_Type otherValue) {
        if (!this.is_same_type(otherValue)) {
            throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to record of {1}", otherValue, this.get_of_type_name()));
        }
        return this.operator_assign((TitanRecordOf)otherValue);
    }

    public TitanRecordOf operator_assign(TitanRecordOf otherValue) {
        otherValue.must_bound("Assignment of an unbound record of value.");
        this.valueElements = otherValue.valueElements;
        return this;
    }

    public final List<Base_Type> copy_list(List<Base_Type> srcList) {
        if (srcList == null) {
            return null;
        }
        ArrayList<Base_Type> newList = new ArrayList<Base_Type>(srcList.size());
        for (Base_Type srcElem : srcList) {
            Base_Type newElem = this.get_unbound_elem();
            newElem.operator_assign(srcElem);
            newList.add(newElem);
        }
        return newList;
    }

    public Base_Type get_at(int index_value) {
        if (index_value < 0) {
            throw new TtcnError(MessageFormat.format("Accessing an element of type record of {0} using a negative index: {1}.", this.get_of_type_name(), index_value));
        }
        if (index_value >= this.valueElements.size()) {
            for (int i = this.valueElements.size(); i <= index_value; ++i) {
                this.valueElements.set(index_value, null);
            }
        }
        if (this.valueElements.get(index_value) == null) {
            Base_Type newElem = this.get_unbound_elem();
            this.valueElements.set(index_value, newElem);
        }
        return this.valueElements.get(index_value);
    }

    public Base_Type get_at(TitanInteger index_value) {
        index_value.must_bound(MessageFormat.format("Using an unbound integer value for indexing a value of type {0}.", this.get_of_type_name()));
        return this.get_at(index_value.get_int());
    }

    public Base_Type constGet_at(int index_value) {
        this.must_bound(MessageFormat.format("Accessing an element in an unbound value of type record of {0}.", this.get_of_type_name()));
        if (index_value < 0) {
            throw new TtcnError(MessageFormat.format("Accessing an element of type record of {0} using a negative index: {1}.", this.get_of_type_name(), index_value));
        }
        int nofElements = this.n_elem();
        if (index_value >= nofElements) {
            throw new TtcnError(MessageFormat.format("Index overflow in a value of type record of {0}: The index is {1}, but the value has only {2} elements.", this.get_of_type_name(), index_value, nofElements));
        }
        Base_Type elem = this.valueElements.get(index_value);
        return elem != null ? elem : this.get_unbound_elem();
    }

    public Base_Type constGet_at(TitanInteger index_value) {
        index_value.must_bound(MessageFormat.format("Using an unbound integer value for indexing a value of type {0}.", this.get_of_type_name()));
        return this.constGet_at(index_value.get_int());
    }

    private Base_Type get_unbound_elem() {
        try {
            return this.ofType.newInstance();
        }
        catch (Exception e) {
            throw new TtcnError(MessageFormat.format("Internal Error: exception `{0}'' thrown while instantiating class of `{1}'' type", e.getMessage(), this.get_of_type_name()));
        }
    }

    private static String get_of_type_name(Class<? extends Base_Type> aOfType) {
        if (aOfType == TitanBoolean.class) {
            return "boolean";
        }
        if (aOfType == TitanBitString.class) {
            return "bitstring";
        }
        return aOfType.toString();
    }

    private String get_of_type_name() {
        return TitanRecordOf.get_of_type_name(this.ofType);
    }

    public int n_elem() {
        if (this.valueElements == null) {
            return 0;
        }
        return this.valueElements.size();
    }

    public void add(Base_Type aElement) {
        if (aElement.getClass() != this.ofType) {
            throw new TtcnError(MessageFormat.format("Adding a {0} type variable to a record of {1}", TitanRecordOf.get_of_type_name(aElement.getClass()), this.get_of_type_name()));
        }
        if (this.valueElements == null) {
            this.valueElements = new ArrayList<Base_Type>();
        }
        this.valueElements.add(aElement);
    }
}

