/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SignatureExceptions
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".<type";
    private final List<Type> exceptionTypes;
    private final Map<String, Type> exceptionMap;
    private Location location = NULL_Location.INSTANCE;
    private CompilationTimeStamp lastTimeChecked = null;

    public SignatureExceptions(List<Type> exceptionTypes) {
        this.exceptionTypes = exceptionTypes == null ? new ArrayList<Type>() : exceptionTypes;
        this.exceptionMap = new HashMap<String, Type>();
        for (Type type : this.exceptionTypes) {
            type.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.exceptionTypes.size(); ++i) {
            if (this.exceptionTypes.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i)).append(">");
        }
        return builder;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (Type exception : this.exceptionTypes) {
            exception.setMyScope(scope);
        }
    }

    public int getNofExceptions() {
        return this.exceptionTypes.size();
    }

    public Type getExceptionByIndex(int index) {
        return this.exceptionTypes.get(index);
    }

    public boolean hasException(CompilationTimeStamp timestamp, Type type) {
        if (type == null) {
            return false;
        }
        if (type.getIsErroneous(timestamp)) {
            return true;
        }
        return this.exceptionMap.containsKey(type.getTypename());
    }

    public int getNofCompatibleExceptions(CompilationTimeStamp timestamp, IType type) {
        if (type.getTypeRefdLast(timestamp).getIsErroneous(timestamp)) {
            return 1;
        }
        int result = 0;
        for (int i = 0; i < this.exceptionTypes.size(); ++i) {
            if (!this.exceptionTypes.get(i).isCompatible(timestamp, type, null, null, null)) continue;
            ++result;
        }
        return result;
    }

    public void check(CompilationTimeStamp timestamp, Signature_Type signature) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.exceptionMap.clear();
        for (int i = 0; i < this.exceptionTypes.size(); ++i) {
            Type type = this.exceptionTypes.get(i);
            type.setParentType(signature);
            type.check(timestamp);
            if (type.getIsErroneous(timestamp)) continue;
            type.checkEmbedded(timestamp, type.getLocation(), false, "on the exception list of a signature");
            String name = type.getTypename();
            if (this.exceptionMap.containsKey(name)) {
                type.getLocation().reportSemanticError("Duplicate type in exception list");
                this.exceptionMap.get(name).getLocation().reportSingularSemanticError(MessageFormat.format("Type `{0}'' is already given here", name));
                continue;
            }
            this.exceptionMap.put(name, type);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (Type exception : this.exceptionTypes) {
            exception.updateSyntax(reparser, isDamaged);
            reparser.updateLocation(exception.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.exceptionTypes != null) {
            for (Type t : this.exceptionTypes) {
                t.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.exceptionTypes != null) {
            for (Type t : this.exceptionTypes) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

