/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;

public final class EditorTracker {
    private static final Map<IFile, CopyOnWriteArrayList<ISemanticTITANEditor>> FILE_EDITOR_MAP = new ConcurrentHashMap<IFile, CopyOnWriteArrayList<ISemanticTITANEditor>>();

    private EditorTracker() {
    }

    public static boolean containsKey(IFile file) {
        return FILE_EDITOR_MAP.containsKey(file);
    }

    public static List<ISemanticTITANEditor> getEditor(IFile file) {
        if (FILE_EDITOR_MAP.containsKey(file)) {
            return FILE_EDITOR_MAP.get(file);
        }
        return null;
    }

    public static List<ISemanticTITANEditor> getEditors() {
        ArrayList<ISemanticTITANEditor> result = new ArrayList<ISemanticTITANEditor>();
        for (List list : FILE_EDITOR_MAP.values()) {
            for (ISemanticTITANEditor editor : list) {
                if (result.contains(editor)) continue;
                result.add(editor);
            }
        }
        return result;
    }

    public static void put(IFile file, ISemanticTITANEditor editor) {
        if (FILE_EDITOR_MAP.containsKey(file)) {
            CopyOnWriteArrayList<ISemanticTITANEditor> editors = FILE_EDITOR_MAP.get(file);
            editors.add(editor);
        } else {
            CopyOnWriteArrayList<ISemanticTITANEditor> editors = new CopyOnWriteArrayList<ISemanticTITANEditor>();
            editors.add(editor);
            FILE_EDITOR_MAP.put(file, editors);
        }
    }

    public static void remove(IFile file, ISemanticTITANEditor editor) {
        if (!FILE_EDITOR_MAP.containsKey(file)) {
            return;
        }
        List editors = FILE_EDITOR_MAP.get(file);
        editors.remove(editor);
        if (editors.isEmpty()) {
            FILE_EDITOR_MAP.remove(file);
        }
    }

    public static void remove(ISemanticTITANEditor editor) {
        for (IFile file : FILE_EDITOR_MAP.keySet()) {
            List editors = FILE_EDITOR_MAP.get(file);
            editors.remove(editor);
        }
    }

    public static Set<IFile> keyset() {
        return FILE_EDITOR_MAP.keySet();
    }
}

