/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MarkOccurrencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Preferences for the editor's mark occurrences feature";
    private static final String ENABLE_MARK = "Mark occurrences of the selected element";
    private static final String DELAY_TEXT = "Delay (in milisecs)";
    private static final String KEEP_MARKS = "Keep the marks after changing the selection";
    private static final String MARK_ASN1_ASSIGNMENTS = "ASN.1 assignments";
    private static final String MARK_TTCN3_ASSIGNMENTS = "TTCN3 definitions";
    private Composite pageComposite;
    private BooleanFieldEditor enableMarkOccurrences;
    private IntegerFieldEditor delay;
    private BooleanFieldEditor keepMarks;
    private Composite generalGroup;
    private Group optionsGroup;
    private BooleanFieldEditor markASN1Assignments;
    private BooleanFieldEditor markTTCN3Assignments;

    public MarkOccurrencesPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
        super.initialize();
    }

    protected void createFieldEditors() {
        this.pageComposite = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.pageComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)gridData);
        this.createGeneralGroup(this.pageComposite);
        this.createOptionsGroup(this.pageComposite);
    }

    private void createGeneralGroup(Composite parent) {
        this.generalGroup = new Composite(parent, 0);
        this.enableMarkOccurrences = new BooleanFieldEditor("org.eclipse.titan.designer.markOccurrencesEnabled", ENABLE_MARK, this.generalGroup);
        this.addField((FieldEditor)this.enableMarkOccurrences);
        this.delay = new IntegerFieldEditor("org.eclipse.titan.designer.markOccurrencesDelay", DELAY_TEXT, this.generalGroup);
        this.delay.setValidRange(0, Integer.MAX_VALUE);
        this.delay.setTextLimit(10);
        this.delay.setEnabled(this.doGetPreferenceStore().getBoolean("org.eclipse.titan.designer.markOccurrencesEnabled"), this.generalGroup);
        this.addField((FieldEditor)this.delay);
        this.keepMarks = new BooleanFieldEditor("org.eclipse.titan.designer.markOccurrencesKeepMarks", KEEP_MARKS, this.generalGroup);
        this.keepMarks.setEnabled(this.doGetPreferenceStore().getBoolean("org.eclipse.titan.designer.markOccurrencesEnabled"), this.generalGroup);
        this.addField((FieldEditor)this.keepMarks);
    }

    private void createOptionsGroup(Composite parent) {
        this.optionsGroup = new Group(parent, 64);
        this.optionsGroup.setText("Mark occurrences of the following elements");
        this.optionsGroup.setLayout((Layout)new GridLayout(1, true));
        this.optionsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        boolean markOccurrencesEnabled = this.doGetPreferenceStore().getBoolean("org.eclipse.titan.designer.markOccurrencesEnabled");
        this.markASN1Assignments = new BooleanFieldEditor("org.eclipse.titan.designer.markOccurrencesAsn1Assignments", MARK_ASN1_ASSIGNMENTS, (Composite)this.optionsGroup);
        this.markASN1Assignments.setEnabled(markOccurrencesEnabled, (Composite)this.optionsGroup);
        this.addField((FieldEditor)this.markASN1Assignments);
        this.markTTCN3Assignments = new BooleanFieldEditor("org.eclipse.titan.designer.markOccurrencesTtcn3Assignments", MARK_TTCN3_ASSIGNMENTS, (Composite)this.optionsGroup);
        this.markTTCN3Assignments.setEnabled(markOccurrencesEnabled, (Composite)this.optionsGroup);
        this.addField((FieldEditor)this.markTTCN3Assignments);
    }

    protected void updateFieldEditors() {
        boolean markOccurrencesEnabled = this.enableMarkOccurrences.getBooleanValue();
        this.delay.setEnabled(markOccurrencesEnabled, this.generalGroup);
        this.keepMarks.setEnabled(markOccurrencesEnabled, this.generalGroup);
        this.markASN1Assignments.setEnabled(markOccurrencesEnabled, (Composite)this.optionsGroup);
        this.markTTCN3Assignments.setEnabled(markOccurrencesEnabled, (Composite)this.optionsGroup);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.enableMarkOccurrences) {
            this.updateFieldEditors();
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateFieldEditors();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        IEclipsePreferences node = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node("org.eclipse.titan.designer");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return result;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        this.markASN1Assignments.dispose();
        this.markTTCN3Assignments.dispose();
        this.optionsGroup.dispose();
        this.keepMarks.dispose();
        this.delay.dispose();
        this.enableMarkOccurrences.dispose();
        this.pageComposite.dispose();
        this.generalGroup.dispose();
        super.dispose();
    }
}

