/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.implementation;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.IMetric;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.ProjectMetric;
import org.eclipse.titanium.metrics.TestcaseMetric;
import org.eclipse.titanium.metrics.implementation.AMBranches;
import org.eclipse.titanium.metrics.implementation.AMCyclomaticComplexity;
import org.eclipse.titanium.metrics.implementation.AMInEnvy;
import org.eclipse.titanium.metrics.implementation.AMLinesOfCode;
import org.eclipse.titanium.metrics.implementation.AMNesting;
import org.eclipse.titanium.metrics.implementation.AMNumberOfParams;
import org.eclipse.titanium.metrics.implementation.AMOutEnvy;
import org.eclipse.titanium.metrics.implementation.FMCyclomaticComplexity;
import org.eclipse.titanium.metrics.implementation.FMDefaultActivations;
import org.eclipse.titanium.metrics.implementation.FMInEnvy;
import org.eclipse.titanium.metrics.implementation.FMLinesOfCode;
import org.eclipse.titanium.metrics.implementation.FMNesting;
import org.eclipse.titanium.metrics.implementation.FMNumberOfParams;
import org.eclipse.titanium.metrics.implementation.FMOutEnvy;
import org.eclipse.titanium.metrics.implementation.FMReturnPoints;
import org.eclipse.titanium.metrics.implementation.MMAfferentCoupling;
import org.eclipse.titanium.metrics.implementation.MMEfferentCoupling;
import org.eclipse.titanium.metrics.implementation.MMInEnvy;
import org.eclipse.titanium.metrics.implementation.MMInstability;
import org.eclipse.titanium.metrics.implementation.MMLinesOfCode;
import org.eclipse.titanium.metrics.implementation.MMNofAltsteps;
import org.eclipse.titanium.metrics.implementation.MMNofFixme;
import org.eclipse.titanium.metrics.implementation.MMNofFunctions;
import org.eclipse.titanium.metrics.implementation.MMNofImports;
import org.eclipse.titanium.metrics.implementation.MMNofStatements;
import org.eclipse.titanium.metrics.implementation.MMNofTestcases;
import org.eclipse.titanium.metrics.implementation.MMOutEnvy;
import org.eclipse.titanium.metrics.implementation.MMTimesImported;
import org.eclipse.titanium.metrics.implementation.PMNofASN1Modules;
import org.eclipse.titanium.metrics.implementation.PMNofTTCN3Modules;
import org.eclipse.titanium.metrics.implementation.TMCyclomaticComplexity;
import org.eclipse.titanium.metrics.implementation.TMInEnvy;
import org.eclipse.titanium.metrics.implementation.TMLinesOfCode;
import org.eclipse.titanium.metrics.implementation.TMNesting;
import org.eclipse.titanium.metrics.implementation.TMNumberOfParams;
import org.eclipse.titanium.metrics.implementation.TMOutEnvy;

public class Metrics {
    private final Map<AltstepMetric, IMetric<Def_Altstep, AltstepMetric>> altstepMetrics = new EnumMap<AltstepMetric, IMetric<Def_Altstep, AltstepMetric>>(AltstepMetric.class);
    private final Map<FunctionMetric, IMetric<Def_Function, FunctionMetric>> functionMetrics;
    private final Map<TestcaseMetric, IMetric<Def_Testcase, TestcaseMetric>> testcaseMetrics;
    private final Map<ModuleMetric, IMetric<Module, ModuleMetric>> moduleMetrics;
    private final Map<ProjectMetric, IMetric<IProject, ProjectMetric>> projectMetrics;

    public Metrics() {
        this.altstepMetrics.put(AltstepMetric.BRANCHES, new AMBranches());
        this.altstepMetrics.put(AltstepMetric.CYCLOMATIC_COMPLEXITY, new AMCyclomaticComplexity());
        this.altstepMetrics.put(AltstepMetric.IN_ENVY, new AMInEnvy());
        this.altstepMetrics.put(AltstepMetric.LINES_OF_CODE, new AMLinesOfCode());
        this.altstepMetrics.put(AltstepMetric.NESTING, new AMNesting());
        this.altstepMetrics.put(AltstepMetric.NUMBER_OF_PARAMETERS, new AMNumberOfParams());
        this.altstepMetrics.put(AltstepMetric.OUT_ENVY, new AMOutEnvy());
        this.functionMetrics = new EnumMap<FunctionMetric, IMetric<Def_Function, FunctionMetric>>(FunctionMetric.class);
        this.functionMetrics.put(FunctionMetric.CYCLOMATIC_COMPLEXITY, new FMCyclomaticComplexity());
        this.functionMetrics.put(FunctionMetric.DEFAULT_ACTIVATIONS, new FMDefaultActivations());
        this.functionMetrics.put(FunctionMetric.IN_ENVY, new FMInEnvy());
        this.functionMetrics.put(FunctionMetric.LINES_OF_CODE, new FMLinesOfCode());
        this.functionMetrics.put(FunctionMetric.NESTING, new FMNesting());
        this.functionMetrics.put(FunctionMetric.NUMBER_OF_PARAMETERS, new FMNumberOfParams());
        this.functionMetrics.put(FunctionMetric.OUT_ENVY, new FMOutEnvy());
        this.functionMetrics.put(FunctionMetric.RETURN_POINTS, new FMReturnPoints());
        this.testcaseMetrics = new EnumMap<TestcaseMetric, IMetric<Def_Testcase, TestcaseMetric>>(TestcaseMetric.class);
        this.testcaseMetrics.put(TestcaseMetric.CYCLOMATIC_COMPLEXITY, new TMCyclomaticComplexity());
        this.testcaseMetrics.put(TestcaseMetric.IN_ENVY, new TMInEnvy());
        this.testcaseMetrics.put(TestcaseMetric.LINES_OF_CODE, new TMLinesOfCode());
        this.testcaseMetrics.put(TestcaseMetric.NESTING, new TMNesting());
        this.testcaseMetrics.put(TestcaseMetric.NUMBER_OF_PARAMETERS, new TMNumberOfParams());
        this.testcaseMetrics.put(TestcaseMetric.OUT_ENVY, new TMOutEnvy());
        this.moduleMetrics = new EnumMap<ModuleMetric, IMetric<Module, ModuleMetric>>(ModuleMetric.class);
        this.moduleMetrics.put(ModuleMetric.AFFERENT_COUPLING, new MMAfferentCoupling());
        this.moduleMetrics.put(ModuleMetric.EFFERENT_COUPLING, new MMEfferentCoupling());
        this.moduleMetrics.put(ModuleMetric.IN_ENVY, new MMInEnvy());
        this.moduleMetrics.put(ModuleMetric.INSTABILITY, new MMInstability());
        this.moduleMetrics.put(ModuleMetric.LINES_OF_CODE, new MMLinesOfCode());
        this.moduleMetrics.put(ModuleMetric.NOF_STATEMENTS, new MMNofStatements());
        this.moduleMetrics.put(ModuleMetric.NOF_ALTSTEPS, new MMNofAltsteps());
        this.moduleMetrics.put(ModuleMetric.NOF_FIXME, new MMNofFixme());
        this.moduleMetrics.put(ModuleMetric.NOF_FUNCTIONS, new MMNofFunctions());
        this.moduleMetrics.put(ModuleMetric.NOF_IMPORTS, new MMNofImports());
        this.moduleMetrics.put(ModuleMetric.NOF_TESTCASES, new MMNofTestcases());
        this.moduleMetrics.put(ModuleMetric.OUT_ENVY, new MMOutEnvy());
        this.moduleMetrics.put(ModuleMetric.TIMES_IMPORTED, new MMTimesImported());
        this.projectMetrics = new EnumMap<ProjectMetric, IMetric<IProject, ProjectMetric>>(ProjectMetric.class);
        this.projectMetrics.put(ProjectMetric.NOF_ASN1_MODULES, new PMNofASN1Modules());
        this.projectMetrics.put(ProjectMetric.NOF_TTCN3_MODULES, new PMNofTTCN3Modules());
    }

    public IMetric<Def_Altstep, AltstepMetric> get(AltstepMetric metric) {
        return this.altstepMetrics.get(metric);
    }

    public IMetric<Def_Function, FunctionMetric> get(FunctionMetric metric) {
        return this.functionMetrics.get(metric);
    }

    public IMetric<Def_Testcase, TestcaseMetric> get(TestcaseMetric metric) {
        return this.testcaseMetrics.get(metric);
    }

    public IMetric<Module, ModuleMetric> get(ModuleMetric metric) {
        return this.moduleMetrics.get(metric);
    }

    public IMetric<IProject, ProjectMetric> get(ProjectMetric metric) {
        return this.projectMetrics.get(metric);
    }
}

