/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.view;

import java.io.File;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.StatColumn;
import org.eclipse.titanium.metrics.utils.RiskLevel;
import org.eclipse.titanium.metrics.view.ContentProvider;
import org.eclipse.titanium.metrics.view.ExportSetDialog;
import org.eclipse.titanium.metrics.view.IOpenable;
import org.eclipse.titanium.metrics.view.LabelProvider;
import org.eclipse.titanium.metrics.view.Sorter;
import org.eclipse.titanium.metrics.view.XLSExporter;
import org.eclipse.titanium.utils.LocationHighlighter;
import org.eclipse.titanium.utils.ProjectAnalyzerJob;
import org.eclipse.ui.part.ViewPart;

public class MetricsView
extends ViewPart {
    private static final String COLUMN_HEADER_1 = "Metrics";
    private static final Map<StatColumn, Integer> ALIGNMENTS = new EnumMap<StatColumn, Integer>(StatColumn.class);
    private static final String REFRESH_TOOLTIP = "Start measuring";
    private static final String EXPORT_TOOLTIP = "Export to xls";
    private Composite parent;
    private TreeViewer browser;
    private Combo projectSelector;
    private Button refresh;
    private Button export;
    private MetricData data;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout());
        Composite head = new Composite(parent, 0);
        Tree inner = new Tree(parent, 4);
        this.browser = new TreeViewer(inner);
        this.browser.setContentProvider((IContentProvider)new ContentProvider());
        this.browser.setInput(null);
        this.createHead(head);
        this.createTree(inner);
        this.addDoubleClickListener(this.browser);
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    private void refreshData() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MetricsView.this.browser == null) {
                    return;
                }
                MetricsView.this.browser.setInput((Object)MetricsView.this.data);
                MetricsView.this.browser.setContentProvider((IContentProvider)new ContentProvider());
                MetricsView.this.browser.setLabelProvider((IBaseLabelProvider)new LabelProvider(MetricsView.this.data));
                MetricsView.this.browser.setComparator((ViewerComparator)new Sorter(MetricsView.this.data));
            }
        });
    }

    private void createHead(Composite head) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        head.setLayout((Layout)layout);
        GridData g = new GridData(-1, 25);
        g.grabExcessHorizontalSpace = true;
        g.horizontalAlignment = 4;
        head.setLayoutData((Object)g);
        this.projectSelector = new Combo(head, 8);
        for (IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!TITANNature.hasTITANNature((IProject)project)) continue;
            this.projectSelector.add(project.getName());
        }
        this.projectSelector.select(0);
        g = new GridData();
        g.horizontalAlignment = 4;
        g.grabExcessHorizontalSpace = true;
        this.projectSelector.setLayoutData((Object)g);
        this.refresh = new Button(head, 0);
        this.refresh.setImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.titanium", (String)"resources/icons/metrics_start_measure.gif").createImage());
        this.refresh.setToolTipText(REFRESH_TOOLTIP);
        this.refresh.setLayoutData((Object)new GridData(-1, 25));
        this.refresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String selectedProjectName = MetricsView.this.projectSelector.getText();
                if ("".equals(selectedProjectName)) {
                    MetricsView.this.data = null;
                    MetricsView.this.refreshData();
                    return;
                }
                MetricsView.this.refresh.setEnabled(false);
                final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(selectedProjectName);
                if (project == null) {
                    MetricsView.this.data = null;
                    MetricsView.this.refreshData();
                    return;
                }
                new ProjectAnalyzerJob("Metrics calculations"){

                    @Override
                    public IStatus doPostWork(IProgressMonitor monitor) {
                        IStatus iStatus;
                        try {
                            MetricsView.this.data = MetricData.measure(project);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MetricsView.this.refreshData();
                                    MetricsView.this.export.setEnabled(true);
                                }
                            });
                            iStatus = Status.OK_STATUS;
                        }
                        catch (Throwable throwable) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MetricsView.this.refresh.setEnabled(true);
                                }
                            });
                            throw throwable;
                        }
                        Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                        return iStatus;
                    }
                }.quickSchedule(project);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createExportToXlsButton(head);
        IResourceChangeListener PROJECT_CLOSE_LISTENER = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        final IResource resource = event.getResource();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (MetricsView.this.projectSelector == null || MetricsView.this.projectSelector.isDisposed()) {
                                    return;
                                }
                                MetricsView.this.projectSelector.deselectAll();
                                MetricsView.this.projectSelector.removeAll();
                                for (IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                                    if (project.equals(resource.getProject()) || !TITANNature.hasTITANNature((IProject)project)) continue;
                                    MetricsView.this.projectSelector.add(project.getName());
                                }
                                MetricsView.this.data = null;
                                MetricsView.this.refreshData();
                            }
                        });
                        break;
                    }
                }
            }
        };
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(PROJECT_CLOSE_LISTENER);
    }

    private void createExportToXlsButton(Composite head) {
        this.export = new Button(head, 0);
        this.export.setImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.titanium", (String)"resources/icons/metrics_export_csv.gif").createImage());
        this.export.setToolTipText(EXPORT_TOOLTIP);
        this.export.setEnabled(false);
        this.export.setLayoutData((Object)new GridData(-1, 25));
        this.export.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RiskLevel r = new ExportSetDialog(MetricsView.this.parent.getDisplay()).open();
                if (r == null) {
                    return;
                }
                FileDialog d = new FileDialog(MetricsView.this.parent.getShell(), 8192);
                d.setText("Export metric results to xls");
                d.setFilterExtensions(new String[]{"*.xls"});
                Calendar now = Calendar.getInstance();
                d.setFileName(MetricsView.this.projectSelector.getText() + "--" + now.get(1) + "-" + (1 + now.get(2)) + "-" + now.get(5));
                String fn = d.open();
                if (fn == null) {
                    return;
                }
                File file = new File(fn);
                XLSExporter xlsWriter = new XLSExporter(MetricsView.this.data);
                xlsWriter.setFile(file);
                xlsWriter.write(r);
            }
        });
    }

    private void createTree(Tree inner) {
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        inner.setLayoutData((Object)gd);
        inner.setHeaderVisible(true);
        inner.setLinesVisible(true);
        EnumMap<StatColumn, TreeColumn> columns = new EnumMap<StatColumn, TreeColumn>(StatColumn.class);
        TreeColumn names = new TreeColumn(inner, 16384);
        names.setAlignment(16384);
        names.setText(COLUMN_HEADER_1);
        names.setWidth(250);
        for (StatColumn col : StatColumn.values()) {
            TreeColumn c = new TreeColumn(inner, 131072);
            c.setAlignment(ALIGNMENTS.get((Object)col).intValue());
            c.setText(col.getName());
            c.setWidth(100);
            columns.put(col, c);
        }
    }

    private void addDoubleClickListener(TreeViewer browser) {
        browser.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object o = ((IStructuredSelection)selection).getFirstElement();
                if (!(o instanceof IOpenable)) {
                    return;
                }
                Location loc = ((IOpenable)o).getLocation();
                LocationHighlighter.jumpToLocation(loc);
            }
        });
    }

    public void setSelectedProject(IProject project) {
        String name = project.getName();
        int found = -1;
        for (int index = 0; index < this.projectSelector.getItemCount(); ++index) {
            if (!name.equals(this.projectSelector.getItem(index))) continue;
            found = index;
            break;
        }
        if (found >= 0) {
            this.projectSelector.select(found);
        }
    }

    public void startMeasuring() {
        this.refresh.notifyListeners(13, new Event());
    }

    static {
        ALIGNMENTS.put(StatColumn.TOTAL, 0x1000000);
        ALIGNMENTS.put(StatColumn.MAX, 0x1000000);
        ALIGNMENTS.put(StatColumn.MEAN, 16384);
        ALIGNMENTS.put(StatColumn.DEV, 16384);
    }
}

