/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.view;

import java.util.ArrayList;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.StatColumn;
import org.eclipse.titanium.metrics.Statistics;
import org.eclipse.titanium.metrics.TestcaseMetric;
import org.eclipse.titanium.metrics.utils.RiskLevel;
import org.eclipse.titanium.metrics.view.AltstepNode;
import org.eclipse.titanium.metrics.view.FunctionNode;
import org.eclipse.titanium.metrics.view.IContentNode;
import org.eclipse.titanium.metrics.view.IOpenable;
import org.eclipse.titanium.metrics.view.TestcaseNode;

class ModuleStatNode
implements IContentNode,
IOpenable {
    private final Module module;
    private final IMetricEnum metric;
    private boolean initialized;
    private Object[] children;

    public ModuleStatNode(IMetricEnum metric, Module module) {
        this.metric = metric;
        this.module = module;
        this.initialized = false;
    }

    @Override
    public Location getLocation() {
        return this.module.getLocation();
    }

    @Override
    public Object[] getChildren(MetricData data) {
        if (this.initialized) {
            return this.children;
        }
        ArrayList<IOpenable> c = new ArrayList<IOpenable>();
        if (this.metric instanceof FunctionMetric) {
            for (Def_Function f : data.getFunctions().get(this.module)) {
                c.add(new FunctionNode((FunctionMetric)this.metric, f));
            }
        } else if (this.metric instanceof TestcaseMetric) {
            for (Def_Testcase t : data.getTestcases().get(this.module)) {
                c.add(new TestcaseNode((TestcaseMetric)this.metric, t));
            }
        } else if (this.metric instanceof AltstepMetric) {
            for (Def_Altstep a : data.getAltsteps().get(this.module)) {
                c.add(new AltstepNode((AltstepMetric)this.metric, a));
            }
        } else {
            throw new AssertionError((Object)"ModuleStatNode should have a subModule-metric");
        }
        this.children = c.toArray();
        this.initialized = true;
        return this.children;
    }

    @Override
    public boolean hasChildren(MetricData data) {
        if (!this.initialized) {
            this.getChildren(data);
        }
        return this.children.length != 0;
    }

    @Override
    public RiskLevel getRiskLevel(MetricData data) {
        if (this.metric instanceof AltstepMetric) {
            return data.getRisk((AltstepMetric)this.metric, this.module);
        }
        if (this.metric instanceof FunctionMetric) {
            return data.getRisk((FunctionMetric)this.metric, this.module);
        }
        if (this.metric instanceof TestcaseMetric) {
            return data.getRisk((TestcaseMetric)this.metric, this.module);
        }
        throw new AssertionError((Object)"ModuleStatNode should have a subModule-metric");
    }

    @Override
    public double risk(MetricData data) {
        if (this.metric instanceof AltstepMetric) {
            return data.getRiskValue((AltstepMetric)this.metric, this.module);
        }
        if (this.metric instanceof FunctionMetric) {
            return data.getRiskValue((FunctionMetric)this.metric, this.module);
        }
        if (this.metric instanceof TestcaseMetric) {
            return data.getRiskValue((TestcaseMetric)this.metric, this.module);
        }
        throw new AssertionError((Object)"ModuleStatNode should have a subModule-metric");
    }

    @Override
    public String getColumnText(MetricData data, int i) {
        Statistics stat;
        if (i == 0) {
            return this.module.getName();
        }
        StatColumn c = null;
        switch (i) {
            case 1: {
                c = StatColumn.TOTAL;
                break;
            }
            case 2: {
                c = StatColumn.MAX;
                break;
            }
            case 3: {
                c = StatColumn.MEAN;
                break;
            }
            case 4: {
                c = StatColumn.DEV;
                break;
            }
            default: {
                return null;
            }
        }
        if (this.metric instanceof AltstepMetric) {
            stat = data.getStatistics((AltstepMetric)this.metric, this.module);
        } else if (this.metric instanceof FunctionMetric) {
            stat = data.getStatistics((FunctionMetric)this.metric, this.module);
        } else if (this.metric instanceof TestcaseMetric) {
            stat = data.getStatistics((TestcaseMetric)this.metric, this.module);
        } else {
            throw new AssertionError((Object)"ModuleStatNode should have a subModule-metric");
        }
        Number n = stat.get(c);
        return n == null ? null : n.toString();
    }
}

