/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.preferences.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.markers.handler.MarkerHandler;
import org.eclipse.titanium.markers.utils.Analyzer;
import org.eclipse.titanium.markers.utils.AnalyzerCache;
import org.eclipse.titanium.preferences.PreferenceConstants;
import org.eclipse.titanium.preferences.ProblemTypePreference;
import org.eclipse.titanium.preferences.pages.CustomExpansionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public final class MarkersPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String REPORT_TOO_COMPLEX_EXPRESSIONS_SIZE = "The amount of operators that should not be exceed";
    private static final String REPORT_TOO_MANY_PARAMETERS_SIZE = "The size the amount of parameters should not exceed";
    private static final String REPORT_TOO_MANY_STATEMENTS_SIZE = "The size the amount of statements should not exceed";
    private static final String REPORT_TOO_MANY_CONSECUTIVE_ASSIGNMENTS_SIZE = "The number of consecutive assignment statements should not exceed";
    private static final String ON_THE_FLY = "Check code smells on-the-fly";
    private static final String ON_THE_FLY_TOOLTIP = "When checked, analysis for code smells will run each time after a sematic analysis.\nNote that enabling on-the-fly analysis on the TITAN preference page is required.";
    private static final String DESCRIPTION = "Preferences on reporting code smells";
    private static final String REPORT_DEFINITION_NAME_TOO_LONG_LENGTH = "The length of the definition name shoud not exceed";
    private static final String[][] IGNORE_WARNING_ERROR = new String[][]{{"Ignore", "ignore"}, {"Warning", "warning"}, {"Error", "error"}};
    private static final Map<ProblemTypePreference, String> TOOLTIP_MAPPING;
    private final FontRegistry fonts = new FontRegistry();
    private final List<ComboFieldEditor> editors = new ArrayList<ComboFieldEditor>();
    private boolean changed = false;

    public MarkersPreferencePage() {
        super(1);
    }

    protected Control createContents(Composite parent) {
        Composite pagecomp = new Composite(parent, 0);
        pagecomp.setLayout((Layout)new GridLayout(1, true));
        pagecomp.setLayoutData((Object)new GridData(1040));
        return super.createContents(pagecomp);
    }

    protected void createFieldEditors() {
        Composite tempParent = new Composite(this.getFieldEditorParent(), 0);
        tempParent.setLayout((Layout)new GridLayout(1, true));
        Group top = new Group(tempParent, 16);
        top.setText("On-the-fly check");
        top.setLayoutData((Object)new GridData(768));
        top.setLayout((Layout)new FillLayout(512));
        BooleanFieldEditor b1 = new BooleanFieldEditor("CODE_SMELL.ON_THE_FLY_SMELLS", ON_THE_FLY, 1, (Composite)top);
        b1.getLabelControl((Composite)top).setToolTipText(ON_THE_FLY_TOOLTIP);
        this.addField((FieldEditor)b1);
        ExpandableComposite sec = new ExpandableComposite(tempParent, 18);
        sec.setText("Potential Structural problems");
        sec.setFont(this.fonts.getBold(""));
        Composite comp = new Composite((Composite)sec, 0);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)new FillLayout(512));
        this.createField(comp, ProblemTypePreference.GOTO);
        this.createField(comp, ProblemTypePreference.PRIVATE_COMPONENT_VARIABLE_ACCESS);
        this.createField(comp, ProblemTypePreference.INVOKING_FUNCTIONS_FROM_SPECIFIC_PLACES);
        this.createField(comp, ProblemTypePreference.CIRCULAR_IMPORTATION);
        this.createField(comp, ProblemTypePreference.LANGUAGE_MIXING);
        this.createField(comp, ProblemTypePreference.MISSING_IMPORT);
        this.createField(comp, ProblemTypePreference.UNUSED_IMPORT);
        this.createField(comp, ProblemTypePreference.MISSING_FRIEND);
        this.createField(comp, ProblemTypePreference.NONPRIVATE_PRIVATE);
        this.createField(comp, ProblemTypePreference.PRIVATE_FIELD_VIA_PUBLIC);
        this.createField(comp, ProblemTypePreference.PRIVATE_VALUE_VIA_PUBLIC);
        this.createField(comp, ProblemTypePreference.VISIBILITY_IN_DEFINITION);
        this.createField(comp, ProblemTypePreference.RUNS_ON_SCOPE_REDUCTION);
        this.createField(comp, ProblemTypePreference.CONNECTION_DETECTOR);
        sec.addExpansionListener((IExpansionListener)new CustomExpansionListener(comp));
        sec.setClient((Control)comp);
        sec.setExpanded(true);
        sec = new ExpandableComposite(tempParent, 18);
        sec.setText("Code style problems");
        sec.setFont(this.fonts.getBold(""));
        comp = new Composite((Composite)sec, 0);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)new FillLayout(512));
        this.createField(comp, ProblemTypePreference.DEFINITION_NAME_TOO_LONG);
        this.createIntegerEditor(comp, PreferenceConstants.DEFINITION_NAME_TOO_LONG_LENGTH, REPORT_DEFINITION_NAME_TOO_LONG_LENGTH);
        this.createField(comp, ProblemTypePreference.LOGIC_INVERSION);
        this.createField(comp, ProblemTypePreference.MODULENAME_IN_DEFINITION);
        this.createField(comp, ProblemTypePreference.TYPENAME_IN_DEFINITION);
        this.createField(comp, ProblemTypePreference.MAGIC_CONSTANTS);
        this.createField(comp, ProblemTypePreference.DUPLICATE_NAME);
        this.createField(comp, ProblemTypePreference.OVERRIDE_IN_ATTRIBUTES);
        sec.addExpansionListener((IExpansionListener)new CustomExpansionListener(comp));
        sec.setClient((Control)comp);
        sec.setExpanded(false);
        sec = new ExpandableComposite(tempParent, 18);
        sec.setText("Potential performance problems");
        sec.setFont(this.fonts.getBold(""));
        comp = new Composite((Composite)sec, 0);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)new FillLayout(512));
        this.createField(comp, ProblemTypePreference.INFINITE_LOOP);
        this.createField(comp, ProblemTypePreference.UNNECESSARY_ARRAYS);
        this.createField(comp, ProblemTypePreference.UNINITIALIZED_VARIABLE);
        this.createField(comp, ProblemTypePreference.SIZECHECK_IN_LOOP);
        this.createField(comp, ProblemTypePreference.CONSECUTIVE_ASSIGNMENTS);
        this.createIntegerEditor(comp, PreferenceConstants.TOO_MANY_CONSECUTIVE_ASSIGNMENTS_SIZE, REPORT_TOO_MANY_CONSECUTIVE_ASSIGNMENTS_SIZE);
        this.createField(comp, ProblemTypePreference.LAZY);
        sec.addExpansionListener((IExpansionListener)new CustomExpansionListener(comp));
        sec.setClient((Control)comp);
        sec.setExpanded(false);
        sec = new ExpandableComposite(tempParent, 18);
        sec.setText("Potential programming problems");
        sec.setFont(this.fonts.getBold(""));
        comp = new Composite((Composite)sec, 0);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)new FillLayout(512));
        this.createField(comp, ProblemTypePreference.READONLY_VARIABLE);
        this.createField(comp, ProblemTypePreference.TOO_MANY_PARAMETERS);
        this.createIntegerEditor(comp, PreferenceConstants.TOO_MANY_PARAMETERS_SIZE, REPORT_TOO_MANY_PARAMETERS_SIZE);
        this.createField(comp, ProblemTypePreference.TOO_COMPLEX_EXPRESSIONS);
        this.createIntegerEditor(comp, PreferenceConstants.TOO_COMPLEX_EXPRESSIONS_SIZE, REPORT_TOO_COMPLEX_EXPRESSIONS_SIZE);
        this.createField(comp, ProblemTypePreference.EMPTY_STATEMENT_BLOCK);
        this.createField(comp, ProblemTypePreference.TOO_MANY_STATEMENTS);
        this.createIntegerEditor(comp, PreferenceConstants.TOO_MANY_STATEMENTS_SIZE, REPORT_TOO_MANY_STATEMENTS_SIZE);
        this.createField(comp, ProblemTypePreference.INCORRECT_SHIFT_ROTATE_SIZE);
        this.createField(comp, ProblemTypePreference.IF_WITHOUT_ELSE);
        this.createField(comp, ProblemTypePreference.IF_NOT_WITHOUT_ELSE);
        this.createField(comp, ProblemTypePreference.SWITCH_ON_BOOLEAN);
        this.createField(comp, ProblemTypePreference.SETVERDICT_WITHOUT_REASON);
        this.createField(comp, ProblemTypePreference.UNCOMMENTED_FUNCTION);
        this.createField(comp, ProblemTypePreference.STOP_IN_FUNCTION);
        this.createField(comp, ProblemTypePreference.UNUSED_FUNTION_RETURN_VALUES);
        this.createField(comp, ProblemTypePreference.STARTED_FUNCTION_WITH_OUT_INOUT_PARAMETERS);
        this.createField(comp, ProblemTypePreference.RECEIVE_ANY_TEMPLATE);
        this.createField(comp, ProblemTypePreference.ALTSTEP_COVERAGE);
        this.createField(comp, ProblemTypePreference.IF_INSTEAD_ALTGUARD);
        this.createField(comp, ProblemTypePreference.IF_INSTEAD_RECEIVE_TEMPLATE);
        this.createField(comp, ProblemTypePreference.SHORTHAND);
        this.createField(comp, ProblemTypePreference.ISBOUND_WITHOUT_ELSE);
        this.createField(comp, ProblemTypePreference.CONVERT_TO_ENUM);
        this.createField(comp, ProblemTypePreference.SELECT_COVERAGE);
        this.createField(comp, ProblemTypePreference.SELECT_UNION);
        this.createField(comp, ProblemTypePreference.SELECT_WITH_NUMBERS_SORTED);
        this.createField(comp, ProblemTypePreference.ISVALUE_WITH_VALUE);
        this.createField(comp, ProblemTypePreference.ITERATE_ON_WRONG_ARRAY);
        this.createField(comp, ProblemTypePreference.READING_OUT_PAR_BEFORE_WRITTEN);
        this.createField(comp, ProblemTypePreference.GROUPS_WITHOUT_ATTRIBUTES);
        sec.addExpansionListener((IExpansionListener)new CustomExpansionListener(comp));
        sec.setClient((Control)comp);
        sec.setExpanded(false);
        sec = new ExpandableComposite(tempParent, 18);
        sec.setText("Unnecessary code");
        sec.setFont(this.fonts.getBold(""));
        comp = new Composite((Composite)sec, 0);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)new FillLayout(512));
        this.createField(comp, ProblemTypePreference.UNUSED_GLOBAL_DEFINITION);
        this.createField(comp, ProblemTypePreference.UNUSED_LOCAL_DEFINITION);
        this.createField(comp, ProblemTypePreference.UNNECESSARY_CONTROLS);
        this.createField(comp, ProblemTypePreference.UNNECESSARY_VALUEOF);
        sec.addExpansionListener((IExpansionListener)new CustomExpansionListener(comp));
        sec.setClient((Control)comp);
        sec.setExpanded(false);
    }

    private void createIntegerEditor(Composite comp, String name, String labelText) {
        IntegerFieldEditor temp = new IntegerFieldEditor(name, labelText, comp);
        temp.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                MarkersPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)temp);
    }

    private void createField(Composite comp, ProblemTypePreference type) {
        ComboFieldEditor comboedit = new ComboFieldEditor(type.getPreferenceName(), type.getDescription(), IGNORE_WARNING_ERROR, comp);
        comboedit.getLabelControl(comp).setToolTipText(TOOLTIP_MAPPING.get((Object)type));
        comboedit.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                MarkersPreferencePage.this.changed = true;
            }
        });
        this.addField((FieldEditor)comboedit);
        this.editors.add(comboedit);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.changed = true;
        super.propertyChange(event);
    }

    public void performApply() {
        super.performOk();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.changed) {
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)"Code smell markers", (String)"Settings of the code smell analyzer have changed, the known projects have to be re-analyzed completly.\nThis might take some time.");
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            final Analyzer analyzer = AnalyzerCache.withPreference();
            for (final IProject project : projects) {
                if (!TITANNature.hasTITANNature((IProject)project)) continue;
                WorkspaceJob op = new WorkspaceJob("Code smells"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        MarkerHandler mh;
                        IProject iProject = project;
                        synchronized (iProject) {
                            mh = analyzer.analyzeProject(monitor, project);
                        }
                        mh.showAll(project);
                        return Status.OK_STATUS;
                    }
                };
                op.setPriority(20);
                op.setSystem(false);
                op.setUser(true);
                op.schedule();
            }
        }
        return result;
    }

    static {
        EnumMap<ProblemTypePreference, String> m = new EnumMap<ProblemTypePreference, String>(ProblemTypePreference.class);
        m.put(ProblemTypePreference.ALTSTEP_COVERAGE, "Through it is not strictly necessary, it recommendable for an altstep to handle any possible incoming message types");
        m.put(ProblemTypePreference.CIRCULAR_IMPORTATION, "Circular importation is not prohibited in TTCN-3, but it is also not recommended.");
        m.put(ProblemTypePreference.LANGUAGE_MIXING, "Mixing modules with different language versions in the same project is a sign of architectural problems as it can lead to missunderstandings/unexpected behaviours/aged design.\nit is always recommended to adapt TTCN-3 source code to the newest version of the standard.");
        m.put(ProblemTypePreference.CONSECUTIVE_ASSIGNMENTS, "Consecutive assignments should be merged due to performance issues");
        m.put(ProblemTypePreference.CONVERT_TO_ENUM, "Select statements should be used with enumerations. Branch coverage can not \nbe calculated on integers.");
        m.put(ProblemTypePreference.EMPTY_STATEMENT_BLOCK, "Empty statement blocks in the source code usually means,\nthat the developer planned to write some code there to handle some use cases,\nbut forgot to finish his work ... or is right now in the process of finishing it");
        m.put(ProblemTypePreference.DEFINITION_NAME_TOO_LONG, "The definition name you have defined is too long");
        m.put(ProblemTypePreference.GOTO, "In almost all cases the usage of goto should be forbidden as it can very easily breaks the principles of structured/well designed source code.");
        m.put(ProblemTypePreference.PRIVATE_COMPONENT_VARIABLE_ACCESS, "The access of a private component variable from an another module is not recommended.");
        m.put(ProblemTypePreference.DUPLICATE_NAME, "In almost all cases the usage of same name is discouraged as it can introduce confusion in structured/well designed source code.");
        m.put(ProblemTypePreference.IF_INSTEAD_ALTGUARD, "When an alt branch begins with an if statement, it should be considered whether it might be changed to an alt guard");
        m.put(ProblemTypePreference.IF_INSTEAD_RECEIVE_TEMPLATE, "When an alt branch has an if statement, where the condition is a matching to the received value, it might be a better idea to split to multiple branch, each with different template matching in the receive statements.");
        m.put(ProblemTypePreference.IF_WITHOUT_ELSE, "All possible execution paths should be handled, atleast on the level of logging information in case of unexpected events");
        m.put(ProblemTypePreference.IF_NOT_WITHOUT_ELSE, "All possible execution paths should be handled, atleast on the level of logging information in case of unexpected events");
        m.put(ProblemTypePreference.INCORRECT_SHIFT_ROTATE_SIZE, "Report too big (bigger than the string itself) or too small (negative) shift and rotation sizes.");
        m.put(ProblemTypePreference.INFINITE_LOOP, "When there is no way to escape the loop");
        m.put(ProblemTypePreference.ISBOUND_WITHOUT_ELSE, "In test systems it is valuable to log some information in the\n else branch on why it failed the test when using isbound/ispresent/ischosen");
        m.put(ProblemTypePreference.ISVALUE_WITH_VALUE, "Isvalue check on value always returns true. 'isbound' should be\nused to check existence. ");
        m.put(ProblemTypePreference.ITERATE_ON_WRONG_ARRAY, "The loop parameter might be used to index the wrong list.");
        m.put(ProblemTypePreference.INVOKING_FUNCTIONS_FROM_SPECIFIC_PLACES, "When a function invoking or state checking is not safe during a snapshot.");
        m.put(ProblemTypePreference.MAGIC_CONSTANTS, "It is always recommended to extract local literal values into constants and use the constants in the code.\nSince otherwise sooner or later it will be forgotten what that exact value was meaning");
        m.put(ProblemTypePreference.MISSING_FRIEND, "When the module referred to in a friend declaration could not be found..");
        m.put(ProblemTypePreference.MISSING_IMPORT, "When a module referred to in an import statement could not be found.");
        m.put(ProblemTypePreference.MODULENAME_IN_DEFINITION, "As definitions can be referenced in the modulename.identifier format, it is of no value if the name of the module is duplicated in the name of the definition\nBut makes it longer");
        m.put(ProblemTypePreference.LAZY, "When an in parameter evaluation not sure under code execution it should be a @lazy parameter, otherwise not.");
        m.put(ProblemTypePreference.LOGIC_INVERSION, "When an if statement has negated condition, and consists only an if- and an else branch, the negation can be left simply by swapping the two branches.");
        m.put(ProblemTypePreference.NONPRIVATE_PRIVATE, "By default all definitions are public, but by declaring some private one can make them invisible for importing modules.\nThis might be usefull in case of internal functions, types, constants");
        m.put(ProblemTypePreference.PRIVATE_FIELD_VIA_PUBLIC, "It is able to find references, fields pointing to types, that otherwise should be invisible for the actual module.");
        m.put(ProblemTypePreference.PRIVATE_VALUE_VIA_PUBLIC, "It is able to find parametrized values, that pointing to types, that otherwise should be invisible for the actual module.");
        m.put(ProblemTypePreference.READING_OUT_PAR_BEFORE_WRITTEN, "An out parameter is read before a value is assigned to it.");
        m.put(ProblemTypePreference.READONLY_VARIABLE, "When a definition was declared to be changeable, but is never modified");
        m.put(ProblemTypePreference.SELECT_COVERAGE, "When using a select statement with enumeration type, all the possible \nenumeration values should be handled in the select statement");
        m.put(ProblemTypePreference.SELECT_UNION, "When using a select statement with union type, consider it to use the\nnew select union statement");
        m.put(ProblemTypePreference.SELECT_WITH_NUMBERS_SORTED, "When using a select statement with integer value type, the \ncases should be incremental ordered.");
        m.put(ProblemTypePreference.SETVERDICT_WITHOUT_REASON, "Setting any other verdict reason then pass, should be accompanied with a reason, with details for the verdict");
        m.put(ProblemTypePreference.SIZECHECK_IN_LOOP, "The loop condition is evaluated at the end of each loop\nIt is therefore better performance wise to check it only once and save this value in a constant if possible");
        m.put(ProblemTypePreference.RECEIVE_ANY_TEMPLATE, "Report when a branch of an altstep uses receive action with a template matching to all possible values");
        m.put(ProblemTypePreference.SHORTHAND, "Some shorthand statements (timeout, receive, ...) should not be used in \nfunctions/altsteps/testcases with a 'runs on' clause; an activated default can change their behaviour");
        m.put(ProblemTypePreference.STOP_IN_FUNCTION, "The testcase stopping stop operation stops execution immediatelly\nWhich can leave behind garbage in the test system, and the SUT in any state");
        m.put(ProblemTypePreference.SWITCH_ON_BOOLEAN, "In this case 'if' conditionals would be nmore effective");
        m.put(ProblemTypePreference.TOO_COMPLEX_EXPRESSIONS, "The more complex an expression is, the less likely it is to be correct");
        m.put(ProblemTypePreference.TOO_MANY_PARAMETERS, "The more parameters some entity has, the harder it becomes to fill them out correctly without introducing faults");
        m.put(ProblemTypePreference.TOO_MANY_STATEMENTS, "Rationale: If a statement block becomes very long it is hard to understand. Therefore long statemen tblocks should usually be refactored into several individual ones, or into individual functions that focus on a specific task. ");
        m.put(ProblemTypePreference.TYPENAME_IN_DEFINITION, "As the comment and hover can display the type of the definition, it is of no value if it is duplicated in the name of the definition\nBut makes it longer");
        m.put(ProblemTypePreference.UNCOMMENTED_FUNCTION, "Functions, altsteps and testcases should have a header comment describing what and why they do");
        m.put(ProblemTypePreference.UNINITIALIZED_VARIABLE, "Initializing variables at declaration time is better performance wise, than assigning a value later");
        m.put(ProblemTypePreference.UNNECESSARY_CONTROLS, "Report controls that can be identified to be unnecessary in compilation time.\nFor example when the conditional expression of an if statements evaluates to false in compilation time.");
        m.put(ProblemTypePreference.UNNECESSARY_ARRAYS, "Report when arrays are used in code.");
        m.put(ProblemTypePreference.UNNECESSARY_VALUEOF, "Report when 'valueof' is applied to an actual value, thus having no effect");
        m.put(ProblemTypePreference.UNUSED_FUNTION_RETURN_VALUES, "When a function returns a value or a template, but it is not used.");
        m.put(ProblemTypePreference.STARTED_FUNCTION_WITH_OUT_INOUT_PARAMETERS, "Starting functions with out or inout parameters.");
        m.put(ProblemTypePreference.UNUSED_GLOBAL_DEFINITION, "When a module level definition is never read/written.\n Also when a type is not used to declare other definitions.");
        m.put(ProblemTypePreference.UNUSED_IMPORT, "When nothing is used in the module from the imported module.");
        m.put(ProblemTypePreference.UNUSED_LOCAL_DEFINITION, "When a local variable or formal parameter is never read/written.");
        m.put(ProblemTypePreference.VISIBILITY_IN_DEFINITION, "Visibility attributes should not be mentioned in the names of the definitions\nThey should be explicitly set as visibility attributes of the definition");
        m.put(ProblemTypePreference.RUNS_ON_SCOPE_REDUCTION, "When runs on component is never used.");
        m.put(ProblemTypePreference.GROUPS_WITHOUT_ATTRIBUTES, "Groups without attributes might indicate design issues.");
        m.put(ProblemTypePreference.CONNECTION_DETECTOR, "When out messages list of port is empty");
        m.put(ProblemTypePreference.OVERRIDE_IN_ATTRIBUTES, "Runs when attributes are being overridden");
        TOOLTIP_MAPPING = Collections.unmodifiableMap(m);
    }
}

