/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.insertfield;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.refactoring.insertfield.InsertFieldRefactoring;

public class InsertFieldWizardInputPage
extends UserInputWizardPage {
    private static final String INVALIDNAME = "Name is not valid. ";
    private static final String NAMEEXISTS = "Name already exists. ";
    private static final String NEGATIVEPOSITION = "Position must be at least 0. ";
    private static final String NOTNUMBERPOSITION = "Position must be a number. ";
    private static final String INVALIDUPPERBOUNDPOSITION = "Position must be between 0 and %d. ";
    private static final String TYPEMANDATORY = "Type is mandatory. ";
    private static final String VALUEMANDATORY = "Value is mandatory. ";
    private final InsertFieldRefactoring.Settings settings;
    private final Definition selection;
    private Text positionField;
    private Text typeField;
    private Text nameField;
    private Text valueField;
    private String positionErrorMessage = "";
    private String nameErrorMessage = "";
    private String typeErrorMessage = "";
    private String valueErrorMessage = "";
    private boolean posDone = false;
    private boolean nameDone = false;
    private boolean typeDone = false;
    private boolean valueDone = false;

    InsertFieldWizardInputPage(String name, InsertFieldRefactoring.Settings settings, Definition selection) {
        super(name);
        this.settings = settings;
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.initializeDialogUnits((Control)top);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout(2, false));
        Label positionLabel = new Label(top, 0);
        positionLabel.setText("Position (0, 1, ...): ");
        this.positionField = new Text(top, 0);
        this.positionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertFieldWizardInputPage.this.checkPosition();
            }
        });
        Label typeLabel = new Label(top, 0);
        typeLabel.setText("Type: ");
        this.typeField = new Text(top, 0);
        this.typeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertFieldWizardInputPage.this.checkType();
            }
        });
        Label nameLabel = new Label(top, 0);
        nameLabel.setText("Name: ");
        this.nameField = new Text(top, 0);
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertFieldWizardInputPage.this.checkName();
            }
        });
        Label valueLabel = new Label(top, 0);
        valueLabel.setText("Value: ");
        this.valueField = new Text(top, 0);
        this.valueField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertFieldWizardInputPage.this.checkValue();
            }
        });
        this.setPageComplete(false);
        this.setErrorMessage(null);
    }

    public void checkPosition() {
        try {
            this.settings.setPosition(Integer.parseInt(this.positionField.getText().trim()));
            IType type = this.selection.getType(CompilationTimeStamp.getBaseTimestamp());
            if (type instanceof TTCN3_Sequence_Type || type instanceof TTCN3_Set_Type) {
                TTCN3_Set_Seq_Choice_BaseType ss = (TTCN3_Set_Seq_Choice_BaseType)type;
                int noc = ss.getNofComponents();
                if (this.settings.getPosition() < 0) {
                    this.positionErrorMessage = NEGATIVEPOSITION;
                    this.posDone = false;
                } else if (this.settings.getPosition() > noc) {
                    this.positionErrorMessage = String.format(INVALIDUPPERBOUNDPOSITION, noc);
                    this.posDone = false;
                } else {
                    this.positionErrorMessage = "";
                    this.posDone = true;
                }
            }
        }
        catch (NumberFormatException ex) {
            this.positionErrorMessage = NOTNUMBERPOSITION;
            this.posDone = false;
        }
        this.setErrorMessage(this.positionErrorMessage + this.typeErrorMessage + this.nameErrorMessage + this.valueErrorMessage);
        this.setPageComplete(this.posDone && this.typeDone && this.nameDone && this.valueDone);
    }

    public void checkName() {
        Identifier id = new Identifier(Identifier.Identifier_type.ID_TTCN, this.nameField.getText().trim());
        this.settings.setId(id);
        if (!Identifier.isValidInTtcn((String)this.settings.getId().getName())) {
            this.nameErrorMessage = INVALIDNAME;
            this.nameDone = false;
        } else {
            IType type = this.selection.getType(CompilationTimeStamp.getBaseTimestamp());
            if (type instanceof TTCN3_Sequence_Type || type instanceof TTCN3_Set_Type) {
                TTCN3_Set_Seq_Choice_BaseType ss = (TTCN3_Set_Seq_Choice_BaseType)type;
                if (ss.hasComponentWithName(this.settings.getId().getName())) {
                    this.nameErrorMessage = NAMEEXISTS;
                    this.nameDone = false;
                } else {
                    this.nameErrorMessage = "";
                    this.nameDone = true;
                }
            }
        }
        this.setErrorMessage(this.positionErrorMessage + this.typeErrorMessage + this.nameErrorMessage + this.valueErrorMessage);
        this.setPageComplete(this.posDone && this.typeDone && this.nameDone && this.valueDone);
    }

    public void checkType() {
        this.settings.setType(this.typeField.getText().trim());
        if (this.settings.getType() == null || this.settings.getType().equals("")) {
            this.typeErrorMessage = TYPEMANDATORY;
            this.typeDone = false;
        } else {
            this.typeErrorMessage = "";
            this.typeDone = true;
        }
        this.setErrorMessage(this.positionErrorMessage + this.typeErrorMessage + this.nameErrorMessage + this.valueErrorMessage);
        this.setPageComplete(this.posDone && this.typeDone && this.nameDone && this.valueDone);
    }

    public void checkValue() {
        this.settings.setValue(this.valueField.getText().trim());
        if (this.settings.getValue() == null || this.settings.getValue().equals("")) {
            this.valueErrorMessage = VALUEMANDATORY;
            this.valueDone = false;
        } else {
            this.valueErrorMessage = "";
            this.valueDone = true;
        }
        this.setErrorMessage(this.positionErrorMessage + this.typeErrorMessage + this.nameErrorMessage + this.valueErrorMessage);
        this.setPageComplete(this.posDone && this.typeDone && this.nameDone && this.valueDone);
    }
}

