/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.statements.Log_Statement;
import org.eclipse.titanium.refactoring.logging.ContextLoggingRefactoring;
import org.eclipse.titanium.refactoring.logging.context.Context;
import org.eclipse.titanium.refactoring.logging.context.ContextFactory;

class ContextFinder
extends ASTVisitor {
    private final ContextLoggingRefactoring.Settings settings;
    private final ContextFactory factory;
    private final Deque<IVisitableNode> ancestorStack;
    private final Map<Log_Statement, Context> result;

    ContextFinder(ContextLoggingRefactoring.Settings settings) {
        this.settings = settings;
        this.factory = new ContextFactory();
        this.ancestorStack = new ArrayDeque<IVisitableNode>();
        this.result = new HashMap<Log_Statement, Context>();
    }

    public Map<Log_Statement, Context> getResult() {
        return this.result;
    }

    protected Context createContextChain() {
        Iterator<IVisitableNode> it = this.ancestorStack.iterator();
        Context prev = null;
        Context curr = null;
        if (it.hasNext()) {
            prev = this.factory.createContext(it.next(), null, this.settings);
        }
        while (it.hasNext()) {
            curr = this.factory.createContext(it.next(), prev, this.settings);
            curr.setChild(prev);
            prev.setParent(curr);
            prev = curr;
        }
        return curr;
    }

    public int visit(IVisitableNode node) {
        this.ancestorStack.addFirst(node);
        if (node instanceof Log_Statement) {
            if (this.settings.getSetting(32)) {
                this.result.put((Log_Statement)node, this.createContextChain());
            } else {
                LogStatementVisitor vis = new LogStatementVisitor();
                node.accept((ASTVisitor)vis);
                if (!vis.getResult()) {
                    this.result.put((Log_Statement)node, this.createContextChain());
                }
            }
        }
        return 3;
    }

    public int leave(IVisitableNode node) {
        if (this.ancestorStack.getFirst() == node) {
            this.ancestorStack.removeFirst();
        }
        return 3;
    }

    private static class LogStatementVisitor
    extends ASTVisitor {
        private boolean result = false;

        private LogStatementVisitor() {
        }

        private boolean getResult() {
            return this.result;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                this.result = true;
                return 2;
            }
            return 3;
        }
    }
}

