/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.extractors.TestCaseEvent;
import org.eclipse.titan.log.viewer.extractors.TestCaseExtractor;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.readers.CachedLogReader;
import org.eclipse.titan.log.viewer.readers.LogFileReader;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.LogFileHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.StatisticalView;
import org.eclipse.titan.log.viewer.views.details.StatisticalData;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenStatisticalViewMenuAction
extends AbstractHandler
implements IActionDelegate,
Observer {
    private IStructuredSelection selection;
    private IProgressMonitor monitor;
    private int lastWorked;
    private IFile logFile;
    private LogFileMetaData logFileMetaData;
    private boolean logFileIsSupported;
    private TestCaseExtractor testCaseExtractor = new TestCaseExtractor();

    public void run(IAction action) {
        this.run(this.selection);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection tempSelection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!(tempSelection instanceof IStructuredSelection)) {
            return null;
        }
        this.selection = (IStructuredSelection)tempSelection;
        this.run(this.selection);
        return null;
    }

    private void run(IStructuredSelection selection) {
        IWorkbenchPage activePage;
        IViewReference reference;
        this.logFileMetaData = null;
        this.logFileIsSupported = true;
        if (this.selection == null) {
            return;
        }
        HashSet<IFile> logFiles = new HashSet<IFile>(selection.size());
        for (Object object : selection) {
            if (object instanceof IFile) {
                logFiles.add((IFile)object);
                continue;
            }
            if (!(object instanceof TestCase)) continue;
            logFiles.add(((TestCase)object).getLogFile());
        }
        if (logFiles.isEmpty()) {
            return;
        }
        List<StatisticalData> statisticalDataVector = this.createStatisticalData(logFiles);
        if (statisticalDataVector == null || statisticalDataVector.isEmpty()) {
            return;
        }
        String secondId = "Statistical View";
        if (statisticalDataVector.size() < 2) {
            secondId = File.separator + this.logFile.getProject().getName() + File.separator + this.logFile.getProjectRelativePath().toOSString();
        }
        if ((reference = (activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findViewReference("org.eclipse.titan.log.viewer.views.StatisticalView", secondId)) != null) {
            StatisticalView statisticalView = (StatisticalView)reference.getView(false);
        }
        try {
            StatisticalView part = (StatisticalView)activePage.showView("org.eclipse.titan.log.viewer.views.StatisticalView", secondId, 1);
            part.setData(statisticalDataVector);
            part.setFocus();
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenStatisticalViewMenuAction.0") + e.getMessage()));
        }
    }

    private List<StatisticalData> createStatisticalData(Set<IFile> logFiles) {
        ArrayList<StatisticalData> statisticalDataVector = new ArrayList<StatisticalData>();
        Iterator<IFile> iterator = logFiles.iterator();
        while (iterator.hasNext()) {
            IFile file;
            this.logFile = file = iterator.next();
            if (!this.logFile.exists()) {
                TitanLogExceptionHandler.handleException(new UserException(Messages.getString("OpenStatisticalViewMenuAction.5")));
                return null;
            }
            File logRecordIndexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(this.logFile);
            File propertyFile = LogFileCacheHandler.getPropertyFileForLogFile(this.logFile);
            if (!logRecordIndexFile.exists() || !propertyFile.exists() || LogFileCacheHandler.hasLogFileChanged(this.logFile)) {
                this.processLogFile();
            } else {
                try {
                    this.logFileMetaData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
                    this.testCaseExtractor = new TestCaseExtractor();
                    this.testCaseExtractor.extractTestCasesFromIndexedLogFile(this.logFile);
                }
                catch (IOException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                    TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenStatisticalViewMenuAction.0") + e.getMessage()));
                }
                catch (ClassNotFoundException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                    TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenStatisticalViewMenuAction.0") + e.getMessage()));
                }
            }
            if (!this.logFileIsSupported) continue;
            try {
                if (this.logFileMetaData == null) {
                    this.logFileMetaData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
                }
                List<TestCase> testCases = this.testCaseExtractor.getTestCases();
                CachedLogReader reader = new CachedLogReader(LogFileReader.getReaderForLogFile(this.logFile));
                StatisticalData statisticalData = new StatisticalData(this.logFileMetaData, testCases, reader);
                statisticalDataVector.add(statisticalData);
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenStatisticalViewMenuAction.0") + e.getMessage()));
            }
            catch (ClassNotFoundException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenStatisticalViewMenuAction.0") + e.getMessage()));
            }
        }
        return statisticalDataVector;
    }

    private void processLogFile() {
        try {
            new ProgressMonitorDialog(null).run(false, false, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    OpenStatisticalViewMenuAction.this.monitor = monitor;
                    OpenStatisticalViewMenuAction.this.testCaseExtractor = null;
                    try {
                        LogFileHandler logFileHandler = new LogFileHandler(OpenStatisticalViewMenuAction.this.logFile);
                        try {
                            OpenStatisticalViewMenuAction.this.logFileMetaData = logFileHandler.autoDetect();
                        }
                        catch (TechnicalException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)e);
                            OpenStatisticalViewMenuAction.this.logFileIsSupported = false;
                            TitanLogExceptionHandler.handleException(new UserException(e.getMessage()));
                            if (OpenStatisticalViewMenuAction.this.testCaseExtractor != null) {
                                OpenStatisticalViewMenuAction.this.testCaseExtractor.deleteObserver(OpenStatisticalViewMenuAction.this);
                            }
                            if (OpenStatisticalViewMenuAction.this.monitor != null) {
                                OpenStatisticalViewMenuAction.this.monitor.done();
                            }
                            return;
                        }
                        OpenStatisticalViewMenuAction.this.testCaseExtractor = new TestCaseExtractor();
                        OpenStatisticalViewMenuAction.this.testCaseExtractor.addObserver(OpenStatisticalViewMenuAction.this);
                        if (OpenStatisticalViewMenuAction.this.monitor != null) {
                            OpenStatisticalViewMenuAction.this.monitor.beginTask(Messages.getString("OpenStatisticalViewMenuAction.4") + OpenStatisticalViewMenuAction.this.logFile.getName() + Messages.getString("OpenStatisticalViewMenuAction.3"), 100);
                        }
                        OpenStatisticalViewMenuAction.this.testCaseExtractor.extractTestCasesFromLogFile(OpenStatisticalViewMenuAction.this.logFileMetaData, monitor);
                        LogFileCacheHandler.fillCache(OpenStatisticalViewMenuAction.this.logFile, OpenStatisticalViewMenuAction.this.logFileMetaData, OpenStatisticalViewMenuAction.this.testCaseExtractor.getTestCases(), OpenStatisticalViewMenuAction.this.testCaseExtractor.getLogRecordIndexes());
                        if (OpenStatisticalViewMenuAction.this.testCaseExtractor.failedDuringExtraction()) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openInformation(null, (String)Messages.getString("OpenStatisticalViewMenuAction.2"), (String)Messages.getString("OpenStatisticalViewMenuAction.1"));
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                        TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenStatisticalViewMenuAction.0") + e.getMessage()));
                    }
                    finally {
                        if (OpenStatisticalViewMenuAction.this.testCaseExtractor != null) {
                            OpenStatisticalViewMenuAction.this.testCaseExtractor.deleteObserver(OpenStatisticalViewMenuAction.this);
                        }
                        if (OpenStatisticalViewMenuAction.this.monitor != null) {
                            OpenStatisticalViewMenuAction.this.monitor.done();
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenStatisticalViewMenuAction.0") + e.getTargetException()));
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenStatisticalViewMenuAction.0") + e.getMessage()));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.selection = (IStructuredSelection)selection;
        for (Object object : this.selection) {
            if (object instanceof IFile || object instanceof TestCase) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    @Override
    public void update(Observable observable, Object event) {
        if (event instanceof TestCaseEvent) {
            TestCaseEvent testCaseEvent = (TestCaseEvent)event;
            int worked = testCaseEvent.getProgress();
            if (this.monitor != null) {
                this.monitor.worked(worked - this.lastWorked);
            }
            this.lastWorked = worked;
        }
    }
}

