/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.extractors.TestCaseExtractor;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.models.TimeInterval;
import org.eclipse.titan.log.viewer.parsers.Parser;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.preferences.DecipheringPreferenceHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHolder;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.DetailsView;
import org.eclipse.titan.log.viewer.views.ILogViewerView;
import org.eclipse.titan.log.viewer.views.MSCFilterDialog;
import org.eclipse.titan.log.viewer.views.msc.model.ExecutionModel;
import org.eclipse.titan.log.viewer.views.msc.model.IEventObject;
import org.eclipse.titan.log.viewer.views.msc.model.MSCModel;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.JumpToNextSetverdictAction;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.JumpToPreviousSetverdictAction;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.OpenSourceAction;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.OpenTextTableAction;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.OpenValueViewAction;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.RefreshMSCViewAction;
import org.eclipse.titan.log.viewer.views.msc.ui.actions.ZoomAction;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Frame;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.view.MSCWidget;
import org.eclipse.titan.log.viewer.views.text.table.TextTableView;
import org.eclipse.titan.log.viewer.views.text.table.TextTableViewHelper;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.ViewPart;

public class MSCView
extends ViewPart
implements ILogViewerView {
    private MSCWidget mscWidget = null;
    private MenuManager menuMgr = null;
    private LogFileMetaData logFileMetaData = null;
    private ExecutionModel model;
    private IAction refresh;
    private IAction jumpToNextSetverdict;
    private IAction jumpToPreviousSetverdict;
    private OpenValueViewAction openValueView;
    private OpenValueViewAction silentOpenValueView;
    private IAction openTextTable;
    private OpenSourceAction openSource;
    private OpenSourceAction silentOpenSource;
    private IMemento memento;
    private boolean problemDuringRestore = false;
    private int restoredSelection;
    private final IAction filterAction = new Action(){

        public void run() {
            if (MSCView.this.model.getFilterPattern() != null) {
                MSCFilterDialog dialog = new MSCFilterDialog(MSCView.this.getSite().getShell(), MSCView.this.model.getFilterPattern());
                if (dialog.open() == 0 && dialog.getChanged() && !MSCView.this.model.getFilterPattern().equals(dialog.getFilterPattern())) {
                    MSCView.this.filterPattern = dialog.getFilterPattern();
                    MSCView.this.refresh.run();
                }
            } else {
                FilterPattern pattern = new FilterPattern(MSCView.this.loadEventsFromPreferences(), true, true);
                pattern.setTimeInterval(new TimeInterval("", "", MSCView.this.getLogFileMetaData().getTimeStampFormat()));
                MSCFilterDialog dialog = new MSCFilterDialog(MSCView.this.getSite().getShell(), pattern);
                if (dialog.open() == 0 && dialog.getChanged()) {
                    MSCView.this.filterPattern = dialog.getFilterPattern();
                    MSCView.this.refresh.run();
                }
            }
        }
    };
    private FilterPattern filterPattern;

    public MSCView() {
        this.filterAction.setImageDescriptor(Activator.getImageDescriptor("icons/filter2.gif"));
        this.filterAction.setText("Filter");
    }

    public void saveState(IMemento memento) {
        if (this.model == null) {
            return;
        }
        IMemento tempMemento = memento.createChild("mscview");
        try {
            IMemento viewAttributes = tempMemento.createChild("attributes");
            Path filePath = new Path(this.logFileMetaData.getProjectRelativePath());
            IFile logFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
            viewAttributes.putString("projectName", this.logFileMetaData.getProjectName());
            if (logFile != null && logFile.exists()) {
                viewAttributes.putString("propertyFile", LogFileCacheHandler.getPropertyFileForLogFile(logFile).getAbsolutePath());
                File aLogFile = logFile.getLocation().toFile();
                viewAttributes.putString("fileSize", String.valueOf(aLogFile.length()));
                viewAttributes.putString("fileModification", String.valueOf(aLogFile.lastModified()));
            }
            TestCase testCase = this.model.getTestCase();
            viewAttributes.putInteger("testCaseNumber", testCase.getTestCaseNumber());
            if (this.mscWidget != null && this.mscWidget.getFrame() != null) {
                viewAttributes.putInteger("rowSelection", this.mscWidget.getFrame().getSelectedLine());
            } else {
                viewAttributes.putInteger("rowSelection", 0);
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    private WorkspaceJob restoreState() {
        if (this.memento == null) {
            return null;
        }
        WorkspaceJob job = null;
        this.problemDuringRestore = true;
        this.memento = this.memento.getChild("mscview");
        if (this.memento != null) {
            try {
                File propertyFile;
                IMemento viewAttributes = this.memento.getChild("attributes");
                String propertyFilePath = viewAttributes.getString("propertyFile");
                if (propertyFilePath != null && (propertyFile = new File(propertyFilePath)).exists()) {
                    this.logFileMetaData = LogFileCacheHandler.logFileMetaDataReader(propertyFile);
                }
                String projectName = viewAttributes.getString("projectName");
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (this.logFileMetaData != null && project != null && project.exists() && project.isOpen()) {
                    Path path = new Path(this.logFileMetaData.getProjectRelativePath());
                    IFile logFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    if (logFile != null && logFile.exists() && logFile.getProject().getName().equals(project.getName())) {
                        File file;
                        String fileSizeString = viewAttributes.getString("fileSize");
                        long fileSize = 0L;
                        if (fileSizeString != null) {
                            fileSize = Long.parseLong(fileSizeString);
                        }
                        String fileModificationString = viewAttributes.getString("fileModification");
                        long fileModification = 0L;
                        if (fileModificationString != null) {
                            fileModification = Long.parseLong(fileModificationString);
                        }
                        if ((file = logFile.getLocation().toFile()).lastModified() == fileModification && file.length() == fileSize) {
                            File indexFileForLogFile = LogFileCacheHandler.getIndexFileForLogFile(logFile);
                            File logRecordIndexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile);
                            if (!indexFileForLogFile.exists() || !logRecordIndexFile.exists()) {
                                return null;
                            }
                            Integer testCaseNumber = viewAttributes.getInteger("testCaseNumber");
                            final Parser parser = new Parser(this.logFileMetaData);
                            final TestCase testCase = TestCaseExtractor.getTestCaseFromIndexFile(indexFileForLogFile, testCaseNumber);
                            final LogRecordIndex[] logRecordIndexes = LogFileCacheHandler.readLogRecordIndexFile(logRecordIndexFile, testCase.getStartRecordNumber(), testCase.getNumberOfRecords());
                            final PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(projectName);
                            job = new WorkspaceJob("Loading log information"){

                                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                    try {
                                        MSCView.this.model = parser.preParse(testCase, logRecordIndexes, preferences, null, monitor);
                                    }
                                    catch (Exception e) {
                                        ErrorReporter.logExceptionStackTrace((Exception)e);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                            Integer temp = viewAttributes.getInteger("rowSelection");
                            this.restoredSelection = temp == null ? 0 : temp;
                            this.problemDuringRestore = false;
                        }
                    }
                }
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        this.memento = null;
        return job;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.memento = memento;
    }

    public MSCWidget getMSCWidget() {
        return this.mscWidget;
    }

    public void setLogFileMetaData(LogFileMetaData logFileMetaData) {
        this.logFileMetaData = logFileMetaData;
    }

    public void setSelection(int recordNumber) {
        int positionInEventsVector = this.model.getRecordsPosition(recordNumber);
        if (positionInEventsVector == -1) {
            return;
        }
        int lineToSelect = positionInEventsVector + 2;
        this.mscWidget.setSelection((ISelection)new StructuredSelection((Object)lineToSelect));
    }

    public int getSelectedRecordNumber() {
        int selectedLine = (Integer)((IStructuredSelection)this.mscWidget.getSelection()).getFirstElement();
        IEventObject event = this.model.getEvent(selectedLine - 2);
        return event.getRecordNumber();
    }

    public void createPartControl(Composite c) {
        final WorkspaceJob job = this.restoreState();
        if (this.problemDuringRestore) {
            Label text = new Label(c, 16384);
            text.setText(Messages.getString("MSCView.0"));
            return;
        }
        Composite parent = new Composite(c, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 1;
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 0;
        parent.setLayout((Layout)parentLayout);
        GridData seqDiagLayoutData = new GridData(1808);
        this.mscWidget = new MSCWidget(parent, 0);
        this.mscWidget.setLayoutData(seqDiagLayoutData);
        this.mscWidget.setDragAutoScroll(false);
        this.mscWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 13) {
                    return;
                }
                PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(MSCView.this.logFileMetaData.getProjectName());
                int defaultBehaviour = preferences.getMscViewDefault();
                if (defaultBehaviour == 0) {
                    MSCView.this.openTextTable.run();
                } else {
                    MSCView.this.openValueView.run();
                }
            }
        });
        this.mscWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(MSCView.this.logFileMetaData.getProjectName());
                int defaultBehaviour = preferences.getMscViewDefault();
                if (defaultBehaviour == 0) {
                    MSCView.this.openTextTable.run();
                } else {
                    MSCView.this.openValueView.run();
                }
            }
        });
        this.mscWidget.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IViewReference[] viewReferences;
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                if (MSCView.this.model == null) {
                    return;
                }
                IFile logFile = MSCView.this.model.getTestCase().getLogFile();
                if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
                    LogFileCacheHandler.handleLogFileChange(logFile);
                    return;
                }
                if (MSCView.this.logFileMetaData == null) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                for (IViewReference viewReference : viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences()) {
                    IViewPart viewPart = viewReference.getView(false);
                    if (!(viewPart instanceof TextTableView) || ((TextTableView)viewPart).getLogFileMetaData() == null || !MSCView.this.logFileMetaData.getFilePath().equals(((TextTableView)viewPart).getLogFileMetaData().getFilePath())) continue;
                    Integer selectedLine = (Integer)structuredSelection.getFirstElement();
                    int recordNumber = MSCView.this.model.getEvent(selectedLine - 2).getRecordNumber();
                    TextTableView textTableView = (TextTableView)viewPart;
                    if (textTableView.getSelectedRecord() == null || textTableView.getSelectedRecord().getRecordNumber() == recordNumber) break;
                    textTableView.setSelectedRecord(recordNumber);
                    break;
                }
                MSCView.this.silentOpenSource.delayedRun(event.getSelection());
                MSCView.this.silentOpenValueView.delayedRun(event.getSelection());
            }
        });
        this.createCoolbarContent();
        this.hookContextMenu();
        parent.layout(true);
        WorkspaceJob job2 = new WorkspaceJob("Displaying loaded log information"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (job == null) {
                    return Status.OK_STATUS;
                }
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                if (MSCView.this.logFileMetaData != null && MSCView.this.model != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MSCView.this.setModel(MSCView.this.model, MSCView.this.restoredSelection);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job2.setSystem(true);
        job2.schedule();
    }

    public void setFocus() {
        if (this.mscWidget != null && !this.mscWidget.isDisposed()) {
            this.mscWidget.setFocus();
        }
    }

    private void hookContextMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MSCView.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu(this.mscWidget.getViewControl());
        this.mscWidget.getViewControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openValueView);
        manager.add(this.openTextTable);
        manager.add((IAction)this.openSource);
        manager.add((IContributionItem)new Separator());
        manager.add(this.jumpToPreviousSetverdict);
        manager.add(this.jumpToNextSetverdict);
        manager.add((IContributionItem)new Separator());
        manager.add(this.filterAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.refresh);
    }

    protected void createCoolbarContent() {
        IActionBars bar = this.getViewSite().getActionBars();
        bar.getToolBarManager().removeAll();
        this.createMenuGroups();
        this.openValueView = new OpenValueViewAction(this, true);
        this.openValueView.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/details.gif"));
        this.silentOpenValueView = new OpenValueViewAction(this, false);
        this.silentOpenValueView.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/details.gif"));
        this.openTextTable = new OpenTextTableAction(this);
        this.openTextTable.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/table_view.gif"));
        this.openSource = new OpenSourceAction(this, false, true);
        this.openSource.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/table_view.gif"));
        this.silentOpenSource = new OpenSourceAction(this, true, false);
        this.silentOpenSource.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/table_view.gif"));
        Action switchToTextTable = new Action(){

            public void run() {
                if (MSCView.this.logFileMetaData == null) {
                    return;
                }
                TextTableViewHelper.open(MSCView.this.logFileMetaData.getProjectName(), MSCView.this.logFileMetaData.getProjectRelativePath(), MSCView.this.getSelectedRecordNumber());
            }
        };
        switchToTextTable.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/table_view.gif"));
        switchToTextTable.setText("Switch to Table view");
        switchToTextTable.setToolTipText(switchToTextTable.getText());
        bar.getToolBarManager().appendToGroup("SWITCH_VIEW_GROUP", (IAction)switchToTextTable);
        this.jumpToPreviousSetverdict = new JumpToPreviousSetverdictAction(this);
        this.jumpToPreviousSetverdict.setId("jumpToNextSetVerdict");
        this.jumpToPreviousSetverdict.setText(Messages.getString("MSCView.11"));
        this.jumpToPreviousSetverdict.setToolTipText(Messages.getString("MSCView.12"));
        this.jumpToPreviousSetverdict.setImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getIcon("icons/arrow_up.gif")));
        this.jumpToPreviousSetverdict.setEnabled(false);
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", this.jumpToPreviousSetverdict);
        this.jumpToNextSetverdict = new JumpToNextSetverdictAction(this);
        this.jumpToNextSetverdict.setId("jumpToNextSetVerdict");
        this.jumpToNextSetverdict.setText(Messages.getString("MSCView.13"));
        this.jumpToNextSetverdict.setToolTipText(Messages.getString("MSCView.14"));
        this.jumpToNextSetverdict.setImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getIcon("icons/arrow_down.gif")));
        this.jumpToNextSetverdict.setEnabled(false);
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", this.jumpToNextSetverdict);
        this.refresh = new RefreshMSCViewAction(this);
        this.refresh.setId("refreshMSCView");
        this.refresh.setToolTipText(Messages.getString("MSCView.1"));
        this.refresh.setImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getIcon("icons/refresh.gif")));
        IActionBars actionBar = this.getViewSite().getActionBars();
        actionBar.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.refresh);
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", this.refresh);
        Action closeAllAction = new Action(){

            public void run() {
                IViewReference[] viewReferences;
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                for (IViewReference reference : viewReferences = activePage.getViewReferences()) {
                    IViewPart view = reference.getView(false);
                    if (view == null) {
                        activePage.hideView(reference);
                        continue;
                    }
                    if (!(view instanceof MSCView)) continue;
                    activePage.hideView(reference);
                }
                DetailsView detailsView = (DetailsView)activePage.findView("org.eclipse.titan.log.viewer.views.DetailsView");
                if (detailsView != null) {
                    detailsView.setData(null, false);
                }
            }
        };
        closeAllAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getIcon("icons/delete.gif")));
        closeAllAction.setId("closeMSC");
        closeAllAction.setToolTipText(Messages.getString("MSCView.2"));
        closeAllAction.setEnabled(true);
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", (IAction)closeAllAction);
        ZoomAction resetZoom = new ZoomAction((IViewPart)this);
        resetZoom.setId("org.eclipse.titan.log.viewer.views.msc.ui.actions.ResetZoom");
        resetZoom.setText(Messages.getString("MSCView.3"));
        resetZoom.setToolTipText(Messages.getString("MSCView.4"));
        resetZoom.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/home_nav.gif"));
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", (IAction)resetZoom);
        ZoomAction noZoom = new ZoomAction((IViewPart)this);
        noZoom.setChecked(true);
        noZoom.setId("org.eclipse.titan.log.viewer.views.msc.ui.actions.NoZoom");
        noZoom.setText(Messages.getString("MSCView.5"));
        noZoom.setToolTipText(Messages.getString("MSCView.6"));
        noZoom.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/move.gif"));
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", (IAction)noZoom);
        ZoomAction zoomIn = new ZoomAction((IViewPart)this);
        zoomIn.setId("org.eclipse.titan.log.viewer.views.msc.ui.actions.ZoomInCoolBar");
        zoomIn.setText(Messages.getString("MSCView.7"));
        zoomIn.setToolTipText(Messages.getString("MSCView.8"));
        zoomIn.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/zoomin_nav.gif"));
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", (IAction)zoomIn);
        ZoomAction zoomOut = new ZoomAction((IViewPart)this);
        zoomOut.setId("org.eclipse.titan.log.viewer.views.msc.ui.actions.ZoomOutCoolBar");
        zoomOut.setText(Messages.getString("MSCView.9"));
        zoomOut.setToolTipText(Messages.getString("MSCView.10"));
        zoomOut.setImageDescriptor(Activator.getDefault().getCachedImageDescriptor("icons/zoomout_nav.gif"));
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", (IAction)zoomOut);
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", this.filterAction);
        Action decipheringAction = new Action(){

            public void run() {
                List<String> rulesets = DecipheringPreferenceHandler.getAvailableRuleSets();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(MSCView.this.getSite().getShell(), (ILabelProvider)new LabelProvider());
                dialog.setTitle("Message name deciphering");
                dialog.setMessage("Select a deciphering ruleset");
                dialog.setHelpAvailable(false);
                dialog.setElements(rulesets.toArray());
                if (dialog.open() == 1 || dialog.getFirstResult() == null) {
                    return;
                }
                MSCView.this.model.setDecipheringRuleset((String)dialog.getFirstResult());
                MSCView.this.mscWidget.redraw();
            }
        };
        decipheringAction.setImageDescriptor(Activator.getImageDescriptor("icons/deciphering.gif"));
        decipheringAction.setToolTipText("Select a message name deciphering ruleset");
        bar.getToolBarManager().appendToGroup("ZOOM_GROUP", (IAction)decipheringAction);
        bar.updateActionBars();
    }

    public FilterPattern getFilterPattern() {
        return this.filterPattern;
    }

    private SortedMap<String, Boolean> loadEventsFromPreferences() {
        String[] categories;
        TreeMap<String, Boolean> result = new TreeMap<String, Boolean>();
        String prefValues = Activator.getDefault().getPreferenceStore().getString("org.eclipse.titan.log.viewer_filter_silent_event_categories");
        for (String category : categories = prefValues.split(";")) {
            String[] currCategory = category.split("=");
            if (currCategory.length <= 1) continue;
            String currKey = currCategory[0];
            boolean currValue = Boolean.valueOf(currCategory[1]) == false;
            result.put(currKey, currValue);
        }
        return result;
    }

    public void setModel(ExecutionModel model, int firstRow) {
        if (this.logFileMetaData == null || model == null) {
            return;
        }
        String sutName = PreferencesHandler.getInstance().getPreferences(this.logFileMetaData.getProjectName()).getSutName();
        if (sutName.length() == 0) {
            sutName = "System";
        }
        this.model = model;
        MSCModel mscModel = new MSCModel(model, this.logFileMetaData, sutName);
        Frame frame = mscModel.getModelFrame();
        List<String> visualOrderComponents = PreferencesHandler.getInstance().getPreferences(this.logFileMetaData.getProjectName()).getVisualOrderComponents();
        for (int i = visualOrderComponents.size() - 1; i >= 0; --i) {
            String currentComp = visualOrderComponents.get(i);
            if (currentComp.contentEquals("System Under Test")) {
                currentComp = sutName;
            } else if (currentComp.contentEquals("Main Test Component")) {
                currentComp = "MTC";
            }
            for (int j = 1; j < frame.lifeLinesCount(); ++j) {
                Lifeline lifeLine = frame.getLifeline(j);
                if (!lifeLine.getName().contentEquals(currentComp)) continue;
                frame.moveLifeLineToPosition(lifeLine, 1);
            }
        }
        this.setPartName(frame.getName());
        this.setFrame(frame, true);
        this.setContentDescription(this.logFileMetaData.getProjectRelativePath());
        int verdict = model.getTestCase().getVerdict();
        switch (verdict) {
            case 0: {
                this.setTitleImage(Activator.getDefault().getIcon("icons/testpass.gif"));
                break;
            }
            case 3: {
                this.setTitleImage(Activator.getDefault().getIcon("icons/testfail.gif"));
                break;
            }
            case 4: {
                this.setTitleImage(Activator.getDefault().getIcon("icons/testerr.gif"));
                break;
            }
            case 2: {
                this.setTitleImage(Activator.getDefault().getIcon("icons/testincon.gif"));
                break;
            }
            default: {
                this.setTitleImage(Activator.getDefault().getIcon("icons/testnone.gif"));
            }
        }
        if (this.mscWidget != null) {
            this.mscWidget.setSelection((ISelection)new StructuredSelection((Object)firstRow));
        }
    }

    private void setFrame(Frame frame, boolean resetPosition) {
        if (this.getMSCWidget() == null || frame == null) {
            return;
        }
        if (!this.getMSCWidget().isDisposed()) {
            this.getMSCWidget().setFrame(frame, resetPosition);
        }
    }

    protected void createMenuGroups() {
        IActionBars bar = this.getViewSite().getActionBars();
        if (bar == null) {
            return;
        }
        bar.getToolBarManager().add((IContributionItem)new Separator("ZOOM_GROUP"));
        bar.getToolBarManager().add((IContributionItem)new Separator("SWITCH_VIEW_GROUP"));
    }

    public ExecutionModel getModel() {
        return this.model;
    }

    public void dispose() {
        DetailsView detailsView;
        IWorkbenchPage activePage;
        if (this.silentOpenSource != null) {
            this.silentOpenSource.dispose();
            this.silentOpenSource = null;
        }
        if (this.openSource != null) {
            this.openSource.dispose();
            this.openSource = null;
        }
        if (this.openValueView != null) {
            this.openValueView.dispose();
            this.openValueView = null;
        }
        if (this.silentOpenValueView != null) {
            this.silentOpenValueView.dispose();
            this.silentOpenValueView = null;
        }
        if ((activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null && (detailsView = (DetailsView)activePage.findView("org.eclipse.titan.log.viewer.views.DetailsView")) != null && this.model != null) {
            String dvTestCaseName = detailsView.getTestCaseName();
            String mTestCaseName = this.model.getTestCase().getTestCaseName();
            URI dvFullPath = detailsView.getFullPath();
            URI mFullPath = this.logFileMetaData.getFilePath();
            if (dvTestCaseName != null && mTestCaseName != null && dvFullPath != null && mFullPath != null && dvTestCaseName.equals(mTestCaseName) && dvFullPath.equals(mFullPath)) {
                detailsView.setData(null, false);
            }
        }
        super.dispose();
    }

    @Override
    public LogFileMetaData getLogFileMetaData() {
        return this.logFileMetaData;
    }

    @Override
    public String getName() {
        return "MSC View";
    }
}

