/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.LineDelimiterEditor;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariableDialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ResourceInfoPage
extends PropertyPage {
    private Button editableBox;
    private Button executableBox;
    private Button archiveBox;
    private Button derivedBox;
    private Button immutableBox;
    private Button[] permissionBoxes;
    private boolean previousReadOnlyValue;
    private boolean previousExecutableValue;
    private boolean previousArchiveValue;
    private boolean previousDerivedValue;
    private int previousPermissionsValue;
    private IContentDescription cachedContentDescription;
    private ResourceEncodingFieldEditor encodingEditor;
    private LineDelimiterEditor lineDelimiterEditor;
    private static String READ_ONLY = IDEWorkbenchMessages.ResourceInfo_readOnly;
    private static String EXECUTABLE = IDEWorkbenchMessages.ResourceInfo_executable;
    private static String LOCKED = IDEWorkbenchMessages.ResourceInfo_locked;
    private static String ARCHIVE = IDEWorkbenchMessages.ResourceInfo_archive;
    private static String DERIVED = IDEWorkbenchMessages.ResourceInfo_derived;
    private static String DERIVED_HAS_DERIVED_ANCESTOR = IDEWorkbenchMessages.ResourceInfo_derivedHasDerivedAncestor;
    private static String TYPE_TITLE = IDEWorkbenchMessages.ResourceInfo_type;
    private static String LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_location;
    private static String LOCATION_BUTTON_TOOLTIP = IDEWorkbenchMessages.ResourceInfo_location_button_tooltip;
    private static String PATH_BUTTON_TOOLTIP = IDEWorkbenchMessages.ResourceInfo_path_button_tooltip;
    private static String RESOLVED_LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_resolvedLocation;
    private static String SIZE_TITLE = IDEWorkbenchMessages.ResourceInfo_size;
    private static String PATH_TITLE = IDEWorkbenchMessages.ResourceInfo_path;
    private static String TIMESTAMP_TITLE = IDEWorkbenchMessages.ResourceInfo_lastModified;
    private static String FILE_ENCODING_TITLE = IDEWorkbenchMessages.WorkbenchPreference_encoding;
    private static String CONTAINER_ENCODING_TITLE = IDEWorkbenchMessages.ResourceInfo_fileEncodingTitle;
    private static String EDIT_TITLE = IDEWorkbenchMessages.ResourceInfo_edit;
    private Text resolvedLocationValue = null;
    private Text locationValue = null;
    private Text sizeValue = null;
    private IPath newResourceLocation = null;
    private static final int MAX_VALUE_WIDTH = 80;

    private Composite createBasicInfoGroup(Composite parent, IResource resource) {
        this.initializeDialogUnits((Control)parent);
        Composite basicInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        basicInfoComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        basicInfoComposite.setLayoutData((Object)data);
        Label pathLabel = new Label(basicInfoComposite, 0);
        pathLabel.setText(PATH_TITLE);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        pathLabel.setLayoutData((Object)gd);
        Text pathValueText = new Text(basicInfoComposite, 72);
        String pathString = TextProcessor.process((String)resource.getFullPath().toString());
        pathValueText.setText(pathString);
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        pathValueText.setLayoutData((Object)gd);
        pathValueText.setBackground(pathValueText.getDisplay().getSystemColor(22));
        Label typeTitle = new Label(basicInfoComposite, 16384);
        typeTitle.setText(TYPE_TITLE);
        Text typeValue = new Text(basicInfoComposite, 16392);
        GridDataFactory.swtDefaults().span(3, -1).applyTo((Control)typeValue);
        typeValue.setText(IDEResourceInfoUtils.getTypeString(resource, this.getContentDescription(resource)));
        typeValue.setBackground(typeValue.getDisplay().getSystemColor(22));
        if (resource.isLinked() && !resource.isVirtual()) {
            int verticalIndent;
            locationTitle = new Label(basicInfoComposite, 16384);
            locationTitle.setText(LOCATION_TITLE);
            gd = new GridData();
            gd.verticalAlignment = 128;
            locationTitle.setLayoutData((Object)gd);
            Composite locationComposite = new Composite(basicInfoComposite, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            locationComposite.setLayout((Layout)layout);
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 128;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 3;
            locationComposite.setLayoutData((Object)gd);
            this.locationValue = new Text(locationComposite, 72);
            String locationStr = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(resource));
            this.locationValue.setText(locationStr);
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 128;
            gd.horizontalAlignment = 4;
            this.locationValue.setLayoutData((Object)gd);
            this.locationValue.setBackground(this.locationValue.getDisplay().getSystemColor(22));
            Button editButton = new Button(locationComposite, 8);
            editButton.setText(EDIT_TITLE);
            this.setButtonLayoutData(editButton);
            ((GridData)editButton.getLayoutData()).verticalAlignment = 128;
            int locationValueHeight = this.locationValue.computeSize((int)-1, (int)-1, (boolean)true).y;
            int editButtonHeight = editButton.computeSize((int)-1, (int)-1, (boolean)true).y;
            ((GridData)locationTitle.getLayoutData()).verticalIndent = verticalIndent = (editButtonHeight - locationValueHeight) / 2;
            ((GridData)this.locationValue.getLayoutData()).verticalIndent = verticalIndent;
            editButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ResourceInfoPage.this.editLinkLocation();
                }

                public void widgetSelected(SelectionEvent e) {
                    ResourceInfoPage.this.editLinkLocation();
                }
            });
            Label resolvedLocationTitle = new Label(basicInfoComposite, 16384);
            resolvedLocationTitle.setText(RESOLVED_LOCATION_TITLE);
            gd = new GridData();
            gd.verticalAlignment = 128;
            resolvedLocationTitle.setLayoutData((Object)gd);
            this.resolvedLocationValue = new Text(basicInfoComposite, 72);
            this.resolvedLocationValue.setText(IDEResourceInfoUtils.getResolvedLocationText(resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 3;
            this.resolvedLocationValue.setLayoutData((Object)gd);
            this.resolvedLocationValue.setBackground(this.resolvedLocationValue.getDisplay().getSystemColor(22));
        } else if (!resource.isVirtual()) {
            locationTitle = new Label(basicInfoComposite, 16384);
            locationTitle.setText(LOCATION_TITLE);
            gd = new GridData();
            locationTitle.setLayoutData((Object)gd);
            this.locationValue = new Text(basicInfoComposite, 72);
            final String locationStr = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(resource));
            this.locationValue.setText(locationStr);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            this.locationValue.setLayoutData((Object)gd);
            this.locationValue.setBackground(this.locationValue.getDisplay().getSystemColor(22));
            Button goToLocationButton = new Button(basicInfoComposite, 8);
            gd = new GridData();
            gd.verticalAlignment = 128;
            goToLocationButton.setLayoutData((Object)gd);
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)goToLocationButton);
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            URL goToFolderUrl = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)"icons/full/obj16/goto_input.png"), null);
            goToLocationButton.setImage((Image)resourceManager.create((DeviceResourceDescriptor)ImageDescriptor.createFromURL((URL)goToFolderUrl)));
            goToLocationButton.setToolTipText(LOCATION_BUTTON_TOOLTIP);
            goToLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterizedCommand parameterizedCommand;
                    ECommandService commandService = (ECommandService)PlatformUI.getWorkbench().getService(ECommandService.class);
                    EHandlerService handlerService = (EHandlerService)PlatformUI.getWorkbench().getService(EHandlerService.class);
                    Command command = commandService.getCommand("org.eclipse.ui.ide.showInSystemExplorer");
                    if (command.isDefined() && handlerService.canExecute(parameterizedCommand = commandService.createCommand("org.eclipse.ui.ide.showInSystemExplorer", Collections.singletonMap("org.eclipse.ui.ide.showInSystemExplorer.path", locationStr)))) {
                        handlerService.executeHandler(parameterizedCommand);
                    }
                }
            });
            Button pathCopy = new Button(basicInfoComposite, 8);
            pathCopy.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
            pathCopy.setToolTipText(PATH_BUTTON_TOOLTIP);
            pathCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StringSelection strSelection = new StringSelection(locationStr);
                    Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    systemClipboard.setContents(strSelection, null);
                }
            });
        }
        if (resource.getType() == 1) {
            Label sizeTitle = new Label(basicInfoComposite, 16384);
            sizeTitle.setText(SIZE_TITLE);
            this.sizeValue = new Text(basicInfoComposite, 16392);
            this.sizeValue.setText(IDEResourceInfoUtils.getSizeString(resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 3;
            this.sizeValue.setLayoutData((Object)gd);
            this.sizeValue.setBackground(this.sizeValue.getDisplay().getSystemColor(22));
        }
        Label timeStampLabel = new Label(basicInfoComposite, 0);
        timeStampLabel.setText(TIMESTAMP_TITLE);
        Text timeStampValue = new Text(basicInfoComposite, 8);
        timeStampValue.setText(IDEResourceInfoUtils.getDateStringValue(resource));
        timeStampValue.setBackground(timeStampValue.getDisplay().getSystemColor(22));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        timeStampValue.setLayoutData((Object)gridData);
        return basicInfoComposite;
    }

    protected void editLinkLocation() {
        IResource resource = (IResource)Adapters.adapt((Object)this.getElement(), IResource.class);
        String locationFormat = resource.getPathVariableManager().convertFromUserEditableFormat(this.locationValue.getText(), true);
        IPath location = IPath.fromOSString((String)locationFormat);
        PathVariableDialog dialog = new PathVariableDialog(this.getShell(), 3, resource.getType(), resource.getPathVariableManager(), null);
        dialog.setLinkLocation(location);
        dialog.setResource(resource);
        if (dialog.open() == 1) {
            return;
        }
        this.newResourceLocation = location = IPath.fromOSString((String)dialog.getVariableValue());
        this.refreshLinkLocation();
    }

    private void refreshLinkLocation() {
        IResource resource = (IResource)Adapters.adapt((Object)this.getElement(), IResource.class);
        String userEditableFormat = resource.getPathVariableManager().convertToUserEditableFormat(this.newResourceLocation.toOSString(), true);
        this.locationValue.setText(userEditableFormat);
        URI resolvedURI = resource.getPathVariableManager().resolveURI(URIUtil.toURI((IPath)this.newResourceLocation));
        IPath resolved = URIUtil.toPath((URI)resolvedURI);
        if (!IDEResourceInfoUtils.exists(resolved.toOSString())) {
            this.resolvedLocationValue.setText(IDEWorkbenchMessages.ResourceInfo_undefinedPathVariable);
            if (this.sizeValue != null) {
                this.sizeValue.setText(IDEWorkbenchMessages.ResourceInfo_notExist);
            }
        } else {
            this.resolvedLocationValue.setText(resolved.toPortableString());
            if (this.sizeValue != null) {
                IFileInfo info = IDEResourceInfoUtils.getFileInfo(resolved.toPortableString());
                if (info != null) {
                    this.sizeValue.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_bytes, (Object)Long.toString(info.getLength())));
                } else {
                    this.sizeValue.setText(IDEWorkbenchMessages.ResourceInfo_unknown);
                }
            }
        }
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.resource_info_property_page_context");
        IResource resource = (IResource)Adapters.adapt((Object)this.getElement(), IResource.class);
        if (resource == null) {
            Label label = new Label(parent, 0);
            label.setText(IDEWorkbenchMessages.ResourceInfoPage_noResource);
            return label;
        }
        if (resource.getType() != 4) {
            ResourceAttributes attrs = resource.getResourceAttributes();
            if (attrs != null) {
                this.previousReadOnlyValue = attrs.isReadOnly();
                this.previousExecutableValue = attrs.isExecutable();
                this.previousArchiveValue = attrs.isArchive();
            } else {
                this.previousArchiveValue = false;
                this.previousExecutableValue = false;
                this.previousReadOnlyValue = false;
            }
            this.previousDerivedValue = resource.isDerived();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.createBasicInfoGroup(composite, resource);
        if (resource.getType() != 4) {
            this.createSeparator(composite);
            int fsAttributes = this.getFileSystemAttributes(resource);
            if (this.isPermissionsSupport(fsAttributes)) {
                this.previousPermissionsValue = this.fetchPermissions(resource);
            }
            this.createStateGroup(composite, resource, fsAttributes);
            if (this.isPermissionsSupport(fsAttributes)) {
                this.createSeparator(composite);
                this.createPermissionsGroup(composite);
                this.setPermissionsSelection(this.previousPermissionsValue);
            }
        }
        if (resource.getProject().isOpen()) {
            this.encodingEditor = new ResourceEncodingFieldEditor(this.getFieldEditorLabel(resource), composite, resource);
            this.encodingEditor.setPage((DialogPage)this);
            this.encodingEditor.load();
            this.encodingEditor.setPropertyChangeListener(event -> {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    this.setValid(this.encodingEditor.isValid());
                }
            });
            if (resource.getType() == 4) {
                this.lineDelimiterEditor = new LineDelimiterEditor(composite, resource.getProject());
                this.lineDelimiterEditor.doLoad();
            }
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private int fetchPermissions(IResource resource) {
        IFileStore store = null;
        try {
            store = EFS.getStore((URI)resource.getLocationURI());
        }
        catch (CoreException e) {
            return 0;
        }
        IFileInfo info = store.fetchInfo();
        int permissions = 0;
        if (info.exists()) {
            permissions |= info.getAttribute(0x400000) ? 0x400000 : 0;
            permissions |= info.getAttribute(0x800000) ? 0x800000 : 0;
            permissions |= info.getAttribute(0x1000000) ? 0x1000000 : 0;
            permissions |= info.getAttribute(0x2000000) ? 0x2000000 : 0;
            permissions |= info.getAttribute(0x4000000) ? 0x4000000 : 0;
            permissions |= info.getAttribute(0x8000000) ? 0x8000000 : 0;
            permissions |= info.getAttribute(0x10000000) ? 0x10000000 : 0;
            permissions |= info.getAttribute(0x20000000) ? 0x20000000 : 0;
            permissions |= info.getAttribute(0x40000000) ? 0x40000000 : 0;
            permissions |= info.getAttribute(0x200000) ? 0x200000 : 0;
        }
        return permissions;
    }

    private int getDefaulPermissions(boolean folder) {
        int permissions = 381681664;
        if (folder) {
            permissions |= 0x49000000;
        }
        return permissions;
    }

    private void setPermissionsSelection(int permissions) {
        this.permissionBoxes[0].setSelection((permissions & 0x400000) != 0);
        this.permissionBoxes[1].setSelection((permissions & 0x800000) != 0);
        this.permissionBoxes[2].setSelection((permissions & 0x1000000) != 0);
        this.permissionBoxes[3].setSelection((permissions & 0x2000000) != 0);
        this.permissionBoxes[4].setSelection((permissions & 0x4000000) != 0);
        this.permissionBoxes[5].setSelection((permissions & 0x8000000) != 0);
        this.permissionBoxes[6].setSelection((permissions & 0x10000000) != 0);
        this.permissionBoxes[7].setSelection((permissions & 0x20000000) != 0);
        this.permissionBoxes[8].setSelection((permissions & 0x40000000) != 0);
        if (this.immutableBox != null) {
            this.immutableBox.setSelection((permissions & 0x200000) != 0);
        }
    }

    private int getPermissionsSelection() {
        int permissions = 0;
        permissions |= this.permissionBoxes[0].getSelection() ? 0x400000 : 0;
        permissions |= this.permissionBoxes[1].getSelection() ? 0x800000 : 0;
        permissions |= this.permissionBoxes[2].getSelection() ? 0x1000000 : 0;
        permissions |= this.permissionBoxes[3].getSelection() ? 0x2000000 : 0;
        permissions |= this.permissionBoxes[4].getSelection() ? 0x4000000 : 0;
        permissions |= this.permissionBoxes[5].getSelection() ? 0x8000000 : 0;
        permissions |= this.permissionBoxes[6].getSelection() ? 0x10000000 : 0;
        permissions |= this.permissionBoxes[7].getSelection() ? 0x20000000 : 0;
        permissions |= this.permissionBoxes[8].getSelection() ? 0x40000000 : 0;
        if (this.immutableBox != null) {
            permissions |= this.immutableBox.getSelection() ? 0x200000 : 0;
        }
        return permissions;
    }

    private boolean putPermissions(IResource resource, int permissions) {
        IFileStore store = null;
        try {
            store = EFS.getStore((URI)resource.getLocationURI());
        }
        catch (CoreException e) {
            return false;
        }
        IFileInfo fileInfo = store.fetchInfo();
        if (!fileInfo.exists()) {
            return false;
        }
        fileInfo.setAttribute(0x400000, (permissions & 0x400000) != 0);
        fileInfo.setAttribute(0x800000, (permissions & 0x800000) != 0);
        fileInfo.setAttribute(0x1000000, (permissions & 0x1000000) != 0);
        fileInfo.setAttribute(0x2000000, (permissions & 0x2000000) != 0);
        fileInfo.setAttribute(0x4000000, (permissions & 0x4000000) != 0);
        fileInfo.setAttribute(0x8000000, (permissions & 0x8000000) != 0);
        fileInfo.setAttribute(0x10000000, (permissions & 0x10000000) != 0);
        fileInfo.setAttribute(0x20000000, (permissions & 0x20000000) != 0);
        fileInfo.setAttribute(0x40000000, (permissions & 0x40000000) != 0);
        fileInfo.setAttribute(0x200000, (permissions & 0x200000) != 0);
        try {
            store.putInfo(fileInfo, 1024, null);
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }

    private String getFieldEditorLabel(IResource resource) {
        if (resource instanceof IContainer) {
            return CONTAINER_ENCODING_TITLE;
        }
        return FILE_ENCODING_TITLE;
    }

    private void createEditableButton(Composite composite) {
        this.editableBox = new Button(composite, 131104);
        this.editableBox.setAlignment(16384);
        this.editableBox.setText(READ_ONLY);
        this.editableBox.setSelection(this.previousReadOnlyValue);
    }

    private void createExecutableButton(Composite composite) {
        this.executableBox = new Button(composite, 131104);
        this.executableBox.setAlignment(16384);
        this.executableBox.setText(EXECUTABLE);
        this.executableBox.setSelection(this.previousExecutableValue);
    }

    private void createImmutableButton(Composite composite) {
        this.immutableBox = new Button(composite, 131104);
        this.immutableBox.setAlignment(16384);
        this.immutableBox.setText(LOCKED);
        this.immutableBox.setSelection((this.previousPermissionsValue & 0x200000) != 0);
    }

    private void createArchiveButton(Composite composite) {
        this.archiveBox = new Button(composite, 131104);
        this.archiveBox.setAlignment(16384);
        this.archiveBox.setText(ARCHIVE);
        this.archiveBox.setSelection(this.previousArchiveValue);
    }

    private void createDerivedButton(Composite composite, IResource resource) {
        this.derivedBox = new Button(composite, 131104);
        this.derivedBox.setAlignment(16384);
        if (resource.getParent().isDerived(512)) {
            this.derivedBox.setText(DERIVED_HAS_DERIVED_ANCESTOR);
        } else {
            this.derivedBox.setText(DERIVED);
        }
        this.derivedBox.setSelection(this.previousDerivedValue);
    }

    private void createSeparator(Composite composite) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void createStateGroup(Composite parent, IResource resource, int fsAttributes) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label attributesLabel = new Label(composite, 16384);
        attributesLabel.setText(IDEWorkbenchMessages.ResourceInfo_attributes);
        if (!resource.isVirtual()) {
            if ((fsAttributes & 2) != 0 && !this.isPermissionsSupport(fsAttributes)) {
                this.createEditableButton(composite);
            }
            if ((fsAttributes & 4) != 0 && !this.isPermissionsSupport(fsAttributes)) {
                this.createExecutableButton(composite);
            }
            if ((fsAttributes & 8) != 0) {
                this.createArchiveButton(composite);
            }
            if ((fsAttributes & 0x200000) != 0) {
                this.createImmutableButton(composite);
            }
        }
        this.createDerivedButton(composite, resource);
        if (this.executableBox != null && resource.getType() == 2) {
            this.createExecutableWarning(composite, font);
        }
    }

    private void createPermissionsGroup(Composite parent) {
        Font font = parent.getFont();
        this.permissionBoxes = new Button[9];
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label permissionsLabel = new Label(composite, 0);
        permissionsLabel.setText(IDEWorkbenchMessages.ResourceInfo_permissions);
        Table table = new Table(composite, 2048);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < 4) {
            new TableColumn(table, 0).setResizable(false);
            ++i;
        }
        table.getColumn(1).setText(IDEWorkbenchMessages.ResourceInfo_read);
        table.getColumn(2).setText(IDEWorkbenchMessages.ResourceInfo_write);
        table.getColumn(3).setText(IDEWorkbenchMessages.ResourceInfo_execute);
        table.getColumn(3).pack();
        int columnWidth = table.getColumn(3).getWidth();
        table.getColumn(0).setWidth(columnWidth);
        table.getColumn(1).setWidth(columnWidth);
        table.getColumn(2).setWidth(columnWidth);
        TableItem ownerItem = new TableItem(table, 0);
        ownerItem.setText(IDEWorkbenchMessages.ResourceInfo_owner);
        this.permissionBoxes[0] = this.createPermissionEditor(table, ownerItem, 1);
        this.permissionBoxes[1] = this.createPermissionEditor(table, ownerItem, 2);
        this.permissionBoxes[2] = this.createPermissionEditor(table, ownerItem, 3);
        TableItem groupItem = new TableItem(table, 0);
        groupItem.setText(IDEWorkbenchMessages.ResourceInfo_group);
        this.permissionBoxes[3] = this.createPermissionEditor(table, groupItem, 1);
        this.permissionBoxes[4] = this.createPermissionEditor(table, groupItem, 2);
        this.permissionBoxes[5] = this.createPermissionEditor(table, groupItem, 3);
        TableItem otherItem = new TableItem(table, 0);
        otherItem.setText(IDEWorkbenchMessages.ResourceInfo_other);
        this.permissionBoxes[6] = this.createPermissionEditor(table, otherItem, 1);
        this.permissionBoxes[7] = this.createPermissionEditor(table, otherItem, 2);
        this.permissionBoxes[8] = this.createPermissionEditor(table, otherItem, 3);
        GridData tableData = new GridData();
        tableData.heightHint = table.getHeaderHeight() + 3 * table.getItemHeight();
        table.setLayoutData((Object)tableData);
        this.createExecutableWarning(composite, font);
    }

    private Button createPermissionEditor(Table table, TableItem item, int index) {
        Button button = new Button((Composite)table, 32);
        button.pack();
        TableEditor editor = new TableEditor(table);
        editor.grabVertical = true;
        editor.verticalAlignment = 0x1000000;
        editor.minimumWidth = button.getSize().x;
        editor.setEditor((Control)button, item, index);
        editor.getEditor();
        return button;
    }

    private Composite createExecutableWarning(Composite composite, Font font) {
        Composite noteComposite = this.createNoteComposite(font, composite, IDEWorkbenchMessages.Preference_note, IDEWorkbenchMessages.ResourceInfo_exWarning);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(IDEWorkbenchMessages.ResourceInfo_exWarning.length());
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        noteComposite.setLayoutData((Object)data);
        return noteComposite;
    }

    private int getFileSystemAttributes(IResource resource) {
        IFileSystem fs;
        URI location = resource.getLocationURI();
        if (location == null || location.getScheme() == null) {
            return 0;
        }
        try {
            fs = EFS.getFileSystem((String)location.getScheme());
        }
        catch (CoreException e) {
            return 0;
        }
        return fs.attributes();
    }

    private boolean isPermissionsSupport(int fsAttributes) {
        int unixPermissions = 2143289344;
        return (fsAttributes & unixPermissions) == unixPermissions;
    }

    private IContentDescription getContentDescription(IResource resource) {
        if (resource.getType() != 1) {
            return null;
        }
        if (this.cachedContentDescription == null) {
            try {
                this.cachedContentDescription = ((IFile)resource).getContentDescription();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.cachedContentDescription;
    }

    protected void performDefaults() {
        IResource resource = (IResource)Adapters.adapt((Object)this.getElement(), IResource.class);
        if (resource == null) {
            return;
        }
        if (this.newResourceLocation != null) {
            this.newResourceLocation = null;
            this.resolvedLocationValue.setText(IDEResourceInfoUtils.getResolvedLocationText(resource));
            String locationStr = TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(resource));
            this.locationValue.setText(locationStr);
            if (this.sizeValue != null) {
                this.sizeValue.setText(IDEResourceInfoUtils.getSizeString(resource));
            }
        }
        if (this.editableBox != null) {
            this.editableBox.setSelection(false);
        }
        if (this.executableBox != null) {
            this.executableBox.setSelection(false);
        }
        if (this.archiveBox != null) {
            this.archiveBox.setSelection(true);
        }
        if (this.immutableBox != null) {
            this.immutableBox.setSelection(false);
        }
        if (this.derivedBox != null) {
            this.derivedBox.setSelection(false);
        }
        if (this.permissionBoxes != null) {
            int defaultPermissionValues = this.getDefaulPermissions(resource.getType() == 2);
            this.setPermissionsSelection(defaultPermissionValues);
        }
        if (this.encodingEditor != null) {
            this.encodingEditor.loadDefault();
        }
        if (this.lineDelimiterEditor != null) {
            this.lineDelimiterEditor.loadDefault();
        }
    }

    private String getSimpleChangeName(boolean isSet, String name) {
        Object message = "\t";
        message = (String)message + (isSet ? IDEWorkbenchMessages.ResourceInfo_recursiveChangesSet : IDEWorkbenchMessages.ResourceInfo_recursiveChangesUnset);
        message = (String)message + " " + name + "\n";
        return message;
    }

    private IResourceChange getAttributesChange(final boolean[] changedAttrs, final boolean[] finalAttrs) {
        return new IResourceChange(){

            @Override
            public String getMessage() {
                Object message = "";
                if (changedAttrs[0]) {
                    message = (String)message + ResourceInfoPage.this.getSimpleChangeName(finalAttrs[0], IDEWorkbenchMessages.ResourceInfo_readOnly);
                }
                if (changedAttrs[1]) {
                    message = (String)message + ResourceInfoPage.this.getSimpleChangeName(finalAttrs[1], IDEWorkbenchMessages.ResourceInfo_executable);
                }
                if (changedAttrs[2]) {
                    message = (String)message + ResourceInfoPage.this.getSimpleChangeName(finalAttrs[2], IDEWorkbenchMessages.ResourceInfo_archive);
                }
                return message;
            }

            @Override
            public void performChange(IResource resource) throws CoreException {
                ResourceAttributes attrs = resource.getResourceAttributes();
                if (attrs != null) {
                    if (changedAttrs[0]) {
                        attrs.setReadOnly(finalAttrs[0]);
                    }
                    if (changedAttrs[1]) {
                        attrs.setExecutable(finalAttrs[1]);
                    }
                    if (changedAttrs[2]) {
                        attrs.setArchive(finalAttrs[2]);
                    }
                    resource.setResourceAttributes(attrs);
                }
            }
        };
    }

    private IResourceChange getPermissionsChange(final int changedPermissions, final int finalPermissions) {
        return new IResourceChange(){

            @Override
            public String getMessage() {
                int[][] permissionMasks = new int[][]{{0x400000, 0x800000, 0x1000000}, {0x2000000, 0x4000000, 0x8000000}, {0x10000000, 0x20000000, 0x40000000}};
                String[] groupNames = new String[]{IDEWorkbenchMessages.ResourceInfo_owner, IDEWorkbenchMessages.ResourceInfo_group, IDEWorkbenchMessages.ResourceInfo_other};
                String[] permissionNames = new String[]{IDEWorkbenchMessages.ResourceInfo_read, IDEWorkbenchMessages.ResourceInfo_write, IDEWorkbenchMessages.ResourceInfo_execute};
                StringBuilder message = new StringBuilder("");
                if ((changedPermissions & 0x200000) != 0) {
                    message.append(ResourceInfoPage.this.getSimpleChangeName((finalPermissions & 0x200000) != 0, IDEWorkbenchMessages.ResourceInfo_locked));
                }
                int j = 0;
                while (j < 3) {
                    int i = 0;
                    while (i < 3) {
                        if ((changedPermissions & permissionMasks[j][i]) != 0) {
                            message.append(ResourceInfoPage.this.getSimpleChangeName((finalPermissions & permissionMasks[j][i]) != 0, groupNames[j] + " " + permissionNames[i]));
                        }
                        ++i;
                    }
                    ++j;
                }
                return message.toString();
            }

            @Override
            public void performChange(IResource resource) {
                int permissions = ResourceInfoPage.this.fetchPermissions(resource);
                permissions |= changedPermissions & finalPermissions;
                ResourceInfoPage.this.putPermissions(resource, permissions &= ~changedPermissions | finalPermissions);
            }
        };
    }

    private List<IResource> getResourcesToVisit(IResource resource) throws CoreException {
        HashSet<URI> visited = new HashSet<URI>();
        ArrayList<IResource> toVisit = new ArrayList<IResource>();
        visited.add(resource.getLocationURI());
        resource.accept(proxy -> {
            IResource childResource = proxy.requestResource();
            URI uri = childResource.getLocationURI();
            if (!visited.contains(uri)) {
                visited.add(uri);
                toVisit.add(childResource);
            }
            return true;
        }, 0);
        return toVisit;
    }

    private boolean shouldPerformRecursiveChanges(List<IResourceChange> changes) {
        if (!changes.isEmpty()) {
            StringBuilder message = new StringBuilder(IDEWorkbenchMessages.ResourceInfo_recursiveChangesSummary).append('\n');
            for (IResourceChange change : changes) {
                message.append(change.getMessage());
            }
            message.append(IDEWorkbenchMessages.ResourceInfo_recursiveChangesQuestion);
            MessageDialog dialog = new MessageDialog(this.getShell(), IDEWorkbenchMessages.ResourceInfo_recursiveChangesTitle, null, message.toString(), 3, 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
            return dialog.open() == 0;
        }
        return false;
    }

    private void scheduleRecursiveChangesJob(IResource resource, List<IResourceChange> changes) {
        Job.create((String)IDEWorkbenchMessages.ResourceInfo_recursiveChangesJobName, monitor -> {
            try {
                List<IResource> toVisit = this.getResourcesToVisit(resource);
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)IDEWorkbenchMessages.ResourceInfo_recursiveChangesJobName, (int)toVisit.size());
                Iterator<IResource> it = toVisit.iterator();
                while (it.hasNext()) {
                    SubMonitor iterationMonitor = subMonitor.split(1).setWorkRemaining(changes.size());
                    IResource childResource = it.next();
                    iterationMonitor.subTask(NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_recursiveChangesSubTaskName, (Object)childResource.getFullPath()));
                    for (Object change : changes) {
                        iterationMonitor.split(1);
                        ((IResourceChange)change).performChange(childResource);
                    }
                }
            }
            catch (CoreException e1) {
                IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ResourceInfo_recursiveChangesError, e1.getStatus());
                return e1.getStatus();
            }
            catch (OperationCanceledException e2) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }).schedule();
    }

    public boolean performOk() {
        IResource resource = (IResource)Adapters.adapt((Object)this.getElement(), IResource.class);
        if (resource == null) {
            return true;
        }
        if (this.lineDelimiterEditor != null) {
            this.lineDelimiterEditor.store();
        }
        try {
            try {
                boolean localDerivedValue;
                int permissionValues;
                if (this.newResourceLocation != null) {
                    if (resource.getType() == 1) {
                        ((IFile)resource).createLink(this.newResourceLocation, 256, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (resource.getType() == 2) {
                        ((IFolder)resource).createLink(this.newResourceLocation, 256, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                ArrayList<IResourceChange> changes = new ArrayList<IResourceChange>();
                ResourceAttributes attrs = resource.getResourceAttributes();
                if (attrs != null) {
                    boolean[] finalValues = new boolean[3];
                    boolean[] changedAttrs = new boolean[3];
                    if (this.editableBox != null && this.editableBox.getSelection() != this.previousReadOnlyValue) {
                        attrs.setReadOnly(this.editableBox.getSelection());
                        finalValues[0] = this.editableBox.getSelection();
                        changedAttrs[0] = true;
                    }
                    if (this.executableBox != null && this.executableBox.getSelection() != this.previousExecutableValue) {
                        attrs.setExecutable(this.executableBox.getSelection());
                        finalValues[1] = this.executableBox.getSelection();
                        changedAttrs[1] = true;
                    }
                    if (this.archiveBox != null && this.archiveBox.getSelection() != this.previousArchiveValue) {
                        attrs.setArchive(this.archiveBox.getSelection());
                        finalValues[2] = this.archiveBox.getSelection();
                        changedAttrs[2] = true;
                    }
                    if (changedAttrs[0] || changedAttrs[1] || changedAttrs[2]) {
                        resource.setResourceAttributes(attrs);
                        attrs = resource.getResourceAttributes();
                        if (attrs != null) {
                            this.previousReadOnlyValue = attrs.isReadOnly();
                            this.previousExecutableValue = attrs.isExecutable();
                            this.previousArchiveValue = attrs.isArchive();
                            if (this.editableBox != null) {
                                this.editableBox.setSelection(attrs.isReadOnly());
                            }
                            if (this.executableBox != null) {
                                this.executableBox.setSelection(attrs.isExecutable());
                            }
                            if (this.archiveBox != null) {
                                this.archiveBox.setSelection(attrs.isArchive());
                            }
                            if (resource.getType() == 2) {
                                changes.add(this.getAttributesChange(changedAttrs, finalValues));
                            }
                        }
                    }
                }
                if (this.permissionBoxes != null && this.previousPermissionsValue != (permissionValues = this.getPermissionsSelection())) {
                    int changedPermissions = this.previousPermissionsValue ^ permissionValues;
                    this.putPermissions(resource, permissionValues);
                    this.previousPermissionsValue = this.fetchPermissions(resource);
                    if (this.previousPermissionsValue != permissionValues) {
                        this.setPermissionsSelection(this.previousPermissionsValue);
                    }
                    if (resource.getType() == 2) {
                        changes.add(this.getPermissionsChange(changedPermissions, permissionValues));
                    }
                }
                if (this.shouldPerformRecursiveChanges(changes)) {
                    this.scheduleRecursiveChangesJob(resource, changes);
                }
                if (this.derivedBox != null && this.previousDerivedValue != (localDerivedValue = this.derivedBox.getSelection())) {
                    boolean isDerived;
                    resource.setDerived(localDerivedValue, null);
                    this.previousDerivedValue = isDerived = resource.isDerived();
                    this.derivedBox.setSelection(isDerived);
                }
            }
            catch (CoreException exception) {
                ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.InternalError, (String)exception.getLocalizedMessage(), (IStatus)exception.getStatus());
                if (this.encodingEditor != null) {
                    this.encodingEditor.store();
                }
                return false;
            }
        }
        finally {
            if (this.encodingEditor != null) {
                this.encodingEditor.store();
            }
        }
        return true;
    }

    private static interface IResourceChange {
        public String getMessage();

        public void performChange(IResource var1) throws CoreException;
    }
}

