/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.lami.core.Activator;

public final class LamiConfigUtils {
    private static final String CONFIG_DIR = "user-defined-configs";

    private LamiConfigUtils() {
    }

    public static Path getConfigDirPath() {
        IPath path = Activator.instance().getStateLocation();
        File dir = (path = path.addTrailingSeparator().append(CONFIG_DIR)).toFile();
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        return (Path)NonNullUtils.checkNotNull((Object)dir.toPath());
    }

    private static Path getConfigFilePath(String name) {
        Path configDirPath = LamiConfigUtils.getConfigDirPath();
        String normName = name.replaceAll("\\s+", "-");
        normName = normName.replaceAll("[^a-zA-Z0-9_]", "");
        return (Path)NonNullUtils.checkNotNull((Object)Paths.get(configDirPath.toString(), String.valueOf(normName) + ".properties"));
    }

    public static Path createConfigFile(String name, String command) throws IOException {
        Properties props = new Properties();
        props.setProperty("name", name);
        props.setProperty("command", command);
        Path configFilePath = LamiConfigUtils.getConfigFilePath(name);
        if (Files.exists(configFilePath, new LinkOption[0])) {
            throw new IOException(String.format("Configuration file \"%s\" exists", configFilePath.toString()));
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream out = Files.newOutputStream(configFilePath, new OpenOption[0]);){
            String userName = System.getProperty("user.name");
            if (userName == null) {
                userName = "unknown user";
            }
            Date curDate = new Date();
            String comment = String.format("Trace Compass external analysis descriptor created by user %s on %s", userName, curDate);
            props.store(out, comment);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return configFilePath;
    }

    public static void removeConfigFile(String name) throws IOException {
        Path configFilePath = LamiConfigUtils.getConfigFilePath(name);
        Files.delete(configFilePath);
    }
}

