/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers.deferred;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.deferred.IConcurrentModel;
import org.eclipse.jface.viewers.deferred.IConcurrentModelListener;

public abstract class AbstractConcurrentModel
implements IConcurrentModel {
    private final ListenerList<IConcurrentModelListener> listeners = new ListenerList();

    @Override
    public void addListener(IConcurrentModelListener listener) {
        this.listeners.add((Object)listener);
    }

    protected final void fireAdd(Object[] added) {
        for (IConcurrentModelListener next : this.listeners) {
            next.add(added);
        }
    }

    protected final void fireRemove(Object[] removed) {
        for (IConcurrentModelListener next : this.listeners) {
            next.remove(removed);
        }
    }

    protected final void fireUpdate(Object[] updated) {
        for (IConcurrentModelListener next : this.listeners) {
            next.update(updated);
        }
    }

    protected final IConcurrentModelListener[] getListeners() {
        Object[] l = this.listeners.getListeners();
        IConcurrentModelListener[] result = new IConcurrentModelListener[l.length];
        int i = 0;
        while (i < l.length) {
            result[i] = (IConcurrentModelListener)l[i];
            ++i;
        }
        return result;
    }

    @Override
    public void removeListener(IConcurrentModelListener listener) {
        this.listeners.remove((Object)listener);
    }
}

