/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileResolver {
    public static final String DISABLE_FILE_CACHING_PROP_NAME = "vertx.disableFileCaching";
    public static final String DISABLE_CP_RESOLVING_PROP_NAME = "vertx.disableFileCPResolving";
    public static final String CACHE_DIR_BASE_PROP_NAME = "vertx.cacheDirBase";
    private static final String DEFAULT_CACHE_DIR_BASE = ".vertx";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static boolean NON_UNIX_FILE_SEP = !FILE_SEP.equals("/");
    private static final boolean ENABLE_CACHING = !Boolean.getBoolean("vertx.disableFileCaching");
    private static final boolean ENABLE_CP_RESOLVING = !Boolean.getBoolean("vertx.disableFileCPResolving");
    private static final String CACHE_DIR_BASE = System.getProperty("vertx.cacheDirBase", ".vertx");
    private final Vertx vertx;
    private final File cwd;
    private File cacheDir;
    private Thread shutdownHook;

    public FileResolver(Vertx vertx) {
        this.vertx = vertx;
        String cwdOverride = System.getProperty("vertx.cwd");
        this.cwd = cwdOverride != null ? new File(cwdOverride).getAbsoluteFile() : null;
        if (ENABLE_CP_RESOLVING) {
            this.setupCacheDir();
        }
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.deleteCacheDir(handler);
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public File resolveFile(String fileName) {
        File file = new File(fileName);
        if (this.cwd != null && !file.isAbsolute()) {
            file = new File(this.cwd, fileName);
        }
        if (!ENABLE_CP_RESOLVING) {
            return file;
        }
        if (!file.exists()) {
            URL url;
            File cacheFile = new File(this.cacheDir, fileName);
            if (ENABLE_CACHING && cacheFile.exists()) {
                return cacheFile;
            }
            ClassLoader cl = this.getClassLoader();
            if (NON_UNIX_FILE_SEP) {
                fileName = fileName.replace(FILE_SEP, "/");
            }
            if ((url = cl.getResource(fileName)) != null) {
                String prot;
                switch (prot = url.getProtocol()) {
                    case "file": {
                        return this.unpackFromFileURL(url, fileName, cl);
                    }
                    case "jar": {
                        return this.unpackFromJarURL(url, fileName);
                    }
                    case "bundle": {
                        return this.unpackFromBundleURL(url);
                    }
                }
                throw new IllegalStateException("Invalid url protocol: " + prot);
            }
        }
        return file;
    }

    private synchronized File unpackFromFileURL(URL url, String fileName, ClassLoader cl) {
        File resource;
        try {
            resource = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new VertxException(e);
        }
        boolean isDirectory = resource.isDirectory();
        File cacheFile = new File(this.cacheDir, fileName);
        if (!isDirectory) {
            cacheFile.getParentFile().mkdirs();
            try {
                if (ENABLE_CACHING) {
                    Files.copy(resource.toPath(), cacheFile.toPath(), new CopyOption[0]);
                }
                Files.copy(resource.toPath(), cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        } else {
            String[] listing;
            cacheFile.mkdirs();
            for (String file : listing = resource.list()) {
                String subResource = fileName + "/" + file;
                URL url2 = cl.getResource(subResource);
                this.unpackFromFileURL(url2, subResource, cl);
            }
        }
        return cacheFile;
    }

    private synchronized File unpackFromJarURL(URL url, String fileName) {
        String path = url.getPath();
        String jarFile = path.substring(5, path.lastIndexOf(".jar!") + 4);
        try {
            ZipFile zip = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(fileName)) continue;
                File file = new File(this.cacheDir, name);
                if (name.endsWith("/")) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                try {
                    InputStream is = zip.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        if (ENABLE_CACHING) {
                            Files.copy(is, file.toPath(), new CopyOption[0]);
                            continue;
                        }
                        Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
            }
        }
        catch (IOException e) {
            throw new VertxException(e);
        }
        return new File(this.cacheDir, fileName);
    }

    private synchronized File unpackFromBundleURL(URL url) {
        block19: {
            try {
                File file = new File(this.cacheDir, url.getHost() + File.separator + url.getFile());
                file.getParentFile().mkdirs();
                if (url.toExternalForm().endsWith("/")) {
                    file.mkdirs();
                    break block19;
                }
                file.getParentFile().mkdirs();
                try (InputStream is = url.openStream();){
                    if (ENABLE_CACHING) {
                        Files.copy(is, file.toPath(), new CopyOption[0]);
                    } else {
                        Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        }
        return new File(this.cacheDir, url.getHost() + File.separator + url.getFile());
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }

    private void setupCacheDir() {
        String cacheDirName = CACHE_DIR_BASE + "/file-cache-" + UUID.randomUUID().toString();
        this.cacheDir = new File(cacheDirName);
        if (!this.cacheDir.mkdirs()) {
            throw new IllegalStateException("Failed to create cache dir");
        }
        this.shutdownHook = new Thread(() -> this.deleteCacheDir(ar -> {}));
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void deleteCacheDir(Handler<AsyncResult<Void>> handler) {
        if (this.cacheDir != null && this.cacheDir.exists()) {
            this.vertx.fileSystem().deleteRecursive(this.cacheDir.getAbsolutePath(), true, handler);
        } else {
            handler.handle(Future.succeededFuture());
        }
    }
}

