/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.metrics;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptionsConverter;

@DataObject(generateConverter=true)
public class MetricsOptions {
    public static final boolean DEFAULT_METRICS_ENABLED = false;
    private boolean enabled;
    private JsonObject json;

    public MetricsOptions() {
        this.enabled = false;
    }

    public MetricsOptions(MetricsOptions other) {
        this.enabled = other.isEnabled();
    }

    public MetricsOptions(JsonObject json) {
        this();
        MetricsOptionsConverter.fromJson(json, this);
        this.json = json.copy();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MetricsOptions setEnabled(boolean enable) {
        this.enabled = enable;
        return this;
    }

    public JsonObject toJson() {
        return this.json != null ? this.json.copy() : new JsonObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsOptions that = (MetricsOptions)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return !(this.json == null ? that.json != null : !this.json.equals(that.json));
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.json != null ? this.json.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MetricsOptions{enabled=" + this.enabled + ", json=" + this.json + '}';
    }
}

