/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableLongListFactory;
import org.eclipse.collections.api.list.primitive.MutableLongList;

/**
 * MutableLongListFactoryImpl is a factory implementation which creates instances of type {@link MutableLongList}.
 * This file was automatically generated from template file mutablePrimitiveListFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableLongListFactoryImpl implements MutableLongListFactory
{
    public MutableLongList empty()
    {
        return new LongArrayList();
    }

    public MutableLongList of()
    {
        return this.empty();
    }

    public MutableLongList with()
    {
        return this.empty();
    }

    public MutableLongList of(long... items)
    {
        return this.with(items);
    }

    public MutableLongList with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return LongArrayList.newListWith(items);
    }

    public MutableLongList ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public MutableLongList withAll(LongIterable items)
    {
        return LongArrayList.newList(items);
    }
}
