/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.common.project.facet.JavaProjectFacetCreationDataModelProvider;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.eclipse.wizards.AbstractNewParProjectWizard;
import org.eclipse.virgo.ide.manifest.core.BundleManifestUtils;
import org.eclipse.virgo.ide.par.Bundle;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.ide.par.ParFactory;
import org.eclipse.virgo.ide.par.ParPackage;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;
import org.eclipse.virgo.ide.ui.editors.ParManifestEditor;
import org.eclipse.virgo.ide.ui.editors.ParUtils;
import org.eclipse.virgo.ide.ui.wizards.NewParInformationPage;
import org.eclipse.virgo.ide.ui.wizards.NewParProjectReferencePage;
import org.eclipse.virgo.ide.ui.wizards.NewParProjectSettingsPage;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class NewParProjectWizard
extends AbstractNewParProjectWizard
implements INewWizard {
    private static final String PAR_FILE_NAME = ".settings/org.eclipse.virgo.ide.runtime.core.par.xml";
    private static final String ENCODING_UTF8 = "UTF-8";
    private WizardNewProjectCreationPage mainPage;
    private NewParInformationPage bundlePage;
    private WizardNewProjectReferencePage referencePage;
    private IProjectProvider projectProvider;
    private final AbstractFieldData bundleData;
    private final IDataModel model;
    private final String title = "New PAR Project";
    protected ParPackage parPackage = ParPackage.eINSTANCE;
    protected ParFactory parFactory = this.parPackage.getParFactory();

    public NewParProjectWizard() {
        this.setWindowTitle("New PAR Project");
        this.setNeedsProgressMonitor(true);
        this.bundleData = new PluginFieldData();
        this.model = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectFacetCreationDataModelProvider());
    }

    private void addFacetsToProject(final IProject project) {
        WorkspaceModifyOperation oper = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project.getProject(), (boolean)true, (IProgressMonitor)monitor);
                fProject.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.par").getDefaultVersion(), null, monitor);
                IRuntime runtime = (IRuntime)NewParProjectWizard.this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                if (runtime != null && runtime.supports(ProjectFacetsManager.getProjectFacet((String)"org.eclipse.virgo.server.par"))) {
                    fProject.setTargetedRuntimes(Collections.singleton(runtime), monitor);
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)oper);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Exception while adding project facets.", (Throwable)e));
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.virgo.ide.ui", "Interruption while adding project facets.", (Throwable)e));
        }
    }

    public void addPages() {
        this.mainPage = new NewParProjectSettingsPage("basicNewProjectPage", this.getSelection());
        this.setMainPage(this.mainPage);
        this.addPage((IWizardPage)this.mainPage);
        this.projectProvider = new IProjectProvider(){

            public IPath getLocationPath() {
                return this.getProject().getLocation();
            }

            public IProject getProject() {
                return NewParProjectWizard.this.mainPage.getProjectHandle();
            }

            public String getProjectName() {
                return NewParProjectWizard.this.mainPage.getProjectName();
            }
        };
        this.bundlePage = new NewParInformationPage("New PAR Project", this.projectProvider, this.bundleData, this.model);
        this.addPage((IWizardPage)this.bundlePage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new NewParProjectReferencePage("basicReferenceProjectPage");
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    private IFile associateProjectsToPar(IProject[] references, final IFile parFile) {
        final Par par = this.parFactory.createPar();
        IProject[] iProjectArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IProject workspaceProject = iProjectArray[n2];
            Bundle bundle = this.parFactory.createBundle();
            bundle.setSymbolicName(ParUtils.getSymbolicName(workspaceProject));
            par.getBundle().add((Object)bundle);
            ++n2;
        }
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)parFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            resource.getContents().add((Object)par);
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", NewParProjectWizard.ENCODING_UTF8);
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            ServerIdeUiPlugin.getDefault().log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            return parFile;
        }
        catch (Exception exception) {
            ServerIdeUiPlugin.getDefault().log(exception);
            return null;
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return super.canFinish() && page != this.getMainPage();
    }

    public boolean performFinish() {
        IFile manifestFile;
        IWorkingSet[] workingSets;
        this.createNewProject();
        if (this.getNewProject() == null) {
            return false;
        }
        this.bundlePage.performPageFinish();
        this.addFacetsToProject(this.getNewProject());
        this.writeBundleData(this.getNewProject());
        if (this.referencePage != null) {
            IProject[] references = this.referencePage.getReferencedProjects();
            this.associateProjectsToPar(references, this.getNewProject().getFile(PAR_FILE_NAME));
        }
        if ((workingSets = this.mainPage.getSelectedWorkingSets()).length > 0) {
            this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)this.getNewProject(), workingSets);
        }
        if ((manifestFile = (IFile)this.getNewProject().findMember("META-INF/MANIFEST.MF")) != null) {
            IWorkbenchWindow workbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)manifestFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(manifestFile), ParManifestEditor.ID_EDITOR);
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Error opening editor", (String)exception.getMessage());
            }
            return true;
        }
        return false;
    }

    private void writeBundleData(final IProject project) {
        WorkspaceModifyOperation oper = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                BundleManifestUtils.createNewParManifest((IProject)project, (String)NewParProjectWizard.this.bundleData.getId(), (String)NewParProjectWizard.this.bundleData.getVersion(), (String)NewParProjectWizard.this.bundleData.getName(), (String)NewParProjectWizard.this.bundleData.getProvider());
                project.refreshLocal(2, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)oper);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(ServerIdeUiPlugin.getImageDescriptor("full/wizban/wizban-par.png"));
    }
}

