/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.hash;

import java.util.NoSuchElementException;

public class HashObjLongNS {
    static final float LOAD_FACTOR = 0.75f;
    private int count = 0;
    private int step = 499979;
    public Object[] keys;
    public long[] values;
    public int[] next;
    private int limit;
    private double loadFactor;

    public HashObjLongNS() {
        this(101, 0.75);
    }

    public HashObjLongNS(int capacity) {
        this(capacity, 0.75);
    }

    public HashObjLongNS(int capacity, double lf) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Invalid hashtable capacity: " + capacity + ".");
        }
        if (capacity == 0) {
            capacity = 101;
        }
        if (lf < 0.0) {
            throw new IllegalArgumentException("Invalid load factor: " + lf + ".");
        }
        if (lf > 1.0) {
            lf = 1.0;
        }
        this.loadFactor = lf;
        this.limit = (int)((double)capacity * lf);
        this.count = 0;
        this.keys = new Object[capacity];
        this.values = new long[capacity];
        this.next = new int[capacity];
        int i = 0;
        while (i < capacity) {
            this.next[i] = -1;
            ++i;
        }
    }

    public void put(Object key, long value) {
        if (this.count >= this.limit) {
            this.rehash();
        }
        if (this._put(key, value)) {
            ++this.count;
        }
    }

    public long get(Object key) {
        int pos = this.find(key);
        if (pos == -1) {
            throw new NoSuchElementException();
        }
        return this.values[pos];
    }

    public long remove(Object key) {
        int pos = this.find(key);
        if (pos == -1) {
            throw new NoSuchElementException();
        }
        int n = pos;
        this.next[n] = this.next[n] + this.next.length;
        this.keys[pos] = null;
        --this.count;
        return this.values[pos];
    }

    public void removeAll() {
        int i = 0;
        while (i < this.values.length) {
            this.keys[i] = null;
            this.next[i] = -1;
            ++i;
        }
    }

    public void rehash() {
        Object[] tmpKeys = this.keys;
        long[] tmpValues = this.values;
        int[] tmpNext = this.next;
        int capacity = this.keys.length * 2 + 1;
        Object[] keys = new Object[capacity];
        long[] values = new long[capacity];
        int[] next = new int[capacity];
        int i = 0;
        while (i < next.length) {
            next[i] = -1;
            ++i;
        }
        this.keys = keys;
        this.values = values;
        this.next = next;
        i = 0;
        while (i < tmpNext.length) {
            if (tmpNext[i] >= 0 && tmpNext[i] < tmpNext.length) {
                this._put(tmpKeys[i], tmpValues[i]);
            }
            ++i;
        }
        this.limit = (int)((double)capacity * this.loadFactor);
    }

    public int size() {
        return this.count;
    }

    private int find(Object key) {
        return this.find(key, (key.hashCode() & Integer.MAX_VALUE) % this.keys.length);
    }

    private int find(Object key, int pos) {
        int i = 0;
        while (this.next[pos] >= 0) {
            if (key.equals(this.keys[pos]) && this.next[pos] < this.next.length) {
                return pos;
            }
            if ((pos = this.next[pos]) >= this.next.length) {
                pos -= this.next.length;
            }
            if (++i <= this.next.length) continue;
            return -1;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private boolean _put(Object key, long value) {
        pos = (key.hashCode() & 0x7FFFFFFF) % this.keys.length;
        index = this.find(key, pos);
        if (index == -1) ** GOTO lbl7
        this.values[index] = value;
        return false;
lbl-1000:
        // 1 sources

        {
            pos = this.next[pos];
lbl7:
            // 2 sources

            ** while (this.next[pos] >= 0 && this.next[pos] < this.next.length)
        }
lbl8:
        // 1 sources

        this.keys[pos] = key;
        this.values[pos] = value;
        if (this.next[pos] < 0) {
            this.next[pos] = (pos + this.step) % this.next.length;
        } else {
            v0 = pos;
            this.next[v0] = this.next[v0] - this.next.length;
        }
        return true;
    }
}

