/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.virgo.kernel.core.Shutdown;
import org.eclipse.virgo.kernel.deployer.core.ApplicationDeployer;
import org.eclipse.virgo.kernel.deployer.core.DeployUriNormaliser;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.framework.ImportExpander;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFramework;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.kernel.osgi.framework.PackageAdminUtil;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.shim.scope.ScopeFactory;
import org.eclipse.virgo.kernel.userregion.internal.EmptyModuleContextAccessor;
import org.eclipse.virgo.kernel.userregion.internal.InitialArtifactDeployer;
import org.eclipse.virgo.kernel.userregion.internal.KernelStartedAwaiter;
import org.eclipse.virgo.kernel.userregion.internal.ServiceScopingRegistryHook;
import org.eclipse.virgo.kernel.userregion.internal.ServiceScopingStrategy;
import org.eclipse.virgo.kernel.userregion.internal.UserRegionLogEvents;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxHookRegistrar;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxOsgiFramework;
import org.eclipse.virgo.kernel.userregion.internal.equinox.ResolutionDumpContributor;
import org.eclipse.virgo.kernel.userregion.internal.equinox.StandardPackageAdminUtil;
import org.eclipse.virgo.kernel.userregion.internal.equinox.TransformedManifestProvidingBundleFileWrapper;
import org.eclipse.virgo.kernel.userregion.internal.importexpansion.ImportExpansionHandler;
import org.eclipse.virgo.kernel.userregion.internal.quasi.ResolutionFailureDetective;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiFrameworkFactory;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardResolutionFailureDetective;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.osgi.extensions.equinox.hooks.MetaInfResourceClassLoaderDelegateHook;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private static final long MAX_SECONDS_WAIT_FOR_SERVICE = 30L;
    private static final long MAX_MILLIS_WAIT_FOR_SERVICE;
    private static final long SYSTEM_BUNDLE_ID = 0L;
    private static final String PROPERTY_USER_REGION_ARTIFACTS = "initialArtifacts";
    private static final String PROPERTY_USER_REGION_COMMANDLINE_ARTIFACTS = "commandLineArtifacts";
    private final ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();
    private volatile EquinoxHookRegistrar hookRegistrar;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.Activator");
        MAX_MILLIS_WAIT_FOR_SERVICE = TimeUnit.SECONDS.toMillis(30L);
    }

    public void start(BundleContext context) throws Exception {
        ResolutionFailureDetective rfd = this.createResolutionFailureDetective(context);
        Repository repository = (Repository)OsgiFrameworkUtils.getService((BundleContext)context, Repository.class).getService();
        PackageAdmin packageAdmin = (PackageAdmin)OsgiFrameworkUtils.getService((BundleContext)context, PackageAdmin.class).getService();
        EventLogger eventLogger = (EventLogger)OsgiFrameworkUtils.getService((BundleContext)context, EventLogger.class).getService();
        ImportExpansionHandler importExpansionHandler = this.createImportExpansionHandler(context, packageAdmin, repository, eventLogger);
        this.registrationTracker.track(context.registerService(ImportExpander.class.getName(), (Object)importExpansionHandler, null));
        TransformedManifestProvidingBundleFileWrapper bundleTransformerHandler = this.createBundleTransformationHandler(importExpansionHandler);
        OsgiFramework osgiFramework = this.createOsgiFramework(context, packageAdmin, bundleTransformerHandler);
        this.registrationTracker.track(context.registerService(OsgiFramework.class.getName(), (Object)osgiFramework, null));
        DumpContributor dumpContributor = this.createResolutionDumpContributor(context);
        this.registrationTracker.track(context.registerService(DumpContributor.class.getName(), (Object)dumpContributor, null));
        QuasiFrameworkFactory quasiFrameworkFactory = this.createQuasiFrameworkFactory(context, rfd, repository, bundleTransformerHandler);
        this.registrationTracker.track(context.registerService(QuasiFrameworkFactory.class.getName(), (Object)quasiFrameworkFactory, null));
        EquinoxHookRegistrar hookRegistrar = this.createHookRegistrar(context, packageAdmin, bundleTransformerHandler);
        hookRegistrar.init();
        this.hookRegistrar = hookRegistrar;
        PackageAdminUtil packageAdminUtil = this.createPackageAdminUtil(context);
        this.registrationTracker.track(context.registerService(PackageAdminUtil.class.getName(), (Object)packageAdminUtil, null));
        this.scheduleRegistrationOfServiceScopingRegistryHooks(context, eventLogger);
        Properties properties = new Properties();
        properties.put("service.ranking", (Object)Integer.MIN_VALUE);
        this.registrationTracker.track(context.registerService(ModuleContextAccessor.class.getName(), (Object)new EmptyModuleContextAccessor(), (Dictionary)properties));
        this.scheduleInitialArtifactDeployerCreation(context, eventLogger);
    }

    private ResolutionFailureDetective createResolutionFailureDetective(BundleContext context) {
        PlatformAdmin platformAdmin = (PlatformAdmin)OsgiFrameworkUtils.getService((BundleContext)context, PlatformAdmin.class).getService();
        return new StandardResolutionFailureDetective(platformAdmin);
    }

    private OsgiFramework createOsgiFramework(BundleContext context, PackageAdmin packageAdmin, TransformedManifestProvidingBundleFileWrapper bundleTransformerHandler) {
        return new EquinoxOsgiFramework(context, packageAdmin, bundleTransformerHandler);
    }

    private DumpContributor createResolutionDumpContributor(BundleContext bundleContext) {
        return new ResolutionDumpContributor(bundleContext);
    }

    private QuasiFrameworkFactory createQuasiFrameworkFactory(BundleContext bundleContext, ResolutionFailureDetective detective, Repository repository, TransformedManifestProvidingBundleFileWrapper bundleTransformerHandler) {
        return new StandardQuasiFrameworkFactory(bundleContext, detective, repository, bundleTransformerHandler);
    }

    private TransformedManifestProvidingBundleFileWrapper createBundleTransformationHandler(ImportExpansionHandler importExpander) {
        return new TransformedManifestProvidingBundleFileWrapper(importExpander);
    }

    private ImportExpansionHandler createImportExpansionHandler(BundleContext context, PackageAdmin packageAdmin, Repository repository, EventLogger eventLogger) {
        ExportedPackage[] exportedPackages;
        HashSet<String> packagesExportedBySystemBundle = new HashSet<String>(30);
        ExportedPackage[] exportedPackageArray = exportedPackages = packageAdmin.getExportedPackages(context.getBundle(0L));
        int n = exportedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ExportedPackage exportedPackage = exportedPackageArray[n2];
            packagesExportedBySystemBundle.add(exportedPackage.getName());
            ++n2;
        }
        return new ImportExpansionHandler(repository, context, packagesExportedBySystemBundle, eventLogger);
    }

    private EquinoxHookRegistrar createHookRegistrar(BundleContext context, PackageAdmin packageAdmin, TransformedManifestProvidingBundleFileWrapper bundleFileWrapper) {
        MetaInfResourceClassLoaderDelegateHook hook = new MetaInfResourceClassLoaderDelegateHook(context, packageAdmin);
        return new EquinoxHookRegistrar(bundleFileWrapper, (ClassLoaderDelegateHook)hook);
    }

    private PackageAdminUtil createPackageAdminUtil(BundleContext context) {
        return new StandardPackageAdminUtil(context);
    }

    private void scheduleRegistrationOfServiceScopingRegistryHooks(BundleContext context, EventLogger eventLogger) {
        ServiceScopingHookRegisteringRunnable runnable = new ServiceScopingHookRegisteringRunnable(context, this.registrationTracker, eventLogger);
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    private void scheduleInitialArtifactDeployerCreation(BundleContext context, EventLogger eventLogger) {
        KernelStartedAwaiter startedAwaiter = new KernelStartedAwaiter();
        Properties properties = new Properties();
        properties.put("event.topics", "org/eclipse/virgo/kernel/*");
        this.registrationTracker.track(context.registerService(EventHandler.class.getName(), (Object)startedAwaiter, (Dictionary)properties));
        InitialArtifactDeployerCreatingRunnable runnable = new InitialArtifactDeployerCreatingRunnable(context, eventLogger, this.registrationTracker, startedAwaiter);
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.registrationTracker.unregisterAll();
        EquinoxHookRegistrar hookRegistrar = this.hookRegistrar;
        if (hookRegistrar != null) {
            hookRegistrar.destroy();
            this.hookRegistrar = null;
        }
    }

    private static <T> T getPotentiallyDelayedService(BundleContext context, Class<T> serviceClass) throws TimeoutException, InterruptedException {
        Object service = null;
        long millisWaited = 0L;
        while (service == null && millisWaited <= MAX_MILLIS_WAIT_FOR_SERVICE) {
            try {
                OsgiServiceHolder serviceHolder = OsgiFrameworkUtils.getService((BundleContext)context, serviceClass);
                if (serviceHolder != null) {
                    service = serviceHolder.getService();
                    continue;
                }
                millisWaited += Activator.sleepABitMore();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (service == null) {
            throw new TimeoutException(serviceClass.getName());
        }
        return (T)service;
    }

    private static long sleepABitMore() throws InterruptedException {
        long before = System.currentTimeMillis();
        Thread.sleep(100L);
        return System.currentTimeMillis() - before;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InitialArtifactDeployerCreatingRunnable
    implements Runnable {
        private static final String USER_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel.userregion";
        private final BundleContext context;
        private final EventLogger eventLogger;
        private final KernelStartedAwaiter startAwaiter;
        private final ServiceRegistrationTracker registrationTracker;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public InitialArtifactDeployerCreatingRunnable(BundleContext context, EventLogger eventLogger, ServiceRegistrationTracker registrationTracker, KernelStartedAwaiter startAwaiter) {
            this.context = context;
            this.eventLogger = eventLogger;
            this.startAwaiter = startAwaiter;
            this.registrationTracker = registrationTracker;
        }

        @Override
        public void run() {
            EventAdmin eventAdmin = (EventAdmin)OsgiFrameworkUtils.getService((BundleContext)this.context, EventAdmin.class).getService();
            Shutdown shutdown = (Shutdown)OsgiFrameworkUtils.getService((BundleContext)this.context, Shutdown.class).getService();
            try {
                DeployUriNormaliser uriNormaliser = (DeployUriNormaliser)Activator.getPotentiallyDelayedService(this.context, DeployUriNormaliser.class);
                ApplicationDeployer deployer = (ApplicationDeployer)Activator.getPotentiallyDelayedService(this.context, ApplicationDeployer.class);
                Dictionary<String, String> artifactConfiguration = this.getRegionArtifactConfiguration();
                InitialArtifactDeployer initialArtifactDeployer = new InitialArtifactDeployer(this.startAwaiter, deployer, artifactConfiguration.get(Activator.PROPERTY_USER_REGION_ARTIFACTS), artifactConfiguration.get(Activator.PROPERTY_USER_REGION_COMMANDLINE_ARTIFACTS), uriNormaliser, eventAdmin, this.eventLogger, shutdown);
                Properties properties = new Properties();
                properties.put("event.topics", "org/eclipse/virgo/kernel/*");
                this.registrationTracker.track(this.context.registerService(EventHandler.class.getName(), (Object)initialArtifactDeployer, (Dictionary)properties));
                initialArtifactDeployer.deployArtifacts();
            }
            catch (TimeoutException te) {
                this.eventLogger.log((LogEvent)UserRegionLogEvents.KERNEL_SERVICE_NOT_AVAILABLE, (Throwable)te, new Object[]{30L});
                shutdown.immediateShutdown();
            }
            catch (InterruptedException ie) {
                this.eventLogger.log((LogEvent)UserRegionLogEvents.USERREGION_START_INTERRUPTED, (Throwable)ie, new Object[0]);
                shutdown.immediateShutdown();
            }
        }

        private Dictionary<String, String> getRegionArtifactConfiguration() {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)OsgiFrameworkUtils.getService((BundleContext)this.context, ConfigurationAdmin.class).getService();
            try {
                Configuration config = configAdmin.getConfiguration(USER_REGION_CONFIGURATION_PID);
                Dictionary properties = config.getProperties();
                return properties;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to read region artifact configuration", ioe);
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.Activator$InitialArtifactDeployerCreatingRunnable");
        }
    }

    private static final class ServiceScopingHookRegisteringRunnable
    implements Runnable {
        private final EventLogger eventLogger;
        private final BundleContext context;
        private final ServiceRegistrationTracker registrationTracker;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public ServiceScopingHookRegisteringRunnable(BundleContext context, ServiceRegistrationTracker registrationTracker, EventLogger eventLogger) {
            this.context = context;
            this.registrationTracker = registrationTracker;
            this.eventLogger = eventLogger;
        }

        public void run() {
            ScopeFactory scopeFactory = (ScopeFactory)OsgiFrameworkUtils.getService((BundleContext)this.context, ScopeFactory.class).getService();
            Shutdown shutdown = (Shutdown)OsgiFrameworkUtils.getService((BundleContext)this.context, Shutdown.class).getService();
            try {
                ScopeServiceRepository scopeServiceRepository = (ScopeServiceRepository)Activator.getPotentiallyDelayedService(this.context, ScopeServiceRepository.class);
                ServiceScopingStrategy serviceScopingStrategy = new ServiceScopingStrategy(scopeFactory, scopeServiceRepository);
                ServiceScopingRegistryHook serviceScopingRegistryHook = new ServiceScopingRegistryHook(serviceScopingStrategy);
                this.registrationTracker.track(this.context.registerService(new String[]{"org.osgi.framework.hooks.service.FindHook", "org.osgi.framework.hooks.service.EventHook"}, (Object)serviceScopingRegistryHook, null));
            }
            catch (TimeoutException te) {
                this.eventLogger.log((LogEvent)UserRegionLogEvents.KERNEL_SERVICE_NOT_AVAILABLE, (Throwable)te, new Object[]{30L});
                shutdown.immediateShutdown();
            }
            catch (InterruptedException ie) {
                this.eventLogger.log((LogEvent)UserRegionLogEvents.USERREGION_START_INTERRUPTED, (Throwable)ie, new Object[0]);
                shutdown.immediateShutdown();
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.Activator$ServiceScopingHookRegisteringRunnable");
        }
    }
}

