/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.util;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.util.Assert;

public abstract class OsgiPlatformDetector {
    private static final String[] EQUINOX_LABELS = new String[]{"Eclipse", "eclipse", "Equinox", "equinox"};
    private static final String[] KF_LABELS = new String[]{"Knopflerfish", "knopflerfish"};
    private static final String[] FELIX_LABELS = new String[]{"Apache Software Foundation", "Felix", "felix"};

    public static boolean isEquinox(BundleContext bundleContext) {
        return OsgiPlatformDetector.determinePlatform(bundleContext, EQUINOX_LABELS);
    }

    public static boolean isKnopflerfish(BundleContext bundleContext) {
        return OsgiPlatformDetector.determinePlatform(bundleContext, KF_LABELS);
    }

    public static boolean isFelix(BundleContext bundleContext) {
        return OsgiPlatformDetector.determinePlatform(bundleContext, FELIX_LABELS);
    }

    private static boolean determinePlatform(BundleContext context, String[] labels) {
        Assert.notNull((Object)context);
        Assert.notNull((Object)labels);
        String vendorProperty = context.getProperty("org.osgi.framework.vendor");
        if (vendorProperty == null) {
            return false;
        }
        return OsgiPlatformDetector.containsAnyOf(vendorProperty, labels);
    }

    private static boolean containsAnyOf(String source, String[] searchTerms) {
        for (int i = 0; i < searchTerms.length; ++i) {
            if (source.indexOf(searchTerms[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static String getVersion(BundleContext bundleContext) {
        if (bundleContext == null) {
            return "";
        }
        Bundle sysBundle = bundleContext.getBundle(0L);
        return "" + sysBundle.getHeaders().get("Bundle-Version");
    }
}

